/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util;

import org.springframework.lang.Nullable;

public abstract class RegexFlags {
    private static final int[] FLAG_LOOKUP = new int[65535];

    private RegexFlags() {
    }

    public static String toRegexOptions(int flags) {
        if (flags == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 97; i < 122; ++i) {
            if (FLAG_LOOKUP[i] == 0 || (flags & FLAG_LOOKUP[i]) <= 0) continue;
            buf.append((char)i);
        }
        return buf.toString();
    }

    public static int toRegexFlags(@Nullable String s2) {
        int flags = 0;
        if (s2 == null) {
            return flags;
        }
        for (char f : s2.toLowerCase().toCharArray()) {
            flags |= RegexFlags.toRegexFlag(f);
        }
        return flags;
    }

    public static int toRegexFlag(char c) {
        int flag = FLAG_LOOKUP[c];
        if (flag == 0) {
            throw new IllegalArgumentException(String.format("Unrecognized flag [%c]", Character.valueOf(c)));
        }
        return flag;
    }

    static {
        RegexFlags.FLAG_LOOKUP[103] = 256;
        RegexFlags.FLAG_LOOKUP[105] = 2;
        RegexFlags.FLAG_LOOKUP[109] = 8;
        RegexFlags.FLAG_LOOKUP[115] = 32;
        RegexFlags.FLAG_LOOKUP[99] = 128;
        RegexFlags.FLAG_LOOKUP[120] = 4;
        RegexFlags.FLAG_LOOKUP[100] = 1;
        RegexFlags.FLAG_LOOKUP[116] = 16;
        RegexFlags.FLAG_LOOKUP[117] = 64;
    }
}

