/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mongodb.MongoClientSettings;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.mongodb.document.AbstractMongodbQuery;
import com.querydsl.mongodb.document.MongodbDocumentSerializer;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.DocumentCodec;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.springframework.beans.DirectFieldAccessor;

abstract class SpringDataMongodbQuerySupport<Q extends SpringDataMongodbQuerySupport<Q>>
extends AbstractMongodbQuery<Q> {
    private final QueryMixin<Q> superQueryMixin;
    private static final JsonWriterSettings JSON_WRITER_SETTINGS = JsonWriterSettings.builder().outputMode(JsonMode.SHELL).build();
    private final MongodbDocumentSerializer serializer;

    SpringDataMongodbQuerySupport(MongodbDocumentSerializer serializer) {
        super(serializer);
        this.serializer = serializer;
        DirectFieldAccessor fieldAccessor = new DirectFieldAccessor((Object)this);
        this.superQueryMixin = (QueryMixin)fieldAccessor.getPropertyValue("queryMixin");
    }

    public String toString() {
        Document projection = this.createProjection(this.getQueryMixin().getMetadata().getProjection());
        Document sort = this.createSort(this.getQueryMixin().getMetadata().getOrderBy());
        DocumentCodec codec = new DocumentCodec(MongoClientSettings.getDefaultCodecRegistry());
        StringBuilder sb = new StringBuilder("find(" + this.asDocument().toJson(JSON_WRITER_SETTINGS, codec));
        if (projection != null && projection.isEmpty()) {
            sb.append(", ").append(projection.toJson(JSON_WRITER_SETTINGS, codec));
        }
        sb.append(")");
        if (!sort.isEmpty()) {
            sb.append(".sort(").append(sort.toJson(JSON_WRITER_SETTINGS, codec)).append(")");
        }
        if (this.getQueryMixin().getMetadata().getModifiers().getOffset() != null) {
            sb.append(".skip(").append(this.getQueryMixin().getMetadata().getModifiers().getOffset()).append(")");
        }
        if (this.getQueryMixin().getMetadata().getModifiers().getLimit() != null) {
            sb.append(".limit(").append(this.getQueryMixin().getMetadata().getModifiers().getLimit()).append(")");
        }
        return sb.toString();
    }

    public Document asDocument() {
        return this.createQuery(this.getQueryMixin().getMetadata().getWhere());
    }

    public String toJson() {
        return this.toJson(JSON_WRITER_SETTINGS);
    }

    public String toJson(JsonWriterSettings settings) {
        return this.asDocument().toJson(settings);
    }

    protected Document createSort(List<OrderSpecifier<?>> orderSpecifiers) {
        return this.serializer.toSort(orderSpecifiers);
    }
}

