/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.ReactiveFindOperation;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.ReactiveMongoRepository;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.ReactiveFluentQuerySupport;
import org.springframework.data.mongodb.repository.support.ReactivePageableExecutionUtils;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveMongoRepository<T, ID extends Serializable>
implements ReactiveMongoRepository<T, ID> {
    private final MongoEntityInformation<T, ID> entityInformation;
    private final ReactiveMongoOperations mongoOperations;

    public SimpleReactiveMongoRepository(MongoEntityInformation<T, ID> entityInformation, ReactiveMongoOperations mongoOperations) {
        Assert.notNull(entityInformation, "EntityInformation must not be null!");
        Assert.notNull((Object)mongoOperations, "MongoOperations must not be null!");
        this.entityInformation = entityInformation;
        this.mongoOperations = mongoOperations;
    }

    @Override
    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, "Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
        }
        return this.mongoOperations.save(entity, this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, "The given Iterable of entities must not be null!");
        Streamable<S> source = Streamable.of(entities);
        return source.stream().allMatch(this.entityInformation::isNew) ? this.mongoOperations.insert((Collection)source.stream().collect(Collectors.toList()), this.entityInformation.getCollectionName()) : Flux.fromIterable(entities).flatMap(this::save);
    }

    @Override
    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, "The given Publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(entity -> this.entityInformation.isNew(entity) ? this.mongoOperations.insert(entity, this.entityInformation.getCollectionName()) : this.mongoOperations.save(entity, this.entityInformation.getCollectionName()));
    }

    @Override
    public Mono<T> findById(ID id) {
        Assert.notNull(id, "The given id must not be null!");
        return this.mongoOperations.findById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    @Override
    public Mono<T> findById(Publisher<ID> publisher) {
        Assert.notNull(publisher, "The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.mongoOperations.findById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    @Override
    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, "The given id must not be null!");
        return this.mongoOperations.exists(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    @Override
    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        Assert.notNull(publisher, "The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.mongoOperations.exists(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    @Override
    public Flux<T> findAll() {
        return this.findAll(new Query());
    }

    @Override
    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, "The given Iterable of Id's must not be null!");
        return this.findAll(this.getIdQuery(ids));
    }

    @Override
    public Flux<T> findAllById(Publisher<ID> ids) {
        Assert.notNull(ids, "The given Publisher of Id's must not be null!");
        return Flux.from(ids).buffer().flatMap(this::findAllById);
    }

    @Override
    public Mono<Long> count() {
        return this.mongoOperations.count(new Query(), this.entityInformation.getCollectionName());
    }

    @Override
    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, "The given id must not be null!");
        return this.mongoOperations.remove(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()).then();
    }

    @Override
    public Mono<Void> deleteById(Publisher<ID> publisher) {
        Assert.notNull(publisher, "Id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.mongoOperations.remove(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName())).then();
    }

    @Override
    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, "The given entity must not be null!");
        Mono remove = this.mongoOperations.remove(entity, this.entityInformation.getCollectionName());
        if (this.entityInformation.isVersioned()) {
            remove = remove.handle((deleteResult, sink) -> {
                if (deleteResult.wasAcknowledged() && deleteResult.getDeletedCount() == 0L) {
                    sink.error((Throwable)new OptimisticLockingFailureException(String.format("The entity with id %s with version %s in %s cannot be deleted! Was it modified or deleted in the meantime?", this.entityInformation.getId(entity), this.entityInformation.getVersion(entity), this.entityInformation.getCollectionName())));
                } else {
                    sink.next(deleteResult);
                }
            });
        }
        return remove.then();
    }

    @Override
    public Mono<Void> deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, "The given Iterable of Id's must not be null!");
        return this.mongoOperations.remove(this.getIdQuery(ids), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()).then();
    }

    @Override
    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, "The given Iterable of entities must not be null!");
        Collection idCollection = StreamUtils.createStreamFromIterator(entities.iterator()).map(this.entityInformation::getId).collect(Collectors.toList());
        Criteria idsInCriteria = Criteria.where(this.entityInformation.getIdAttribute()).in(idCollection);
        return this.mongoOperations.remove(new Query(idsInCriteria), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()).then();
    }

    @Override
    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, "The given Publisher of entities must not be null!");
        return Flux.from(entityStream).map(this.entityInformation::getRequiredId).flatMap(this::deleteById).then();
    }

    @Override
    public Mono<Void> deleteAll() {
        return this.mongoOperations.remove(new Query(), this.entityInformation.getCollectionName()).then(Mono.empty());
    }

    @Override
    public Flux<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, "Sort must not be null!");
        return this.findAll(new Query().with(sort));
    }

    @Override
    public <S extends T> Mono<S> insert(S entity) {
        Assert.notNull(entity, "Entity must not be null!");
        return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Flux<S> insert(Iterable<S> entities) {
        Assert.notNull(entities, "The given Iterable of entities must not be null!");
        Collection<S> source = SimpleReactiveMongoRepository.toCollection(entities);
        return source.isEmpty() ? Flux.empty() : this.mongoOperations.insertAll(source);
    }

    @Override
    public <S extends T> Flux<S> insert(Publisher<S> entities) {
        Assert.notNull(entities, "The given Publisher of entities must not be null!");
        return Flux.from(entities).flatMap(entity -> this.mongoOperations.insert(entity, this.entityInformation.getCollectionName()));
    }

    @Override
    public <S extends T> Mono<S> findOne(Example<S> example) {
        Assert.notNull(example, "Sample must not be null!");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation()).limit(2);
        return this.mongoOperations.find(query, example.getProbeType(), this.entityInformation.getCollectionName()).buffer(2).map(vals -> {
            if (vals.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
            return vals.iterator().next();
        }).next();
    }

    @Override
    public <S extends T> Flux<S> findAll(Example<S> example) {
        Assert.notNull(example, "Example must not be null!");
        return this.findAll(example, Sort.unsorted());
    }

    @Override
    public <S extends T> Flux<S> findAll(Example<S> example, Sort sort) {
        Assert.notNull(example, "Sample must not be null!");
        Assert.notNull((Object)sort, "Sort must not be null!");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation()).with(sort);
        return this.mongoOperations.find(query, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Mono<Long> count(Example<S> example) {
        Assert.notNull(example, "Sample must not be null!");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation());
        return this.mongoOperations.count(query, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Mono<Boolean> exists(Example<S> example) {
        Assert.notNull(example, "Sample must not be null!");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation());
        return this.mongoOperations.exists(query, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T, R, P extends Publisher<R>> P findBy(Example<S> example, Function<FluentQuery.ReactiveFluentQuery<S>, P> queryFunction) {
        Assert.notNull(example, "Sample must not be null!");
        Assert.notNull(queryFunction, "Query function must not be null!");
        return (P)((Publisher)queryFunction.apply(new ReactiveFluentQueryByExample<S, S>(example, example.getProbeType())));
    }

    private Query getIdQuery(Object id) {
        return new Query(this.getIdCriteria(id));
    }

    private Criteria getIdCriteria(Object id) {
        return Criteria.where(this.entityInformation.getIdAttribute()).is(id);
    }

    private Query getIdQuery(Iterable<? extends ID> ids) {
        return new Query(Criteria.where(this.entityInformation.getIdAttribute()).in(SimpleReactiveMongoRepository.toCollection(ids)));
    }

    private static <E> Collection<E> toCollection(Iterable<E> ids) {
        return ids instanceof Collection ? (Collection)ids : (Collection)StreamUtils.createStreamFromIterator(ids.iterator()).collect(Collectors.toList());
    }

    private Flux<T> findAll(Query query) {
        return this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    class ReactiveFluentQueryByExample<S, T>
    extends ReactiveFluentQuerySupport<Example<S>, T> {
        ReactiveFluentQueryByExample(Example<S> example, Class<T> resultType) {
            this(example, Sort.unsorted(), resultType, Collections.emptyList());
        }

        ReactiveFluentQueryByExample(Example<S> example, Sort sort, Class<T> resultType, List<String> fieldsToInclude) {
            super(example, sort, resultType, fieldsToInclude);
        }

        @Override
        protected <R> ReactiveFluentQueryByExample<S, R> create(Example<S> predicate, Sort sort, Class<R> resultType, List<String> fieldsToInclude) {
            return new ReactiveFluentQueryByExample<S, R>(predicate, sort, resultType, fieldsToInclude);
        }

        @Override
        public Mono<T> one() {
            return this.createQuery().one();
        }

        @Override
        public Mono<T> first() {
            return this.createQuery().first();
        }

        @Override
        public Flux<T> all() {
            return this.createQuery().all();
        }

        @Override
        public Mono<Page<T>> page(Pageable pageable) {
            Assert.notNull((Object)pageable, "Pageable must not be null!");
            Mono items = this.createQuery(q -> q.with(pageable)).all().collectList();
            return items.flatMap(content -> ReactivePageableExecutionUtils.getPage(content, pageable, this.count()));
        }

        @Override
        public Mono<Long> count() {
            return this.createQuery().count();
        }

        @Override
        public Mono<Boolean> exists() {
            return this.createQuery().exists();
        }

        private ReactiveFindOperation.TerminatingFind<T> createQuery() {
            return this.createQuery(UnaryOperator.identity());
        }

        private ReactiveFindOperation.TerminatingFind<T> createQuery(UnaryOperator<Query> queryCustomizer) {
            Query query = new Query(new Criteria().alike((Example)this.getPredicate())).collation(SimpleReactiveMongoRepository.this.entityInformation.getCollation());
            if (this.getSort().isSorted()) {
                query.with(this.getSort());
            }
            if (!this.getFieldsToInclude().isEmpty()) {
                query.fields().include(this.getFieldsToInclude().toArray(new String[0]));
            }
            query = (Query)queryCustomizer.apply(query);
            return SimpleReactiveMongoRepository.this.mongoOperations.query(((Example)this.getPredicate()).getProbeType()).inCollection(SimpleReactiveMongoRepository.this.entityInformation.getCollectionName()).as(this.getResultType()).matching(query);
        }
    }
}

