/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.support.IndexEnsuringQueryCreationListener;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MongoRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    @Nullable
    private MongoOperations operations;
    private boolean createIndexesForQueryMethods = false;
    private boolean mappingContextConfigured = false;

    public MongoRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setMongoOperations(MongoOperations operations) {
        this.operations = operations;
    }

    public void setCreateIndexesForQueryMethods(boolean createIndexesForQueryMethods) {
        this.createIndexesForQueryMethods = createIndexesForQueryMethods;
    }

    @Override
    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    @Override
    protected RepositoryFactorySupport createRepositoryFactory() {
        RepositoryFactorySupport factory = this.getFactoryInstance(this.operations);
        if (this.createIndexesForQueryMethods) {
            factory.addQueryCreationListener(new IndexEnsuringQueryCreationListener((collectionName, javaType) -> this.operations.indexOps(javaType)));
        }
        return factory;
    }

    protected RepositoryFactorySupport getFactoryInstance(MongoOperations operations) {
        return new MongoRepositoryFactory(operations);
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.state(this.operations != null, "MongoTemplate must not be null!");
        if (!this.mappingContextConfigured) {
            this.setMappingContext(this.operations.getConverter().getMappingContext());
        }
    }
}

