/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mongodb.MongoException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.UncategorizedMongoDbException;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexOperationsProvider;
import org.springframework.data.mongodb.core.mapping.Unwrapped;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.repository.query.PartTreeMongoQuery;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class IndexEnsuringQueryCreationListener
implements QueryCreationListener<PartTreeMongoQuery> {
    private static final Set<Part.Type> GEOSPATIAL_TYPES = new HashSet<Part.Type>(Arrays.asList(Part.Type.NEAR, Part.Type.WITHIN));
    private static final Logger LOG = LoggerFactory.getLogger(IndexEnsuringQueryCreationListener.class);
    private final IndexOperationsProvider indexOperationsProvider;

    public IndexEnsuringQueryCreationListener(IndexOperationsProvider indexOperationsProvider) {
        Assert.notNull((Object)indexOperationsProvider, "IndexOperationsProvider must not be null!");
        this.indexOperationsProvider = indexOperationsProvider;
    }

    @Override
    public void onCreation(PartTreeMongoQuery query) {
        Index index;
        block9: {
            String collation;
            PartTree tree = query.getTree();
            if (!tree.hasPredicate()) {
                return;
            }
            index = new Index();
            index.named(query.getQueryMethod().getName());
            Sort sort = tree.getSort();
            for (Part part : tree.getParts()) {
                if (GEOSPATIAL_TYPES.contains((Object)part.getType())) {
                    return;
                }
                if (this.isIndexOnUnwrappedType(part)) {
                    return;
                }
                String property = part.getProperty().toDotPath();
                Sort.Direction order = IndexEnsuringQueryCreationListener.toDirection(sort, property);
                index.on(property, order);
            }
            if (sort.isSorted()) {
                for (Sort.Order order : sort) {
                    index.on(order.getProperty(), order.getDirection());
                }
            }
            if (query.getQueryMethod().hasAnnotatedCollation() && !(collation = query.getQueryMethod().getAnnotatedCollation()).contains("?")) {
                index = index.collation(Collation.parse(collation));
            }
            EntityMetadata metadata = query.getQueryMethod().getEntityInformation();
            try {
                this.indexOperationsProvider.indexOps(metadata.getCollectionName(), metadata.getJavaType()).ensureIndex(index);
            }
            catch (UncategorizedMongoDbException e) {
                if (!(e.getCause() instanceof MongoException) || ((MongoException)e.getCause()).getCode() == 85) break block9;
                throw e;
            }
        }
        LOG.debug(String.format("Created %s!", index));
    }

    public boolean isIndexOnUnwrappedType(Part part) {
        Field field = ReflectionUtils.findField(part.getProperty().getOwningType().getType(), part.getProperty().getSegment());
        if (field == null) {
            return false;
        }
        return AnnotatedElementUtils.hasAnnotation(field, Unwrapped.class);
    }

    private static Sort.Direction toDirection(Sort sort, String property) {
        if (sort.isUnsorted()) {
            return Sort.Direction.DESC;
        }
        Sort.Order order = sort.getOrderFor(property);
        return order == null ? Sort.Direction.DESC : (order.isAscending() ? Sort.Direction.ASC : Sort.Direction.DESC);
    }
}

