/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.util.Assert;

abstract class FetchableFluentQuerySupport<P, T>
implements FluentQuery.FetchableFluentQuery<T> {
    private final P predicate;
    private final Sort sort;
    private final Class<T> resultType;
    private final List<String> fieldsToInclude;

    FetchableFluentQuerySupport(P predicate, Sort sort, Class<T> resultType, List<String> fieldsToInclude) {
        this.predicate = predicate;
        this.sort = sort;
        this.resultType = resultType;
        this.fieldsToInclude = fieldsToInclude;
    }

    @Override
    public FluentQuery.FetchableFluentQuery<T> sortBy(Sort sort) {
        Assert.notNull((Object)sort, "Sort must not be null!");
        return this.create(this.predicate, sort, this.resultType, this.fieldsToInclude);
    }

    @Override
    public <R> FluentQuery.FetchableFluentQuery<R> as(Class<R> projection) {
        Assert.notNull(projection, "Projection target type must not be null!");
        return this.create(this.predicate, this.sort, projection, this.fieldsToInclude);
    }

    @Override
    public FluentQuery.FetchableFluentQuery<T> project(Collection<String> properties) {
        Assert.notNull(properties, "Projection properties must not be null!");
        return this.create(this.predicate, this.sort, this.resultType, new ArrayList<String>(properties));
    }

    protected abstract <R> FetchableFluentQuerySupport<P, R> create(P var1, Sort var2, Class<R> var3, List<String> var4);

    P getPredicate() {
        return this.predicate;
    }

    Sort getSort() {
        return this.sort;
    }

    Class<T> getResultType() {
        return this.resultType;
    }

    List<String> getFieldsToInclude() {
        return this.fieldsToInclude;
    }
}

