/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;

class CachingExpressionParser
implements ExpressionParser {
    private final ExpressionParser delegate;
    private final Map<String, Expression> cache = new ConcurrentHashMap<String, Expression>();

    CachingExpressionParser(ExpressionParser delegate) {
        this.delegate = delegate;
    }

    @Override
    public Expression parseExpression(String expressionString) throws ParseException {
        return this.cache.computeIfAbsent(expressionString, this.delegate::parseExpression);
    }

    @Override
    public Expression parseExpression(String expressionString, ParserContext context) throws ParseException {
        throw new UnsupportedOperationException("Parsing using ParserContext is not supported");
    }
}

