/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.mongodb.repository.query.AbstractReactiveMongoQuery;
import org.springframework.data.mongodb.repository.query.BooleanUtil;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.ExpressionParser;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveStringBasedMongoQuery
extends AbstractReactiveMongoQuery {
    private static final String COUNT_EXISTS_AND_DELETE = "Manually defined query for %s cannot be a count and exists or delete query at the same time!";
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveStringBasedMongoQuery.class);
    private final String query;
    private final String fieldSpec;
    private final ExpressionParser expressionParser;
    private final ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider;
    private final boolean isCountQuery;
    private final boolean isExistsQuery;
    private final boolean isDeleteQuery;

    public ReactiveStringBasedMongoQuery(ReactiveMongoQueryMethod method, ReactiveMongoOperations mongoOperations, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(method.getAnnotatedQuery(), method, mongoOperations, expressionParser, evaluationContextProvider);
    }

    public ReactiveStringBasedMongoQuery(String query, ReactiveMongoQueryMethod method, ReactiveMongoOperations mongoOperations, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, mongoOperations, expressionParser, evaluationContextProvider);
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.notNull((Object)expressionParser, "SpelExpressionParser must not be null!");
        this.query = query;
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        this.fieldSpec = method.getFieldSpecification();
        if (method.hasAnnotatedQuery()) {
            Query queryAnnotation = method.getQueryAnnotation();
            this.isCountQuery = queryAnnotation.count();
            this.isExistsQuery = queryAnnotation.exists();
            this.isDeleteQuery = queryAnnotation.delete();
            if (ReactiveStringBasedMongoQuery.hasAmbiguousProjectionFlags(this.isCountQuery, this.isExistsQuery, this.isDeleteQuery)) {
                throw new IllegalArgumentException(String.format(COUNT_EXISTS_AND_DELETE, method));
            }
        } else {
            this.isCountQuery = false;
            this.isExistsQuery = false;
            this.isDeleteQuery = false;
        }
    }

    @Override
    protected Mono<org.springframework.data.mongodb.core.query.Query> createQuery(ConvertingParameterAccessor accessor) {
        return this.getCodecRegistry().map(ParameterBindingDocumentCodec::new).flatMap(codec -> {
            Mono queryObject = this.getBindingContext(this.query, accessor, (ParameterBindingDocumentCodec)codec).map(context -> codec.decode(this.query, (ParameterBindingContext)context));
            Mono fieldsObject = this.getBindingContext(this.fieldSpec, accessor, (ParameterBindingDocumentCodec)codec).map(context -> codec.decode(this.fieldSpec, (ParameterBindingContext)context));
            return queryObject.zipWith(fieldsObject).map(tuple -> {
                org.springframework.data.mongodb.core.query.Query query = new BasicQuery((Document)tuple.getT1(), (Document)tuple.getT2()).with(accessor.getSort());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Created query %s for %s fields.", query.getQueryObject(), query.getFieldsObject()));
                }
                return query;
            });
        });
    }

    private Mono<ParameterBindingContext> getBindingContext(String json, ConvertingParameterAccessor accessor, ParameterBindingDocumentCodec codec) {
        ExpressionDependencies dependencies = codec.captureExpressionDependencies(json, accessor::getBindableValue, this.expressionParser);
        return this.getSpelEvaluatorFor(dependencies, accessor).map(it -> new ParameterBindingContext(accessor::getBindableValue, (SpELExpressionEvaluator)it));
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    @Override
    protected boolean isExistsQuery() {
        return this.isExistsQuery;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.isDeleteQuery;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }

    private static boolean hasAmbiguousProjectionFlags(boolean isCountQuery, boolean isExistsQuery, boolean isDeleteQuery) {
        return BooleanUtil.countBooleanTrueValues(isCountQuery, isExistsQuery, isDeleteQuery) > 1;
    }
}

