/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.reactivestreams.Publisher;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractReactiveMongoQuery;
import org.springframework.data.mongodb.repository.query.AggregationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.ExpressionParser;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveStringBasedAggregation
extends AbstractReactiveMongoQuery {
    private final ExpressionParser expressionParser;
    private final ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider;
    private final ReactiveMongoOperations reactiveMongoOperations;
    private final MongoConverter mongoConverter;

    public ReactiveStringBasedAggregation(ReactiveMongoQueryMethod method, ReactiveMongoOperations reactiveMongoOperations, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, reactiveMongoOperations, expressionParser, evaluationContextProvider);
        this.reactiveMongoOperations = reactiveMongoOperations;
        this.mongoConverter = reactiveMongoOperations.getConverter();
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    @Override
    protected Publisher<Object> doExecute(ReactiveMongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, Class<?> typeToRead) {
        return this.computePipeline(accessor).flatMapMany(it -> {
            Class<?> sourceType = method.getDomainClass();
            Class<Document> targetType = typeToRead;
            List pipeline = it;
            AggregationUtils.appendSortIfPresent(pipeline, accessor, typeToRead);
            AggregationUtils.appendLimitAndOffsetIfPresent(pipeline, accessor);
            boolean isSimpleReturnType = this.isSimpleReturnType(typeToRead);
            boolean isRawReturnType = ClassUtils.isAssignable(Document.class, typeToRead);
            if (isSimpleReturnType || isRawReturnType) {
                targetType = Document.class;
            }
            AggregationOptions options = this.computeOptions(method, accessor);
            TypedAggregation aggregation = new TypedAggregation(sourceType, pipeline, options);
            Mono flux = this.reactiveMongoOperations.aggregate(aggregation, targetType);
            if (isSimpleReturnType && !isRawReturnType) {
                flux = flux.handle((item, sink) -> {
                    Object result = AggregationUtils.extractSimpleTypeResult((Document)item, typeToRead, this.mongoConverter);
                    if (result != null) {
                        sink.next(result);
                    }
                });
            }
            return method.isCollectionQuery() ? flux : flux.next();
        });
    }

    private boolean isSimpleReturnType(Class<?> targetType) {
        return MongoSimpleTypes.HOLDER.isSimpleType(targetType);
    }

    private Mono<List<AggregationOperation>> computePipeline(ConvertingParameterAccessor accessor) {
        return this.getCodecRegistry().map(ParameterBindingDocumentCodec::new).flatMap(codec -> {
            String[] sourcePipeline = this.getQueryMethod().getAnnotatedAggregation();
            ArrayList<Mono<AggregationOperation>> stages = new ArrayList<Mono<AggregationOperation>>(sourcePipeline.length);
            for (String source : sourcePipeline) {
                stages.add(this.computePipelineStage(source, accessor, (ParameterBindingDocumentCodec)codec));
            }
            return Flux.concat(stages).collectList();
        });
    }

    private Mono<AggregationOperation> computePipelineStage(String source, ConvertingParameterAccessor accessor, ParameterBindingDocumentCodec codec) {
        ExpressionDependencies dependencies = codec.captureExpressionDependencies(source, accessor::getBindableValue, this.expressionParser);
        return this.getSpelEvaluatorFor(dependencies, accessor).map(it -> {
            ParameterBindingContext bindingContext = new ParameterBindingContext(accessor::getBindableValue, (SpELExpressionEvaluator)it);
            return ctx -> ctx.getMappedObject(codec.decode(source, bindingContext), this.getQueryMethod().getDomainClass());
        });
    }

    private AggregationOptions computeOptions(MongoQueryMethod method, ConvertingParameterAccessor accessor) {
        AggregationOptions.Builder builder = Aggregation.newAggregationOptions();
        AggregationUtils.applyCollation(builder, method.getAnnotatedCollation(), accessor, method.getParameters(), this.expressionParser, this.evaluationContextProvider);
        AggregationUtils.applyMeta(builder, method);
        return builder.build();
    }

    @Override
    protected Mono<Query> createQuery(ConvertingParameterAccessor accessor) {
        throw new UnsupportedOperationException("No query support for aggregation");
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

