/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.client.result.DeleteResult;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@FunctionalInterface
interface MongoQueryExecution {
    public Object execute(Query var1);

    public static final class DeleteExecution
    implements MongoQueryExecution {
        private final MongoOperations operations;
        private final MongoQueryMethod method;

        public DeleteExecution(MongoOperations operations, MongoQueryMethod method) {
            Assert.notNull((Object)operations, "Operations must not be null!");
            Assert.notNull((Object)method, "Method must not be null!");
            this.operations = operations;
            this.method = method;
        }

        @Override
        public Object execute(Query query) {
            String collectionName = this.method.getEntityInformation().getCollectionName();
            Class type = this.method.getEntityInformation().getJavaType();
            if (this.method.isCollectionQuery()) {
                return this.operations.findAllAndRemove(query, type, collectionName);
            }
            if (this.method.isQueryForEntity() && !ClassUtils.isPrimitiveOrWrapper(this.method.getReturnedObjectType())) {
                return this.operations.findAndRemove(query, type, collectionName);
            }
            DeleteResult writeResult = this.operations.remove(query, type, collectionName);
            return writeResult.wasAcknowledged() ? writeResult.getDeletedCount() : 0L;
        }
    }

    public static final class PagingGeoNearExecution
    extends GeoNearExecution {
        private final ExecutableFindOperation.FindWithQuery<?> operation;
        private final ConvertingParameterAccessor accessor;
        private final AbstractMongoQuery mongoQuery;

        PagingGeoNearExecution(ExecutableFindOperation.FindWithQuery<?> operation, MongoQueryMethod method, ConvertingParameterAccessor accessor, AbstractMongoQuery query) {
            super(operation, method, accessor);
            this.accessor = accessor;
            this.operation = operation;
            this.mongoQuery = query;
        }

        @Override
        public Object execute(Query query) {
            GeoResults<Object> geoResults = this.doExecuteQuery(query);
            Page<GeoResult<Object>> page = PageableExecutionUtils.getPage(geoResults.getContent(), this.accessor.getPageable(), () -> {
                Query countQuery = this.mongoQuery.createCountQuery(this.accessor);
                countQuery = this.mongoQuery.applyQueryMetaAttributesWhenPresent(countQuery);
                return this.operation.matching(countQuery).count();
            });
            return new GeoPage<Object>(geoResults, this.accessor.getPageable(), page.getTotalElements());
        }
    }

    public static class GeoNearExecution
    implements MongoQueryExecution {
        private final ExecutableFindOperation.FindWithQuery<?> operation;
        private final MongoQueryMethod method;
        private final MongoParameterAccessor accessor;

        public GeoNearExecution(ExecutableFindOperation.FindWithQuery<?> operation, MongoQueryMethod method, MongoParameterAccessor accessor) {
            Assert.notNull(operation, "Operation must not be null!");
            Assert.notNull((Object)method, "Method must not be null!");
            Assert.notNull((Object)accessor, "Accessor must not be null!");
            this.operation = operation;
            this.method = method;
            this.accessor = accessor;
        }

        @Override
        public Object execute(Query query) {
            GeoResults<Object> results = this.doExecuteQuery(query);
            return GeoNearExecution.isListOfGeoResult(this.method.getReturnType()) ? results.getContent() : results;
        }

        GeoResults<Object> doExecuteQuery(Query query) {
            Point nearLocation = this.accessor.getGeoNearLocation();
            NearQuery nearQuery = NearQuery.near(nearLocation);
            if (query != null) {
                nearQuery.query(query);
            }
            Range<Distance> distances = this.accessor.getDistanceRange();
            distances.getLowerBound().getValue().ifPresent(it -> nearQuery.minDistance((Distance)it).in(it.getMetric()));
            distances.getUpperBound().getValue().ifPresent(it -> nearQuery.maxDistance((Distance)it).in(it.getMetric()));
            Pageable pageable = this.accessor.getPageable();
            nearQuery.with(pageable);
            return this.operation.near(nearQuery).all();
        }

        private static boolean isListOfGeoResult(TypeInformation<?> returnType) {
            if (!returnType.getType().equals(List.class)) {
                return false;
            }
            TypeInformation<?> componentType = returnType.getComponentType();
            return componentType != null && GeoResult.class.equals(componentType.getType());
        }
    }

    public static final class PagedExecution
    implements MongoQueryExecution {
        private final ExecutableFindOperation.FindWithQuery<?> operation;
        private final Pageable pageable;

        public PagedExecution(ExecutableFindOperation.FindWithQuery<?> operation, Pageable pageable) {
            Assert.notNull(operation, "Operation must not be null!");
            Assert.notNull((Object)pageable, "Pageable must not be null!");
            this.operation = operation;
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query) {
            int overallLimit = query.getLimit();
            ExecutableFindOperation.TerminatingFind<?> matching = this.operation.matching(query);
            query.with(this.pageable);
            if (overallLimit != 0 && this.pageable.getOffset() + (long)this.pageable.getPageSize() > (long)overallLimit) {
                query.limit((int)((long)overallLimit - this.pageable.getOffset()));
            }
            return PageableExecutionUtils.getPage(matching.all(), this.pageable, () -> {
                long count = this.operation.matching(Query.of(query).skip(-1L).limit(-1)).count();
                return overallLimit != 0 ? Math.min(count, (long)overallLimit) : count;
            });
        }
    }

    public static final class SlicedExecution
    implements MongoQueryExecution {
        private final ExecutableFindOperation.FindWithQuery<?> find;
        private final Pageable pageable;

        public SlicedExecution(ExecutableFindOperation.FindWithQuery<?> find, Pageable pageable) {
            Assert.notNull(find, "Find must not be null!");
            Assert.notNull((Object)pageable, "Pageable must not be null!");
            this.find = find;
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query) {
            int pageSize = this.pageable.getPageSize();
            Query modifiedQuery = query.with(this.pageable).limit(pageSize + 1);
            List<?> result = this.find.matching(modifiedQuery).all();
            boolean hasNext = result.size() > pageSize;
            return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, this.pageable, hasNext);
        }
    }
}

