/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;

class DefaultSpELExpressionEvaluator
implements SpELExpressionEvaluator {
    private final ExpressionParser parser;
    private final EvaluationContext context;

    DefaultSpELExpressionEvaluator(ExpressionParser parser, EvaluationContext context) {
        this.parser = parser;
        this.context = context;
    }

    public static SpELExpressionEvaluator unsupported() {
        return NoOpExpressionEvaluator.INSTANCE;
    }

    @Override
    public <T> T evaluate(String expression) {
        return (T)this.parser.parseExpression(expression).getValue(this.context, Object.class);
    }

    static enum NoOpExpressionEvaluator implements SpELExpressionEvaluator
    {
        INSTANCE;


        @Override
        public <T> T evaluate(String expression) {
            throw new UnsupportedOperationException("Expression evaluation not supported");
        }
    }
}

