/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.util.Assert;

public class MongoRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<MongoOperations> operations;

    public MongoRepositoryBean(Bean<MongoOperations> operations, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, Optional<CustomRepositoryImplementationDetector> detector) {
        super(qualifiers, repositoryType, beanManager, detector);
        Assert.notNull(operations, "MongoOperations bean must not be null!");
        this.operations = operations;
    }

    @Override
    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        MongoOperations mongoOperations = this.getDependencyInstance(this.operations, MongoOperations.class);
        return ((CdiRepositoryBean)this).create(() -> new MongoRepositoryFactory(mongoOperations), repositoryType);
    }
}

