/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.client.MongoClient;
import java.net.UnknownHostException;
import org.springframework.data.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;
import org.springframework.util.StringUtils;

@ManagedResource(description="Server Information")
public class ServerInfo
extends AbstractMonitor {
    protected ServerInfo(MongoClient mongoClient) {
        super(mongoClient);
    }

    @ManagedOperation(description="Server host name")
    public String getHostName() throws UnknownHostException {
        return StringUtils.collectionToDelimitedString(this.hosts(), ",");
    }

    @ManagedMetric(displayName="Uptime Estimate")
    public double getUptimeEstimate() {
        return (Double)this.getServerStatus().get("uptimeEstimate");
    }

    @ManagedOperation(description="MongoDB Server Version")
    public String getVersion() {
        return (String)this.getServerStatus().get("version");
    }

    @ManagedOperation(description="Local Time")
    public String getLocalTime() {
        return (String)this.getServerStatus().get("localTime");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Server uptime in seconds", unit="seconds")
    public double getUptime() {
        return (Double)this.getServerStatus().get("uptime");
    }
}

