/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.gridfs.GridFSBucket;
import com.mongodb.reactivestreams.client.gridfs.GridFSBuckets;
import com.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import com.mongodb.reactivestreams.client.gridfs.GridFSUploadPublisher;
import java.nio.ByteBuffer;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.gridfs.AntPath;
import org.springframework.data.mongodb.gridfs.GridFsCriteria;
import org.springframework.data.mongodb.gridfs.GridFsObject;
import org.springframework.data.mongodb.gridfs.GridFsOperationsSupport;
import org.springframework.data.mongodb.gridfs.ReactiveGridFsOperations;
import org.springframework.data.mongodb.gridfs.ReactiveGridFsResource;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveGridFsTemplate
extends GridFsOperationsSupport
implements ReactiveGridFsOperations {
    private final ReactiveMongoDatabaseFactory dbFactory;
    private final DataBufferFactory dataBufferFactory;
    @Nullable
    private final String bucket;

    public ReactiveGridFsTemplate(ReactiveMongoDatabaseFactory dbFactory, MongoConverter converter) {
        this(dbFactory, converter, null);
    }

    public ReactiveGridFsTemplate(ReactiveMongoDatabaseFactory dbFactory, MongoConverter converter, @Nullable String bucket) {
        this(new DefaultDataBufferFactory(), dbFactory, converter, bucket);
    }

    public ReactiveGridFsTemplate(DataBufferFactory dataBufferFactory, ReactiveMongoDatabaseFactory dbFactory, MongoConverter converter, @Nullable String bucket) {
        super(converter);
        Assert.notNull((Object)dataBufferFactory, "DataBufferFactory must not be null!");
        Assert.notNull((Object)dbFactory, "ReactiveMongoDatabaseFactory must not be null!");
        this.dataBufferFactory = dataBufferFactory;
        this.dbFactory = dbFactory;
        this.bucket = bucket;
    }

    @Override
    public Mono<ObjectId> store(Publisher<DataBuffer> content, @Nullable String filename, @Nullable String contentType, @Nullable Object metadata) {
        return this.store(content, filename, contentType, this.toDocument(metadata));
    }

    @Override
    public <T> Mono<T> store(GridFsObject<T, Publisher<DataBuffer>> upload) {
        GridFSUploadOptions uploadOptions = this.computeUploadOptionsFor(upload.getOptions().getContentType(), upload.getOptions().getMetadata());
        if (upload.getOptions().getChunkSize() > 0) {
            uploadOptions.chunkSizeBytes(upload.getOptions().getChunkSize());
        }
        String filename = upload.getFilename();
        Flux source = Flux.from(upload.getContent()).map(DataBuffer::asByteBuffer);
        T fileId = upload.getFileId();
        if (fileId == null) {
            return this.createMono(new AutoIdCreatingUploadCallback(filename, (Publisher<ByteBuffer>)source, uploadOptions));
        }
        UploadCallback callback = new UploadCallback(BsonUtils.simpleToBsonValue(fileId), filename, (Publisher<ByteBuffer>)source, uploadOptions);
        return this.createMono(callback).thenReturn(fileId);
    }

    @Override
    public Flux<GridFSFile> find(Query query) {
        Document queryObject = this.getMappedQuery(query.getQueryObject());
        Document sortObject = this.getMappedQuery(query.getSortObject());
        return this.createFlux(new FindCallback(query, queryObject, sortObject));
    }

    @Override
    public Mono<GridFSFile> findOne(Query query) {
        Document queryObject = this.getMappedQuery(query.getQueryObject());
        Document sortObject = this.getMappedQuery(query.getSortObject());
        return this.createFlux(new FindLimitCallback(query, queryObject, sortObject, 2)).collectList().handle((files, sink) -> {
            if (files.size() == 1) {
                sink.next(files.get(0));
                return;
            }
            if (files.size() > 1) {
                sink.error((Throwable)new IncorrectResultSizeDataAccessException("Query " + SerializationUtils.serializeToJsonSafely(query) + " returned non unique result.", 1));
            }
        });
    }

    @Override
    public Mono<GridFSFile> findFirst(Query query) {
        Document queryObject = this.getMappedQuery(query.getQueryObject());
        Document sortObject = this.getMappedQuery(query.getSortObject());
        return this.createFlux(new FindLimitCallback(query, queryObject, sortObject, 1)).next();
    }

    @Override
    public Mono<Void> delete(Query query) {
        return this.find(query).flatMap(it -> this.createMono(new DeleteCallback(it.getId()))).then();
    }

    @Override
    public Mono<ReactiveGridFsResource> getResource(String location) {
        Assert.notNull((Object)location, "Filename must not be null!");
        return this.findOne(Query.query(GridFsCriteria.whereFilename().is(location))).flatMap(this::getResource).defaultIfEmpty((Object)ReactiveGridFsResource.absent(location));
    }

    @Override
    public Mono<ReactiveGridFsResource> getResource(GridFSFile file) {
        Assert.notNull((Object)file, "GridFSFile must not be null!");
        return this.doGetBucket().map(it -> new ReactiveGridFsResource(file, it.downloadToPublisher(file.getId()), this.dataBufferFactory));
    }

    @Override
    public Flux<ReactiveGridFsResource> getResources(String locationPattern) {
        if (!StringUtils.hasText(locationPattern)) {
            return Flux.empty();
        }
        AntPath path = new AntPath(locationPattern);
        if (path.isPattern()) {
            Flux<GridFSFile> files = this.find(Query.query(GridFsCriteria.whereFilename().regex(path.toRegex())));
            return files.flatMap(this::getResource);
        }
        return this.getResource(locationPattern).flux();
    }

    public <T> Mono<T> createMono(ReactiveBucketCallback<T> callback) {
        Assert.notNull(callback, "ReactiveBucketCallback must not be null!");
        return this.doGetBucket().flatMap(bucket -> Mono.from(callback.doInBucket((GridFSBucket)bucket)));
    }

    public <T> Flux<T> createFlux(ReactiveBucketCallback<T> callback) {
        Assert.notNull(callback, "ReactiveBucketCallback must not be null!");
        return this.doGetBucket().flatMapMany(callback::doInBucket);
    }

    protected Mono<GridFSBucket> doGetBucket() {
        return this.dbFactory.getMongoDatabase().map(db -> this.bucket == null ? GridFSBuckets.create((MongoDatabase)db) : GridFSBuckets.create((MongoDatabase)db, (String)this.bucket));
    }

    private static class DeleteCallback
    implements ReactiveBucketCallback<Void> {
        private final BsonValue id;

        public DeleteCallback(BsonValue id) {
            this.id = id;
        }

        @Override
        public Publisher<Void> doInBucket(GridFSBucket bucket) {
            return bucket.delete(this.id);
        }
    }

    private static class AutoIdCreatingUploadCallback
    implements ReactiveBucketCallback<ObjectId> {
        private final String filename;
        private final Publisher<ByteBuffer> source;
        private final GridFSUploadOptions uploadOptions;

        public AutoIdCreatingUploadCallback(String filename, Publisher<ByteBuffer> source, GridFSUploadOptions uploadOptions) {
            this.filename = filename;
            this.source = source;
            this.uploadOptions = uploadOptions;
        }

        @Override
        public GridFSUploadPublisher<ObjectId> doInBucket(GridFSBucket bucket) {
            return bucket.uploadFromPublisher(this.filename, this.source, this.uploadOptions);
        }
    }

    private static class UploadCallback
    implements ReactiveBucketCallback<Void> {
        private final BsonValue fileId;
        private final String filename;
        private final Publisher<ByteBuffer> source;
        private final GridFSUploadOptions uploadOptions;

        public UploadCallback(BsonValue fileId, String filename, Publisher<ByteBuffer> source, GridFSUploadOptions uploadOptions) {
            this.fileId = fileId;
            this.filename = filename;
            this.source = source;
            this.uploadOptions = uploadOptions;
        }

        @Override
        public GridFSUploadPublisher<Void> doInBucket(GridFSBucket bucket) {
            return bucket.uploadFromPublisher(this.fileId, this.filename, this.source, this.uploadOptions);
        }
    }

    private static class FindLimitCallback
    extends FindCallback {
        private final int limit;

        public FindLimitCallback(Query query, Document queryObject, Document sortObject, int limit) {
            super(query, queryObject, sortObject);
            this.limit = limit;
        }

        @Override
        public GridFSFindPublisher doInBucket(GridFSBucket bucket) {
            return super.doInBucket(bucket).limit(this.limit);
        }
    }

    private static class FindCallback
    implements ReactiveBucketCallback<GridFSFile> {
        private final Query query;
        private final Document queryObject;
        private final Document sortObject;

        public FindCallback(Query query, Document queryObject, Document sortObject) {
            this.query = query;
            this.queryObject = queryObject;
            this.sortObject = sortObject;
        }

        public GridFSFindPublisher doInBucket(GridFSBucket bucket) {
            Integer cursorBatchSize;
            GridFSFindPublisher findPublisher = bucket.find((Bson)this.queryObject).sort((Bson)this.sortObject);
            if (this.query.getLimit() > 0) {
                findPublisher = findPublisher.limit(this.query.getLimit());
            }
            if (this.query.getSkip() > 0L) {
                findPublisher = findPublisher.skip(Math.toIntExact(this.query.getSkip()));
            }
            if ((cursorBatchSize = this.query.getMeta().getCursorBatchSize()) != null) {
                findPublisher = findPublisher.batchSize(cursorBatchSize.intValue());
            }
            return findPublisher;
        }
    }

    static interface ReactiveBucketCallback<T> {
        public Publisher<T> doInBucket(GridFSBucket var1);
    }
}

