/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsObject;
import org.springframework.data.mongodb.gridfs.ReactiveGridFsResource;
import org.springframework.data.mongodb.gridfs.ReactiveGridFsUpload;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveGridFsOperations {
    default public Mono<ObjectId> store(Publisher<DataBuffer> content, String filename) {
        return this.store(content, filename, (Object)null);
    }

    default public Mono<ObjectId> store(Publisher<DataBuffer> content, @Nullable Object metadata) {
        return this.store(content, null, metadata);
    }

    default public Mono<ObjectId> store(Publisher<DataBuffer> content, @Nullable Document metadata) {
        return this.store(content, null, metadata);
    }

    default public Mono<ObjectId> store(Publisher<DataBuffer> content, @Nullable String filename, @Nullable String contentType) {
        return this.store(content, filename, contentType, (Object)null);
    }

    default public Mono<ObjectId> store(Publisher<DataBuffer> content, @Nullable String filename, @Nullable Object metadata) {
        return this.store(content, filename, null, metadata);
    }

    public Mono<ObjectId> store(Publisher<DataBuffer> var1, @Nullable String var2, @Nullable String var3, @Nullable Object var4);

    default public Mono<ObjectId> store(Publisher<DataBuffer> content, @Nullable String filename, @Nullable Document metadata) {
        return this.store(content, filename, null, metadata);
    }

    default public Mono<ObjectId> store(Publisher<DataBuffer> content, @Nullable String filename, @Nullable String contentType, @Nullable Document metadata) {
        ReactiveGridFsUpload.ReactiveGridFsUploadBuilder<ObjectId> uploadBuilder = ReactiveGridFsUpload.fromPublisher(content);
        if (StringUtils.hasText(filename)) {
            uploadBuilder.filename(filename);
        }
        if (!ObjectUtils.isEmpty(metadata)) {
            uploadBuilder.metadata(metadata);
        }
        if (StringUtils.hasText(contentType)) {
            uploadBuilder.contentType(contentType);
        }
        return this.store(uploadBuilder.build());
    }

    public <T> Mono<T> store(GridFsObject<T, Publisher<DataBuffer>> var1);

    public Flux<GridFSFile> find(Query var1);

    public Mono<GridFSFile> findOne(Query var1);

    public Mono<GridFSFile> findFirst(Query var1);

    public Mono<Void> delete(Query var1);

    public Mono<ReactiveGridFsResource> getResource(String var1);

    public Mono<ReactiveGridFsResource> getResource(GridFSFile var1);

    public Flux<ReactiveGridFsResource> getResources(String var1);
}

