/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.InputStream;
import java.util.function.Supplier;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.gridfs.GridFsObject;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class GridFsUpload<ID>
implements GridFsObject<ID, InputStream> {
    @Nullable
    private final ID id;
    private final Lazy<InputStream> dataStream;
    private final String filename;
    private final GridFsObject.Options options;

    private GridFsUpload(@Nullable ID id, Lazy<InputStream> dataStream, String filename, GridFsObject.Options options) {
        Assert.notNull(dataStream, "Data Stream must not be null");
        Assert.notNull((Object)filename, "Filename must not be null");
        Assert.notNull((Object)options, "Options must not be null");
        this.id = id;
        this.dataStream = dataStream;
        this.filename = filename;
        this.options = options;
    }

    @Override
    @Nullable
    public ID getFileId() {
        return this.id;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public InputStream getContent() {
        return this.dataStream.orElse(StreamUtils.emptyInput());
    }

    @Override
    public GridFsObject.Options getOptions() {
        return this.options;
    }

    public static GridFsUploadBuilder<ObjectId> fromStream(InputStream stream) {
        return new GridFsUploadBuilder().content(stream);
    }

    public static class GridFsUploadBuilder<T> {
        private Object id;
        private Lazy<InputStream> dataStream;
        private String filename;
        private GridFsObject.Options options = GridFsObject.Options.none();

        private GridFsUploadBuilder() {
        }

        public GridFsUploadBuilder<T> content(InputStream stream) {
            Assert.notNull((Object)stream, "InputStream must not be null");
            return this.content(() -> stream);
        }

        public GridFsUploadBuilder<T> content(Supplier<InputStream> stream) {
            Assert.notNull(stream, "InputStream Supplier must not be null");
            this.dataStream = Lazy.of(stream);
            return this;
        }

        public <T1> GridFsUploadBuilder<T1> id(T1 id) {
            this.id = id;
            return this;
        }

        public GridFsUploadBuilder<T> filename(String filename) {
            this.filename = filename;
            return this;
        }

        public GridFsUploadBuilder<T> options(GridFsObject.Options options) {
            Assert.notNull((Object)options, "Options must not be null");
            this.options = options;
            return this;
        }

        public GridFsUploadBuilder<T> metadata(Document metadata) {
            this.options = this.options.metadata(metadata);
            return this;
        }

        public GridFsUploadBuilder<T> chunkSize(int chunkSize) {
            this.options = this.options.chunkSize(chunkSize);
            return this;
        }

        public GridFsUploadBuilder<T> gridFsFile(GridFSFile gridFSFile) {
            Assert.notNull((Object)gridFSFile, "GridFSFile must not be null");
            this.id = gridFSFile.getId();
            this.filename = gridFSFile.getFilename();
            this.options = this.options.metadata(gridFSFile.getMetadata());
            this.options = this.options.chunkSize(gridFSFile.getChunkSize());
            return this;
        }

        public GridFsUploadBuilder<T> contentType(String contentType) {
            this.options = this.options.contentType(contentType);
            return this;
        }

        public GridFsUpload<T> build() {
            return new GridFsUpload(this.id, this.dataStream, this.filename, this.options);
        }
    }
}

