/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.springframework.core.io.InputStreamResource;
import org.springframework.data.mongodb.gridfs.GridFsObject;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GridFsResource
extends InputStreamResource
implements GridFsObject<Object, InputStream> {
    static final String CONTENT_TYPE_FIELD = "_contentType";
    private static final ByteArrayInputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    @Nullable
    private final GridFSFile file;
    private final String filename;

    private GridFsResource(String filename) {
        super(EMPTY_INPUT_STREAM, String.format("GridFs resource [%s]", filename));
        this.file = null;
        this.filename = filename;
    }

    public GridFsResource(GridFSFile file) {
        this(file, new ByteArrayInputStream(new byte[0]));
    }

    public GridFsResource(GridFSFile file, InputStream inputStream) {
        super(inputStream, String.format("GridFs resource [%s]", file.getFilename()));
        this.file = file;
        this.filename = file.getFilename();
    }

    public static GridFsResource absent(String filename) {
        Assert.notNull((Object)filename, "Filename must not be null");
        return new GridFsResource(filename);
    }

    @Override
    public InputStream getInputStream() throws IOException, IllegalStateException {
        this.verifyExists();
        return super.getInputStream();
    }

    @Override
    public long contentLength() throws IOException {
        this.verifyExists();
        return this.getGridFSFile().getLength();
    }

    @Override
    public String getFilename() throws IllegalStateException {
        return this.filename;
    }

    @Override
    public boolean exists() {
        return this.file != null;
    }

    @Override
    public long lastModified() throws IOException {
        this.verifyExists();
        return this.getGridFSFile().getUploadDate().getTime();
    }

    @Override
    public String getDescription() {
        return String.format("GridFs resource [%s]", this.getFilename());
    }

    public Object getId() {
        Assert.state(this.exists(), () -> String.format("%s does not exist.", this.getDescription()));
        return this.getGridFSFile().getId();
    }

    @Override
    public Object getFileId() {
        Assert.state(this.exists(), () -> String.format("%s does not exist.", this.getDescription()));
        return BsonUtils.toJavaType(this.getGridFSFile().getId());
    }

    @Nullable
    public GridFSFile getGridFSFile() {
        return this.file;
    }

    public String getContentType() {
        Assert.state(this.exists(), () -> String.format("%s does not exist.", this.getDescription()));
        return Optional.ofNullable(this.getGridFSFile().getMetadata()).map(it -> (String)((Object)it.get((Object)CONTENT_TYPE_FIELD, String.class))).orElseThrow(() -> new MongoGridFSException("No contentType data for this GridFS file"));
    }

    @Override
    public InputStream getContent() {
        try {
            return this.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to obtain input stream for " + this.filename, e);
        }
    }

    @Override
    public GridFsObject.Options getOptions() {
        return GridFsObject.Options.from(this.getGridFSFile());
    }

    private void verifyExists() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(String.format("%s does not exist.", this.getDescription()));
        }
    }
}

