/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class GridFsOperationsSupport {
    private final QueryMapper queryMapper;
    private final MongoConverter converter;

    GridFsOperationsSupport(MongoConverter converter) {
        Assert.notNull((Object)converter, "MongoConverter must not be null!");
        this.converter = converter;
        this.queryMapper = new QueryMapper(converter);
    }

    protected Document getMappedQuery(Document query) {
        return this.queryMapper.getMappedObject((Bson)query, Optional.empty());
    }

    protected GridFSUploadOptions computeUploadOptionsFor(@Nullable String contentType, @Nullable Document metadata) {
        Document targetMetadata = new Document();
        if (StringUtils.hasText(contentType)) {
            targetMetadata.put("_contentType", (Object)contentType);
        }
        if (metadata != null) {
            targetMetadata.putAll(metadata);
        }
        GridFSUploadOptions options = new GridFSUploadOptions();
        options.metadata(targetMetadata);
        return options;
    }

    protected Document toDocument(@Nullable Object value) {
        if (value instanceof Document) {
            return (Document)value;
        }
        Document document = new Document();
        if (value != null) {
            this.converter.write(value, document);
        }
        return document;
    }
}

