/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

class AntPath {
    private static final String PREFIX_DELIMITER = ":";
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("\\?|\\*\\*|\\*");
    private final String path;

    public AntPath(String path) {
        Assert.notNull((Object)path, "Path must not be null!");
        this.path = path;
    }

    public boolean isPattern() {
        String path = AntPath.stripPrefix(this.path);
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    private static String stripPrefix(String path) {
        int index = path.indexOf(PREFIX_DELIMITER);
        return index > -1 ? path.substring(index + 1) : path;
    }

    public String toRegex() {
        StringBuilder patternBuilder = new StringBuilder();
        Matcher m4 = WILDCARD_PATTERN.matcher(this.path);
        int end = 0;
        while (m4.find()) {
            patternBuilder.append(AntPath.quote(this.path, end, m4.start()));
            String match = m4.group();
            if ("?".equals(match)) {
                patternBuilder.append('.');
            } else if ("**".equals(match)) {
                patternBuilder.append(".*");
            } else if ("*".equals(match)) {
                patternBuilder.append("[^/]*");
            }
            end = m4.end();
        }
        patternBuilder.append(AntPath.quote(this.path, end, this.path.length()));
        return patternBuilder.toString();
    }

    private static String quote(String s2, int start, int end) {
        if (start == end) {
            return "";
        }
        return Pattern.quote(s2.substring(start, end));
    }

    public String toString() {
        return this.path;
    }
}

