/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.validation;

import org.bson.Document;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class DocumentValidator
implements Validator {
    private final Document validatorObject;

    private DocumentValidator(Document validatorObject) {
        this.validatorObject = validatorObject;
    }

    static DocumentValidator of(Document validatorObject) {
        Assert.notNull((Object)validatorObject, "ValidatorObject must not be null!");
        return new DocumentValidator(new Document(validatorObject));
    }

    @Override
    public Document toDocument() {
        return new Document(this.validatorObject);
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.validatorObject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentValidator that = (DocumentValidator)o;
        return ObjectUtils.nullSafeEquals(this.validatorObject, that.validatorObject);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.validatorObject);
    }
}

