/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.util.Set;
import org.bson.Document;
import org.springframework.data.mongodb.core.schema.DefaultMongoJsonSchema;
import org.springframework.data.mongodb.core.schema.DocumentJsonSchema;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.JsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.TypedJsonSchemaObject;
import org.springframework.lang.Nullable;

public interface MongoJsonSchema {
    default public Document toDocument() {
        return new Document("$jsonSchema", this.schemaDocument());
    }

    public Document schemaDocument();

    public static MongoJsonSchema of(JsonSchemaObject root) {
        return new DefaultMongoJsonSchema(root);
    }

    public static MongoJsonSchema of(Document document) {
        return new DocumentJsonSchema(document);
    }

    public static MongoJsonSchemaBuilder builder() {
        return new MongoJsonSchemaBuilder();
    }

    public static class MongoJsonSchemaBuilder {
        private TypedJsonSchemaObject.ObjectJsonSchemaObject root = new TypedJsonSchemaObject.ObjectJsonSchemaObject();
        @Nullable
        private Document encryptionMetadata;

        MongoJsonSchemaBuilder() {
        }

        public MongoJsonSchemaBuilder minProperties(int count) {
            this.root = this.root.minProperties(count);
            return this;
        }

        public MongoJsonSchemaBuilder maxProperties(int count) {
            this.root = this.root.maxProperties(count);
            return this;
        }

        public MongoJsonSchemaBuilder required(String ... properties) {
            this.root = this.root.required(properties);
            return this;
        }

        public MongoJsonSchemaBuilder additionalProperties(boolean additionalPropertiesAllowed) {
            this.root = this.root.additionalProperties(additionalPropertiesAllowed);
            return this;
        }

        public MongoJsonSchemaBuilder additionalProperties(TypedJsonSchemaObject.ObjectJsonSchemaObject schema) {
            this.root = this.root.additionalProperties(schema);
            return this;
        }

        public MongoJsonSchemaBuilder properties(JsonSchemaProperty ... properties) {
            this.root = this.root.properties(properties);
            return this;
        }

        public MongoJsonSchemaBuilder patternProperties(JsonSchemaProperty ... properties) {
            this.root = this.root.patternProperties(properties);
            return this;
        }

        public MongoJsonSchemaBuilder property(JsonSchemaProperty property) {
            this.root = this.root.property(property);
            return this;
        }

        public MongoJsonSchemaBuilder possibleValues(Set<Object> possibleValues) {
            this.root = this.root.possibleValues(possibleValues);
            return this;
        }

        public MongoJsonSchemaBuilder allOf(Set<JsonSchemaObject> allOf) {
            this.root = this.root.allOf(allOf);
            return this;
        }

        public MongoJsonSchemaBuilder anyOf(Set<JsonSchemaObject> anyOf) {
            this.root = this.root.anyOf(anyOf);
            return this;
        }

        public MongoJsonSchemaBuilder oneOf(Set<JsonSchemaObject> oneOf) {
            this.root = this.root.oneOf(oneOf);
            return this;
        }

        public MongoJsonSchemaBuilder notMatch(JsonSchemaObject notMatch) {
            this.root = this.root.notMatch(notMatch);
            return this;
        }

        public MongoJsonSchemaBuilder description(String description) {
            this.root = this.root.description(description);
            return this;
        }

        public void encryptionMetadata(@Nullable Document encryptionMetadata) {
            this.encryptionMetadata = encryptionMetadata;
        }

        public MongoJsonSchema build() {
            return new DefaultMongoJsonSchema(this.root, this.encryptionMetadata);
        }
    }
}

