/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import org.bson.Document;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class DefaultMongoJsonSchema
implements MongoJsonSchema {
    private final JsonSchemaObject root;
    @Nullable
    private final Document encryptionMetadata;

    DefaultMongoJsonSchema(JsonSchemaObject root) {
        this(root, null);
    }

    DefaultMongoJsonSchema(JsonSchemaObject root, @Nullable Document encryptionMetadata) {
        Assert.notNull((Object)root, "Root schema object must not be null!");
        this.root = root;
        this.encryptionMetadata = encryptionMetadata;
    }

    @Override
    public Document schemaDocument() {
        Document schemaDocument = new Document();
        if (!CollectionUtils.isEmpty(this.encryptionMetadata)) {
            schemaDocument.append("encryptMetadata", this.encryptionMetadata);
        }
        schemaDocument.putAll(this.root.toDocument());
        return schemaDocument;
    }
}

