/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class Term {
    private final Type type;
    private final String raw;
    private boolean negated;

    public Term(String raw) {
        this(raw, Type.WORD);
    }

    public Term(String raw, @Nullable Type type) {
        this.raw = raw;
        this.type = type == null ? Type.WORD : type;
    }

    public Term negate() {
        this.negated = true;
        return this;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public Type getType() {
        return this.type;
    }

    public String getFormatted() {
        String formatted = Type.PHRASE.equals((Object)this.type) ? this.quotePhrase(this.raw) : this.raw;
        return this.negated ? this.negateRaw(formatted) : formatted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Term)) {
            return false;
        }
        Term term = (Term)o;
        return ObjectUtils.nullSafeEquals(this.negated, term.negated) && ObjectUtils.nullSafeEquals((Object)this.type, (Object)term.type) && ObjectUtils.nullSafeEquals(this.raw, term.raw);
    }

    public int hashCode() {
        int result = 17;
        result += ObjectUtils.nullSafeHashCode((Object)this.type);
        result += ObjectUtils.nullSafeHashCode(this.raw);
        return result += ObjectUtils.nullSafeHashCode(this.negated);
    }

    public String toString() {
        return this.getFormatted();
    }

    protected String quotePhrase(String raw) {
        return "\"" + raw + "\"";
    }

    protected String negateRaw(String raw) {
        return "-" + raw;
    }

    public static enum Type {
        WORD,
        PHRASE;

    }
}

