/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bson.Document;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public abstract class SerializationUtils {
    private SerializationUtils() {
    }

    public static Map<String, Object> flattenMap(@Nullable Document source) {
        if (source == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        SerializationUtils.toFlatMap("", source, result);
        return result;
    }

    private static void toFlatMap(String currentPath, Object source, Map<String, Object> map) {
        if (source instanceof Document) {
            String pathPrefix;
            Document document = (Document)source;
            Iterator<Map.Entry<String, Object>> it = document.entrySet().iterator();
            String string = pathPrefix = currentPath.isEmpty() ? "" : currentPath + '.';
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                if (entry.getKey().startsWith("$")) {
                    if (map.containsKey(currentPath)) {
                        ((Document)map.get(currentPath)).put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    map.put(currentPath, new Document(entry.getKey(), entry.getValue()));
                    continue;
                }
                SerializationUtils.toFlatMap(pathPrefix + entry.getKey(), entry.getValue(), map);
            }
        } else {
            map.put(currentPath, source);
        }
    }

    @Nullable
    public static String serializeToJsonSafely(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        try {
            String json = value instanceof Document ? ((Document)value).toJson() : SerializationUtils.serializeValue(value);
            return json.replaceAll("\":", "\" :").replaceAll("\\{\"", "{ \"");
        }
        catch (Exception e) {
            if (value instanceof Collection) {
                return SerializationUtils.toString((Collection)value);
            }
            if (value instanceof Map) {
                return SerializationUtils.toString((Map)value);
            }
            if (ObjectUtils.isArray(value)) {
                return SerializationUtils.toString(Arrays.asList(ObjectUtils.toObjectArray(value)));
            }
            return String.format("{ \"$java\" : %s }", value.toString());
        }
    }

    public static String serializeValue(@Nullable Object value) {
        if (value == null) {
            return "null";
        }
        String documentJson = new Document("toBeEncoded", value).toJson();
        return documentJson.substring(documentJson.indexOf(58) + 1, documentJson.length() - 1).trim();
    }

    private static String toString(Map<?, ?> source) {
        return SerializationUtils.iterableToDelimitedString(source.entrySet(), "{ ", " }", entry -> String.format("\"%s\" : %s", entry.getKey(), SerializationUtils.serializeToJsonSafely(entry.getValue())));
    }

    private static String toString(Collection<?> source) {
        return SerializationUtils.iterableToDelimitedString(source, "[ ", " ]", SerializationUtils::serializeToJsonSafely);
    }

    private static <T> String iterableToDelimitedString(Iterable<T> source, String prefix, String postfix, Converter<? super T, Object> transformer) {
        StringBuilder builder = new StringBuilder(prefix);
        Iterator<T> iterator = source.iterator();
        while (iterator.hasNext()) {
            builder.append(transformer.convert(iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append(postfix).toString();
    }
}

