/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import java.time.Duration;
import java.time.Instant;
import org.bson.BsonValue;
import org.bson.Document;
import org.springframework.data.mongodb.core.ChangeStreamOptions;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.messaging.MessageListener;
import org.springframework.data.mongodb.core.messaging.SubscriptionRequest;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ChangeStreamRequest<T>
implements SubscriptionRequest<ChangeStreamDocument<Document>, T, ChangeStreamRequestOptions> {
    private final MessageListener<ChangeStreamDocument<Document>, ? super T> messageListener;
    private final ChangeStreamRequestOptions options;

    public ChangeStreamRequest(MessageListener<ChangeStreamDocument<Document>, ? super T> messageListener, SubscriptionRequest.RequestOptions options) {
        Assert.notNull(messageListener, "MessageListener must not be null!");
        Assert.notNull((Object)options, "Options must not be null!");
        this.options = options instanceof ChangeStreamRequestOptions ? (ChangeStreamRequestOptions)options : ChangeStreamRequestOptions.of(options);
        this.messageListener = messageListener;
    }

    @Override
    public MessageListener<ChangeStreamDocument<Document>, ? super T> getMessageListener() {
        return this.messageListener;
    }

    @Override
    public ChangeStreamRequestOptions getRequestOptions() {
        return this.options;
    }

    public static ChangeStreamRequestBuilder builder() {
        return new ChangeStreamRequestBuilder();
    }

    public static <T> ChangeStreamRequestBuilder<T> builder(MessageListener<ChangeStreamDocument<Document>, ? super T> listener) {
        ChangeStreamRequestBuilder<? super T> builder = new ChangeStreamRequestBuilder<T>();
        return builder.publishTo(listener);
    }

    public static class ChangeStreamRequestBuilder<T> {
        @Nullable
        private String databaseName;
        @Nullable
        private String collectionName;
        @Nullable
        private Duration maxAwaitTime;
        @Nullable
        private MessageListener<ChangeStreamDocument<Document>, ? super T> listener;
        private final ChangeStreamOptions.ChangeStreamOptionsBuilder delegate = ChangeStreamOptions.builder();

        private ChangeStreamRequestBuilder() {
        }

        public ChangeStreamRequestBuilder<T> database(String databaseName) {
            Assert.hasText(databaseName, "DatabaseName must not be null!");
            this.databaseName = databaseName;
            return this;
        }

        public ChangeStreamRequestBuilder<T> collection(String collectionName) {
            Assert.hasText(collectionName, "CollectionName must not be null!");
            this.collectionName = collectionName;
            return this;
        }

        public ChangeStreamRequestBuilder<T> publishTo(MessageListener<ChangeStreamDocument<Document>, ? super T> messageListener) {
            Assert.notNull(messageListener, "MessageListener must not be null!");
            this.listener = messageListener;
            return this;
        }

        public ChangeStreamRequestBuilder<T> filter(Aggregation aggregation) {
            Assert.notNull((Object)aggregation, "Aggregation must not be null!");
            this.delegate.filter(aggregation);
            return this;
        }

        public ChangeStreamRequestBuilder<T> filter(Document ... pipeline) {
            Assert.notNull((Object)pipeline, "Aggregation pipeline must not be null!");
            Assert.noNullElements((Object[])pipeline, "Aggregation pipeline must not contain null elements!");
            this.delegate.filter(pipeline);
            return this;
        }

        public ChangeStreamRequestBuilder<T> collation(Collation collation) {
            Assert.notNull((Object)collation, "Collation must not be null!");
            this.delegate.collation(collation);
            return this;
        }

        public ChangeStreamRequestBuilder<T> resumeToken(BsonValue resumeToken) {
            Assert.notNull((Object)resumeToken, "Resume token not be null!");
            this.delegate.resumeToken(resumeToken);
            return this;
        }

        public ChangeStreamRequestBuilder<T> resumeAt(Instant clusterTime) {
            Assert.notNull((Object)clusterTime, "ClusterTime must not be null!");
            this.delegate.resumeAt(clusterTime);
            return this;
        }

        public ChangeStreamRequestBuilder<T> resumeAfter(BsonValue resumeToken) {
            Assert.notNull((Object)resumeToken, "ResumeToken must not be null!");
            this.delegate.resumeAfter(resumeToken);
            return this;
        }

        public ChangeStreamRequestBuilder<T> startAfter(BsonValue resumeToken) {
            Assert.notNull((Object)resumeToken, "ResumeToken must not be null!");
            this.delegate.startAfter(resumeToken);
            return this;
        }

        public ChangeStreamRequestBuilder<T> fullDocumentLookup(FullDocument lookup) {
            Assert.notNull((Object)lookup, "FullDocument not be null!");
            this.delegate.fullDocumentLookup(lookup);
            return this;
        }

        public ChangeStreamRequestBuilder<T> maxAwaitTime(Duration timeout) {
            Assert.notNull((Object)timeout, "timeout not be null!");
            this.maxAwaitTime = timeout;
            return this;
        }

        public ChangeStreamRequest<T> build() {
            Assert.notNull(this.listener, "MessageListener must not be null!");
            return new ChangeStreamRequest<T>(this.listener, new ChangeStreamRequestOptions(this.databaseName, this.collectionName, this.maxAwaitTime, this.delegate.build()));
        }
    }

    public static class ChangeStreamRequestOptions
    implements SubscriptionRequest.RequestOptions {
        @Nullable
        private final String databaseName;
        @Nullable
        private final String collectionName;
        @Nullable
        private final Duration maxAwaitTime;
        private final ChangeStreamOptions options;

        public ChangeStreamRequestOptions(@Nullable String databaseName, @Nullable String collectionName, ChangeStreamOptions options) {
            this(databaseName, collectionName, null, options);
        }

        public ChangeStreamRequestOptions(@Nullable String databaseName, @Nullable String collectionName, @Nullable Duration maxAwaitTime, ChangeStreamOptions options) {
            Assert.notNull((Object)options, "Options must not be null!");
            this.collectionName = collectionName;
            this.databaseName = databaseName;
            this.maxAwaitTime = maxAwaitTime;
            this.options = options;
        }

        public static ChangeStreamRequestOptions of(SubscriptionRequest.RequestOptions options) {
            Assert.notNull((Object)options, "Options must not be null!");
            return new ChangeStreamRequestOptions(options.getDatabaseName(), options.getCollectionName(), ChangeStreamOptions.builder().build());
        }

        public ChangeStreamOptions getChangeStreamOptions() {
            return this.options;
        }

        @Override
        public String getCollectionName() {
            return this.collectionName;
        }

        @Override
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public Duration maxAwaitTime() {
            return this.maxAwaitTime != null ? this.maxAwaitTime : SubscriptionRequest.RequestOptions.super.maxAwaitTime();
        }
    }
}

