/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import java.util.Iterator;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.mapreduce.MapReduceCounts;
import org.springframework.data.mongodb.core.mapreduce.MapReduceTiming;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MapReduceResults<T>
implements Iterable<T> {
    private final List<T> mappedResults;
    @Nullable
    private final Document rawResults;
    @Nullable
    private final String outputCollection;
    private final MapReduceTiming mapReduceTiming;
    private final MapReduceCounts mapReduceCounts;

    public MapReduceResults(List<T> mappedResults, Document rawResults) {
        Assert.notNull(mappedResults, "List of mapped results must not be null!");
        Assert.notNull((Object)rawResults, "Raw results must not be null!");
        this.mappedResults = mappedResults;
        this.rawResults = rawResults;
        this.mapReduceTiming = MapReduceResults.parseTiming(rawResults);
        this.mapReduceCounts = MapReduceResults.parseCounts(rawResults);
        this.outputCollection = MapReduceResults.parseOutputCollection(rawResults);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mappedResults.iterator();
    }

    public MapReduceTiming getTiming() {
        return this.mapReduceTiming;
    }

    public MapReduceCounts getCounts() {
        return this.mapReduceCounts;
    }

    @Nullable
    public String getOutputCollection() {
        return this.outputCollection;
    }

    @Nullable
    public Document getRawResults() {
        return this.rawResults;
    }

    private static MapReduceTiming parseTiming(Document rawResults) {
        Document timing = (Document)rawResults.get("timing");
        if (timing == null) {
            return new MapReduceTiming(-1L, -1L, -1L);
        }
        if (timing.get("mapTime") != null && timing.get("emitLoop") != null && timing.get("total") != null) {
            return new MapReduceTiming(MapReduceResults.getAsLong(timing, "mapTime"), MapReduceResults.getAsLong(timing, "emitLoop"), MapReduceResults.getAsLong(timing, "total"));
        }
        return new MapReduceTiming(-1L, -1L, -1L);
    }

    private static Long getAsLong(Document source, String key) {
        Object raw = source.get(key);
        return raw instanceof Long ? (Long)raw : (long)((Integer)raw).intValue();
    }

    private static MapReduceCounts parseCounts(Document rawResults) {
        Document counts = (Document)rawResults.get("counts");
        if (counts == null) {
            return MapReduceCounts.NONE;
        }
        if (counts.get("input") != null && counts.get("emit") != null && counts.get("output") != null) {
            return new MapReduceCounts(MapReduceResults.getAsLong(counts, "input"), MapReduceResults.getAsLong(counts, "emit"), MapReduceResults.getAsLong(counts, "output"));
        }
        return MapReduceCounts.NONE;
    }

    @Nullable
    private static String parseOutputCollection(Document rawResults) {
        Object resultField = rawResults.get("result");
        if (resultField == null) {
            return null;
        }
        return resultField instanceof Document ? ((Document)resultField).get("collection").toString() : resultField.toString();
    }
}

