/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import com.mongodb.client.model.MapReduceAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;

public class MapReduceOptions {
    @Nullable
    private String outputCollection;
    private Optional<String> outputDatabase = Optional.empty();
    @Nullable
    private MapReduceAction mapReduceAction = MapReduceAction.REPLACE;
    private Map<String, Object> scopeVariables = new HashMap<String, Object>();
    private Map<String, Object> extraOptions = new HashMap<String, Object>();
    @Nullable
    private Boolean jsMode;
    private Boolean verbose = Boolean.TRUE;
    @Nullable
    private Integer limit;
    private Optional<Boolean> outputSharded = Optional.empty();
    private Optional<String> finalizeFunction = Optional.empty();
    private Optional<Collation> collation = Optional.empty();

    public static MapReduceOptions options() {
        return new MapReduceOptions();
    }

    public MapReduceOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public MapReduceOptions outputCollection(String collectionName) {
        this.outputCollection = collectionName;
        return this;
    }

    public MapReduceOptions outputDatabase(@Nullable String outputDatabase) {
        this.outputDatabase = Optional.ofNullable(outputDatabase);
        return this;
    }

    @Deprecated
    public MapReduceOptions outputTypeInline() {
        return this.actionInline();
    }

    public MapReduceOptions actionInline() {
        this.mapReduceAction = null;
        return this;
    }

    @Deprecated
    public MapReduceOptions outputTypeMerge() {
        return this.actionMerge();
    }

    public MapReduceOptions actionMerge() {
        this.mapReduceAction = MapReduceAction.MERGE;
        return this;
    }

    @Deprecated
    public MapReduceOptions outputTypeReduce() {
        return this.actionReduce();
    }

    public MapReduceOptions actionReduce() {
        this.mapReduceAction = MapReduceAction.REDUCE;
        return this;
    }

    @Deprecated
    public MapReduceOptions outputTypeReplace() {
        return this.actionReplace();
    }

    public MapReduceOptions actionReplace() {
        this.mapReduceAction = MapReduceAction.REPLACE;
        return this;
    }

    public MapReduceOptions outputSharded(boolean outputShared) {
        this.outputSharded = Optional.of(outputShared);
        return this;
    }

    public MapReduceOptions finalizeFunction(@Nullable String finalizeFunction) {
        this.finalizeFunction = Optional.ofNullable(finalizeFunction);
        return this;
    }

    public MapReduceOptions scopeVariables(Map<String, Object> scopeVariables) {
        this.scopeVariables = scopeVariables;
        return this;
    }

    public MapReduceOptions javaScriptMode(boolean javaScriptMode) {
        this.jsMode = javaScriptMode;
        return this;
    }

    public MapReduceOptions verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Deprecated
    public MapReduceOptions extraOption(String key, Object value) {
        this.extraOptions.put(key, value);
        return this;
    }

    public MapReduceOptions collation(@Nullable Collation collation) {
        this.collation = Optional.ofNullable(collation);
        return this;
    }

    @Deprecated
    public Map<String, Object> getExtraOptions() {
        return this.extraOptions;
    }

    public Optional<String> getFinalizeFunction() {
        return this.finalizeFunction;
    }

    @Nullable
    public Boolean getJavaScriptMode() {
        return this.jsMode;
    }

    @Nullable
    public String getOutputCollection() {
        return this.outputCollection;
    }

    public Optional<String> getOutputDatabase() {
        return this.outputDatabase;
    }

    public Optional<Boolean> getOutputSharded() {
        return this.outputSharded;
    }

    public Map<String, Object> getScopeVariables() {
        return this.scopeVariables;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    public Optional<Collation> getCollation() {
        return this.collation;
    }

    @Nullable
    public MapReduceAction getMapReduceAction() {
        return this.mapReduceAction;
    }

    public boolean usesInlineOutput() {
        return null == this.mapReduceAction;
    }

    public Document getOptionsObject() {
        Document cmd = new Document();
        if (this.verbose != null) {
            cmd.put("verbose", (Object)this.verbose);
        }
        cmd.put("out", (Object)this.createOutObject());
        this.finalizeFunction.ifPresent(val -> cmd.append("finalize", val));
        if (this.scopeVariables != null) {
            cmd.put("scope", (Object)this.scopeVariables);
        }
        if (this.limit != null) {
            cmd.put("limit", (Object)this.limit);
        }
        if (!this.extraOptions.keySet().isEmpty()) {
            cmd.putAll((Map<? extends String, ?>)this.extraOptions);
        }
        this.getCollation().ifPresent(val -> cmd.append("collation", val.toDocument()));
        return cmd;
    }

    protected Document createOutObject() {
        Document out = new Document();
        if (this.getMapReduceAction() == null) {
            out.put("inline", (Object)1);
        } else {
            switch (this.getMapReduceAction()) {
                case REPLACE: {
                    out.put("replace", (Object)this.outputCollection);
                    break;
                }
                case MERGE: {
                    out.put("merge", (Object)this.outputCollection);
                    break;
                }
                case REDUCE: {
                    out.put("reduce", (Object)this.outputCollection);
                }
            }
        }
        this.outputDatabase.ifPresent(val -> out.append("db", val));
        this.outputSharded.ifPresent(val -> out.append("sharded", val));
        return out;
    }
}

