/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.DocumentReference;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.UnwrapEntityContext;
import org.springframework.data.mongodb.core.mapping.Unwrapped;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

class UnwrappedMongoPersistentProperty
implements MongoPersistentProperty {
    private final MongoPersistentProperty delegate;
    private final UnwrapEntityContext context;

    public UnwrappedMongoPersistentProperty(MongoPersistentProperty delegate, UnwrapEntityContext context) {
        this.delegate = delegate;
        this.context = context;
    }

    @Override
    public String getFieldName() {
        if (!this.context.getProperty().isUnwrapped()) {
            return this.delegate.getFieldName();
        }
        return this.context.getProperty().findAnnotation(Unwrapped.class).prefix() + this.delegate.getFieldName();
    }

    @Override
    public Class<?> getFieldType() {
        return this.delegate.getFieldType();
    }

    @Override
    public int getFieldOrder() {
        return this.delegate.getFieldOrder();
    }

    @Override
    public boolean writeNullValues() {
        return this.delegate.writeNullValues();
    }

    @Override
    public boolean isDbReference() {
        return this.delegate.isDbReference();
    }

    @Override
    public boolean isDocumentReference() {
        return this.delegate.isDocumentReference();
    }

    @Override
    public boolean isExplicitIdProperty() {
        return this.delegate.isExplicitIdProperty();
    }

    @Override
    public boolean isLanguageProperty() {
        return this.delegate.isLanguageProperty();
    }

    @Override
    public boolean isExplicitLanguageProperty() {
        return this.delegate.isExplicitLanguageProperty();
    }

    @Override
    public boolean isTextScoreProperty() {
        return this.delegate.isTextScoreProperty();
    }

    @Override
    @Nullable
    public DBRef getDBRef() {
        return this.delegate.getDBRef();
    }

    @Override
    @Nullable
    public DocumentReference getDocumentReference() {
        return this.delegate.getDocumentReference();
    }

    @Override
    public boolean usePropertyAccess() {
        return this.delegate.usePropertyAccess();
    }

    @Override
    public boolean hasExplicitWriteTarget() {
        return this.delegate.hasExplicitWriteTarget();
    }

    @Override
    public PersistentEntity<?, MongoPersistentProperty> getOwner() {
        return this.delegate.getOwner();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public Class<?> getType() {
        return this.delegate.getType();
    }

    @Override
    public TypeInformation<?> getTypeInformation() {
        return this.delegate.getTypeInformation();
    }

    @Override
    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypes() {
        return this.delegate.getPersistentEntityTypes();
    }

    @Override
    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypeInformation() {
        return this.delegate.getPersistentEntityTypeInformation();
    }

    @Override
    @Nullable
    public Method getGetter() {
        return this.delegate.getGetter();
    }

    @Override
    public Method getRequiredGetter() {
        return this.delegate.getRequiredGetter();
    }

    @Override
    @Nullable
    public Method getSetter() {
        return this.delegate.getSetter();
    }

    @Override
    public Method getRequiredSetter() {
        return this.delegate.getRequiredSetter();
    }

    @Override
    @Nullable
    public Method getWither() {
        return this.delegate.getWither();
    }

    @Override
    public Method getRequiredWither() {
        return this.delegate.getRequiredWither();
    }

    @Override
    @Nullable
    public Field getField() {
        return this.delegate.getField();
    }

    @Override
    public Field getRequiredField() {
        return this.delegate.getRequiredField();
    }

    @Override
    @Nullable
    public String getSpelExpression() {
        return this.delegate.getSpelExpression();
    }

    @Override
    @Nullable
    public Association<MongoPersistentProperty> getAssociation() {
        return this.delegate.getAssociation();
    }

    @Override
    public Association<MongoPersistentProperty> getRequiredAssociation() {
        return this.delegate.getRequiredAssociation();
    }

    @Override
    public boolean isEntity() {
        return this.delegate.isEntity();
    }

    @Override
    public boolean isIdProperty() {
        return this.delegate.isIdProperty();
    }

    @Override
    public boolean isVersionProperty() {
        return this.delegate.isVersionProperty();
    }

    @Override
    public boolean isCollectionLike() {
        return this.delegate.isCollectionLike();
    }

    @Override
    public boolean isMap() {
        return this.delegate.isMap();
    }

    @Override
    public boolean isArray() {
        return this.delegate.isArray();
    }

    @Override
    public boolean isTransient() {
        return this.delegate.isTransient();
    }

    @Override
    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    @Override
    public boolean isImmutable() {
        return this.delegate.isImmutable();
    }

    @Override
    public boolean isAssociation() {
        return this.delegate.isAssociation();
    }

    @Override
    public boolean isUnwrapped() {
        return this.delegate.isUnwrapped();
    }

    @Override
    public Collection<Object> getEncryptionKeyIds() {
        return this.delegate.getEncryptionKeyIds();
    }

    @Override
    @Nullable
    public Class<?> getComponentType() {
        return this.delegate.getComponentType();
    }

    @Override
    public Class<?> getRawType() {
        return this.delegate.getRawType();
    }

    @Override
    @Nullable
    public Class<?> getMapValueType() {
        return this.delegate.getMapValueType();
    }

    @Override
    public Class<?> getActualType() {
        return this.delegate.getActualType();
    }

    @Override
    @Nullable
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return this.delegate.findAnnotation(annotationType);
    }

    @Override
    public <A extends Annotation> A getRequiredAnnotation(Class<A> annotationType) throws IllegalStateException {
        return this.delegate.getRequiredAnnotation(annotationType);
    }

    @Override
    @Nullable
    public <A extends Annotation> A findPropertyOrOwnerAnnotation(Class<A> annotationType) {
        return this.delegate.findPropertyOrOwnerAnnotation(annotationType);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.delegate.isAnnotationPresent(annotationType);
    }

    @Override
    public boolean hasActualTypeAnnotation(Class<? extends Annotation> annotationType) {
        return this.delegate.hasActualTypeAnnotation(annotationType);
    }

    @Override
    @Nullable
    public Class<?> getAssociationTargetType() {
        return this.delegate.getAssociationTargetType();
    }

    @Override
    public TypeInformation<?> getAssociationTargetTypeInformation() {
        return this.delegate.getAssociationTargetTypeInformation();
    }

    @Override
    public <T> PersistentPropertyAccessor<T> getAccessorForOwner(T owner) {
        return this.delegate.getAccessorForOwner(owner);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnwrappedMongoPersistentProperty that = (UnwrappedMongoPersistentProperty)obj;
        if (!ObjectUtils.nullSafeEquals(this.delegate, that.delegate)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.context, that.context);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.delegate);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.context);
        return result;
    }
}

