/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import org.bson.Document;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.util.Assert;

public class HashedIndex
implements IndexDefinition {
    private final String field;

    private HashedIndex(String field) {
        Assert.hasText(field, "Field must not be null nor empty!");
        this.field = field;
    }

    public static HashedIndex hashed(String field) {
        return new HashedIndex(field);
    }

    @Override
    public Document getIndexKeys() {
        return new Document(this.field, "hashed");
    }

    @Override
    public Document getIndexOptions() {
        return new Document();
    }
}

