/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import org.springframework.data.mongodb.core.convert.ReferenceLookupDelegate;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@FunctionalInterface
public interface ReferenceResolver {
    @Nullable
    public Object resolveReference(MongoPersistentProperty var1, Object var2, ReferenceLookupDelegate var3, MongoEntityReader var4);

    @FunctionalInterface
    public static interface MongoEntityReader {
        public Object read(Object var1, TypeInformation<?> var2);
    }

    public static class ReferenceCollection {
        @Nullable
        private final String database;
        private final String collection;

        public ReferenceCollection(@Nullable String database, String collection) {
            Assert.hasText(collection, "Collection must not be empty or null!");
            this.database = database;
            this.collection = collection;
        }

        public static ReferenceCollection fromDBRef(DBRef dbRef) {
            return new ReferenceCollection(dbRef.getDatabaseName(), dbRef.getCollectionName());
        }

        public String getCollection() {
            return this.collection;
        }

        @Nullable
        public String getDatabase() {
            return this.database;
        }
    }
}

