/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.client.MongoCollection;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoDatabaseUtils;
import org.springframework.data.mongodb.core.convert.ReferenceLoader;
import org.springframework.data.mongodb.core.convert.ReferenceResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoDatabaseFactoryReferenceLoader
implements ReferenceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDatabaseFactoryReferenceLoader.class);
    private final MongoDatabaseFactory mongoDbFactory;

    public MongoDatabaseFactoryReferenceLoader(MongoDatabaseFactory mongoDbFactory) {
        Assert.notNull((Object)mongoDbFactory, "MongoDbFactory translator must not be null!");
        this.mongoDbFactory = mongoDbFactory;
    }

    @Override
    public Iterable<Document> fetchMany(ReferenceLoader.DocumentReferenceQuery referenceQuery, ReferenceResolver.ReferenceCollection context) {
        MongoCollection<Document> collection = this.getCollection(context);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Bulk fetching {} from {}.{}.", referenceQuery, StringUtils.hasText(context.getDatabase()) ? context.getDatabase() : collection.getNamespace().getDatabaseName(), context.getCollection());
        }
        return referenceQuery.apply(collection);
    }

    protected MongoCollection<Document> getCollection(ReferenceResolver.ReferenceCollection context) {
        return MongoDatabaseUtils.getDatabase(context.getDatabase(), this.mongoDbFactory).getCollection(context.getCollection(), Document.class);
    }
}

