/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.annotation.Reference;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.AbstractMongoConverter;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultDbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.DocumentAccessor;
import org.springframework.data.mongodb.core.convert.DocumentPointerFactory;
import org.springframework.data.mongodb.core.convert.DocumentPropertyAccessor;
import org.springframework.data.mongodb.core.convert.DocumentReferenceSource;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.ReferenceLookupDelegate;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.DocumentPointer;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.Unwrapped;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware {
    private static final String INCOMPATIBLE_TYPES = "Cannot convert %1$s of type %2$s into an instance of %3$s! Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions. Parent object was: %4$s";
    private static final String INVALID_TYPE_TO_READ = "Expected to read Document %s into type %s but didn't find a PersistentEntity for the latter!";
    public static final ClassTypeInformation<Bson> BSON = ClassTypeInformation.from(Bson.class);
    protected static final Logger LOGGER = LoggerFactory.getLogger(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final QueryMapper idMapper;
    protected final DbRefResolver dbRefResolver;
    protected final DefaultDbRefProxyHandler dbRefProxyHandler;
    protected final ReferenceLookupDelegate referenceLookupDelegate;
    @Nullable
    protected ApplicationContext applicationContext;
    protected MongoTypeMapper typeMapper;
    @Nullable
    protected String mapKeyDotReplacement = null;
    @Nullable
    protected CodecRegistryProvider codecRegistryProvider;
    private MongoTypeMapper defaultTypeMapper;
    private SpELContext spELContext;
    @Nullable
    private EntityCallbacks entityCallbacks;
    private final DocumentPointerFactory documentPointerFactory;

    public MappingMongoConverter(DbRefResolver dbRefResolver, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super(new DefaultConversionService());
        Assert.notNull((Object)dbRefResolver, "DbRefResolver must not be null!");
        Assert.notNull(mappingContext, "MappingContext must not be null!");
        this.dbRefResolver = dbRefResolver;
        this.mappingContext = mappingContext;
        this.defaultTypeMapper = new DefaultMongoTypeMapper("_class", mappingContext, this::getWriteTarget);
        this.idMapper = new QueryMapper(this);
        this.spELContext = new SpELContext(DocumentPropertyAccessor.INSTANCE);
        this.dbRefProxyHandler = new DefaultDbRefProxyHandler(this.spELContext, mappingContext, (prop, bson, evaluator, path) -> {
            ConversionContext context = this.getConversionContext(path);
            return this.getValueInternal(context, prop, bson, evaluator);
        });
        this.referenceLookupDelegate = new ReferenceLookupDelegate(mappingContext, this.spELContext);
        this.documentPointerFactory = new DocumentPointerFactory(this.conversionService, mappingContext);
    }

    protected ConversionContext getConversionContext(ObjectPath path) {
        Assert.notNull((Object)path, "ObjectPath must not be null");
        return new ConversionContext(this.conversions, path, this::readDocument, this::readCollectionOrArray, this::readMap, this::readDBRef, this::getPotentiallyConvertedSimpleRead);
    }

    @Deprecated
    public MappingMongoConverter(MongoDatabaseFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this(new DefaultDbRefResolver(mongoDbFactory), mappingContext);
        this.setCodecRegistryProvider(mongoDbFactory);
    }

    public void setTypeMapper(@Nullable MongoTypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    @Override
    public MongoTypeMapper getTypeMapper() {
        return this.typeMapper == null ? this.defaultTypeMapper : this.typeMapper;
    }

    public void setMapKeyDotReplacement(@Nullable String mapKeyDotReplacement) {
        this.mapKeyDotReplacement = mapKeyDotReplacement;
    }

    public void setCodecRegistryProvider(@Nullable CodecRegistryProvider codecRegistryProvider) {
        this.codecRegistryProvider = codecRegistryProvider;
    }

    @Override
    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.spELContext = new SpELContext(this.spELContext, applicationContext);
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create(applicationContext));
        }
        ClassLoader classLoader = applicationContext.getClassLoader();
        if (this.defaultTypeMapper instanceof BeanClassLoaderAware && classLoader != null) {
            ((BeanClassLoaderAware)((Object)this.defaultTypeMapper)).setBeanClassLoader(classLoader);
        }
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, "EntityCallbacks must not be null!");
        this.entityCallbacks = entityCallbacks;
    }

    @Override
    public <S> S read(Class<S> clazz, Bson bson) {
        return this.read(ClassTypeInformation.from(clazz), bson);
    }

    @Override
    protected <S> S read(TypeInformation<S> type, Bson bson) {
        return this.readDocument(this.getConversionContext(ObjectPath.ROOT), bson, type);
    }

    protected <S> S readDocument(ConversionContext context, Bson bson, TypeInformation<? extends S> typeHint) {
        Document document = bson instanceof BasicDBObject ? new Document((BasicDBObject)bson) : (Document)bson;
        TypeInformation<S> typeToRead = this.getTypeMapper().readType(document, typeHint);
        Class<? extends S> rawType = typeToRead.getType();
        if (this.conversions.hasCustomReadTarget(bson.getClass(), rawType)) {
            return this.doConvert(bson, rawType, typeHint.getType());
        }
        if (Document.class.isAssignableFrom(rawType)) {
            return (S)bson;
        }
        if (DBObject.class.isAssignableFrom(rawType)) {
            if (bson instanceof DBObject) {
                return (S)bson;
            }
            if (bson instanceof Document) {
                return (S)new BasicDBObject((Map)((Document)bson));
            }
            return (S)bson;
        }
        if (typeToRead.isMap()) {
            return context.convert(bson, typeToRead);
        }
        if (BSON.isAssignableFrom(typeHint)) {
            return (S)bson;
        }
        MongoPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)typeToRead));
        if (entity == null) {
            Optional<Codec<S>> codec;
            if (this.codecRegistryProvider != null && (codec = this.codecRegistryProvider.getCodecFor(rawType)).isPresent()) {
                return (S)codec.get().decode(new JsonReader(document.toJson()), DecoderContext.builder().build());
            }
            throw new MappingException(String.format(INVALID_TYPE_TO_READ, document, rawType));
        }
        return (S)this.read(context, entity, document);
    }

    private ParameterValueProvider<MongoPersistentProperty> getParameterProvider(ConversionContext context, MongoPersistentEntity<?> entity, DocumentAccessor source, SpELExpressionEvaluator evaluator) {
        AssociationAwareMongoDbPropertyValueProvider provider = new AssociationAwareMongoDbPropertyValueProvider(context, source, evaluator);
        PersistentEntityParameterValueProvider<MongoPersistentProperty> parameterProvider = new PersistentEntityParameterValueProvider<MongoPersistentProperty>(entity, provider, context.getPath().getCurrentObject());
        return new ConverterAwareSpELExpressionParameterValueProvider(context, evaluator, this.conversionService, parameterProvider);
    }

    private <S> S read(ConversionContext context, MongoPersistentEntity<S> entity, Document bson) {
        S existing;
        DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator(bson, this.spELContext);
        DocumentAccessor documentAccessor = new DocumentAccessor(bson);
        if (this.hasIdentifier(bson) && (existing = this.findContextualEntity(context, entity, bson)) != null) {
            return existing;
        }
        PreferredConstructor persistenceConstructor = entity.getPersistenceConstructor();
        NoOpParameterValueProvider provider = persistenceConstructor != null && persistenceConstructor.hasParameters() ? this.getParameterProvider(context, entity, documentAccessor, evaluator) : NoOpParameterValueProvider.INSTANCE;
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, provider);
        if (entity.requiresPropertyPopulation()) {
            return this.populateProperties(context, entity, documentAccessor, evaluator, instance);
        }
        return (S)instance;
    }

    private boolean hasIdentifier(Document bson) {
        return bson.get("_id") != null;
    }

    @Nullable
    private <S> S findContextualEntity(ConversionContext context, MongoPersistentEntity<S> entity, Document bson) {
        return (S)context.getPath().getPathItem(bson.get("_id"), entity.getCollection(), entity.getType());
    }

    private <S> S populateProperties(ConversionContext context, MongoPersistentEntity<S> entity, DocumentAccessor documentAccessor, SpELExpressionEvaluator evaluator, S instance) {
        ConvertingPropertyAccessor<S> accessor = new ConvertingPropertyAccessor<S>(entity.getPropertyAccessor(instance), this.conversionService);
        Object rawId = this.readAndPopulateIdentifier(context, accessor, documentAccessor, entity, evaluator);
        ObjectPath currentPath = context.getPath().push(accessor.getBean(), entity, rawId);
        ConversionContext contextToUse = context.withPath(currentPath);
        MongoDbPropertyValueProvider valueProvider = new MongoDbPropertyValueProvider(contextToUse, documentAccessor, evaluator);
        this.readProperties(contextToUse, entity, accessor, documentAccessor, valueProvider, evaluator);
        return (S)accessor.getBean();
    }

    @Nullable
    private Object readAndPopulateIdentifier(ConversionContext context, PersistentPropertyAccessor<?> accessor, DocumentAccessor document, MongoPersistentEntity<?> entity, SpELExpressionEvaluator evaluator) {
        Object rawId = document.getRawId(entity);
        if (!entity.hasIdProperty() || rawId == null) {
            return rawId;
        }
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getRequiredIdProperty();
        if (idProperty.isImmutable() && entity.isConstructorArgument(idProperty)) {
            return rawId;
        }
        accessor.setProperty(idProperty, this.readIdValue(context, evaluator, idProperty, rawId));
        return rawId;
    }

    @Nullable
    private Object readIdValue(ConversionContext context, SpELExpressionEvaluator evaluator, MongoPersistentProperty idProperty, Object rawId) {
        String expression = idProperty.getSpelExpression();
        Object resolvedValue = expression != null ? evaluator.evaluate(expression) : rawId;
        return resolvedValue != null ? this.readValue(context, resolvedValue, idProperty.getTypeInformation()) : null;
    }

    private void readProperties(ConversionContext context, MongoPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, DocumentAccessor documentAccessor, MongoDbPropertyValueProvider valueProvider, SpELExpressionEvaluator evaluator) {
        DbRefResolverCallback callback = null;
        for (MongoPersistentProperty prop : entity) {
            if (prop.isAssociation() && !entity.isConstructorArgument(prop)) {
                if (callback == null) {
                    callback = this.getDbRefResolverCallback(context, documentAccessor, evaluator);
                }
                this.readAssociation(prop.getRequiredAssociation(), accessor, documentAccessor, this.dbRefProxyHandler, callback, context, evaluator);
                continue;
            }
            if (prop.isUnwrapped()) {
                accessor.setProperty(prop, this.readUnwrapped(context, documentAccessor, prop, this.mappingContext.getRequiredPersistentEntity(prop)));
                continue;
            }
            if (entity.isIdProperty(prop) || entity.isConstructorArgument(prop) || !documentAccessor.hasValue(prop)) continue;
            if (prop.isAssociation()) {
                if (callback == null) {
                    callback = this.getDbRefResolverCallback(context, documentAccessor, evaluator);
                }
                this.readAssociation(prop.getRequiredAssociation(), accessor, documentAccessor, this.dbRefProxyHandler, callback, context, evaluator);
                continue;
            }
            accessor.setProperty(prop, valueProvider.getPropertyValue(prop));
        }
    }

    private DbRefResolverCallback getDbRefResolverCallback(ConversionContext context, DocumentAccessor documentAccessor, SpELExpressionEvaluator evaluator) {
        return new DefaultDbRefResolverCallback(documentAccessor.getDocument(), context.getPath(), evaluator, (prop, bson, e, path) -> this.getValueInternal(context, prop, bson, e));
    }

    private void readAssociation(Association<MongoPersistentProperty> association, PersistentPropertyAccessor<?> accessor, DocumentAccessor documentAccessor, DbRefProxyHandler handler, DbRefResolverCallback callback, ConversionContext context, SpELExpressionEvaluator evaluator) {
        MongoPersistentProperty property = association.getInverse();
        Object value = documentAccessor.get(property);
        if (property.isDocumentReference() || !property.isDbReference() && property.findAnnotation(Reference.class) != null) {
            if (this.conversionService.canConvert(DocumentPointer.class, property.getActualType())) {
                if (value == null) {
                    return;
                }
                DocumentPointer<Object> pointer = () -> value;
                accessor.setProperty(property, this.conversionService.convert(pointer, property.getActualType()));
            } else {
                accessor.setProperty(property, this.dbRefResolver.resolveReference(property, new DocumentReferenceSource(documentAccessor.getDocument(), documentAccessor.get(property)), this.referenceLookupDelegate, context::convert));
            }
            return;
        }
        if (value == null) {
            return;
        }
        com.mongodb.DBRef dbref = value instanceof com.mongodb.DBRef ? (com.mongodb.DBRef)value : null;
        accessor.setProperty(property, this.dbRefResolver.resolveDbRef(property, dbref, callback, handler));
    }

    @Nullable
    private Object readUnwrapped(ConversionContext context, DocumentAccessor documentAccessor, MongoPersistentProperty prop, MongoPersistentEntity<?> unwrappedEntity) {
        if (prop.findAnnotation(Unwrapped.class).onEmpty().equals((Object)Unwrapped.OnEmpty.USE_EMPTY)) {
            return this.read(context, unwrappedEntity, (Document)documentAccessor.getDocument());
        }
        for (MongoPersistentProperty persistentProperty : unwrappedEntity) {
            if (!documentAccessor.hasValue(persistentProperty)) continue;
            return this.read(context, unwrappedEntity, (Document)documentAccessor.getDocument());
        }
        return null;
    }

    @Override
    public com.mongodb.DBRef toDBRef(Object object, @Nullable MongoPersistentProperty referringProperty) {
        if (referringProperty != null) {
            DBRef annotation = referringProperty.getDBRef();
            Assert.isTrue(annotation != null, "The referenced property has to be mapped with @DBRef!");
        }
        if (object instanceof LazyLoadingProxy) {
            return ((LazyLoadingProxy)object).toDBRef();
        }
        return this.createDBRef(object, referringProperty);
    }

    @Override
    public DocumentPointer toDocumentPointer(Object source, @Nullable MongoPersistentProperty referringProperty) {
        if (source instanceof LazyLoadingProxy) {
            return () -> ((LazyLoadingProxy)source).getSource();
        }
        Assert.notNull((Object)referringProperty, "Cannot create DocumentReference. The referringProperty must not be null!");
        if (referringProperty.isDbReference()) {
            return () -> this.toDBRef(source, referringProperty);
        }
        if (referringProperty.isDocumentReference() || referringProperty.findAnnotation(Reference.class) != null) {
            return this.createDocumentPointer(source, referringProperty);
        }
        throw new IllegalArgumentException("The referringProperty is neither a DBRef nor a document reference");
    }

    DocumentPointer<?> createDocumentPointer(Object source, @Nullable MongoPersistentProperty referringProperty) {
        if (referringProperty == null) {
            return () -> source;
        }
        if (source instanceof DocumentPointer) {
            return (DocumentPointer)source;
        }
        if (ClassUtils.isAssignableValue(referringProperty.getType(), source) && this.conversionService.canConvert(referringProperty.getType(), DocumentPointer.class)) {
            return this.conversionService.convert(source, DocumentPointer.class);
        }
        if (ClassUtils.isAssignableValue(referringProperty.getAssociationTargetType(), source)) {
            return this.documentPointerFactory.computePointer(this.mappingContext, referringProperty, source, referringProperty.getActualType());
        }
        return () -> source;
    }

    @Override
    public void write(Object obj, Bson bson) {
        if (null == obj) {
            return;
        }
        Class<?> entityType = ClassUtils.getUserClass(obj.getClass());
        ClassTypeInformation<?> type = ClassTypeInformation.from(entityType);
        Object target = obj instanceof LazyLoadingProxy ? ((LazyLoadingProxy)obj).getTarget() : obj;
        this.writeInternal(target, bson, type);
        BsonUtils.removeNullId(bson);
        if (this.requiresTypeHint(entityType)) {
            this.getTypeMapper().writeType(type, bson);
        }
    }

    private boolean requiresTypeHint(Class<?> type) {
        return !this.conversions.isSimpleType(type) && !ClassUtils.isAssignable(Collection.class, type) && !this.conversions.hasCustomWriteTarget(type, Document.class);
    }

    protected void writeInternal(@Nullable Object obj, Bson bson, @Nullable TypeInformation<?> typeHint) {
        if (null == obj) {
            return;
        }
        Class<?> entityType = obj.getClass();
        Optional<Class<?>> customTarget = this.conversions.getCustomWriteTarget(entityType, Document.class);
        if (customTarget.isPresent()) {
            Document result = this.doConvert(obj, Document.class);
            BsonUtils.addAllToMap(bson, result);
            return;
        }
        if (Map.class.isAssignableFrom(entityType)) {
            this.writeMapInternal((Map)obj, bson, ClassTypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(entityType)) {
            this.writeCollectionInternal((Collection)obj, ClassTypeInformation.LIST, (Collection)((Object)bson));
            return;
        }
        MongoPersistentEntity<?> entity = this.mappingContext.getRequiredPersistentEntity((MongoPersistentProperty)((Object)entityType));
        this.writeInternal(obj, bson, entity);
        this.addCustomTypeKeyIfNecessary(typeHint, obj, bson);
    }

    protected void writeInternal(@Nullable Object obj, Bson bson, @Nullable MongoPersistentEntity<?> entity) {
        Object value;
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        PersistentPropertyAccessor<Object> accessor = entity.getPropertyAccessor(obj);
        DocumentAccessor dbObjectAccessor = new DocumentAccessor(bson);
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (idProperty != null && !dbObjectAccessor.hasValue(idProperty) && (value = this.idMapper.convertId(accessor.getProperty(idProperty), idProperty.getFieldType())) != null) {
            dbObjectAccessor.put(idProperty, value);
        }
        this.writeProperties(bson, entity, accessor, dbObjectAccessor, idProperty);
    }

    private void writeProperties(Bson bson, MongoPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, DocumentAccessor dbObjectAccessor, @Nullable MongoPersistentProperty idProperty) {
        for (MongoPersistentProperty prop : entity) {
            if (prop.equals(idProperty) || !prop.isWritable()) continue;
            if (prop.isAssociation()) {
                this.writeAssociation(prop.getRequiredAssociation(), accessor, dbObjectAccessor);
                continue;
            }
            Object value = accessor.getProperty(prop);
            if (value == null) {
                if (!prop.writeNullValues()) continue;
                dbObjectAccessor.put(prop, null);
                continue;
            }
            if (!this.conversions.isSimpleType(value.getClass())) {
                this.writePropertyInternal(value, dbObjectAccessor, prop);
                continue;
            }
            this.writeSimpleInternal(value, bson, prop);
        }
    }

    private void writeAssociation(Association<MongoPersistentProperty> association, PersistentPropertyAccessor<?> accessor, DocumentAccessor dbObjectAccessor) {
        MongoPersistentProperty inverseProp = association.getInverse();
        Object value = accessor.getProperty(inverseProp);
        if (value == null && !inverseProp.isUnwrapped() && inverseProp.writeNullValues()) {
            dbObjectAccessor.put(inverseProp, null);
            return;
        }
        this.writePropertyInternal(value, dbObjectAccessor, inverseProp);
    }

    protected void writePropertyInternal(@Nullable Object obj, DocumentAccessor accessor, MongoPersistentProperty prop) {
        Optional<Class<?>> basicTargetType;
        if (obj == null) {
            return;
        }
        ClassTypeInformation<?> valueType = ClassTypeInformation.from(obj.getClass());
        TypeInformation<?> type = prop.getTypeInformation();
        if (prop.isUnwrapped()) {
            Document target = new Document();
            this.writeInternal(obj, (Bson)target, this.mappingContext.getPersistentEntity(prop));
            accessor.putAll(target);
            return;
        }
        if (valueType.isCollectionLike()) {
            List<Object> collectionInternal = this.createCollection(BsonUtils.asCollection(obj), prop);
            accessor.put(prop, collectionInternal);
            return;
        }
        if (valueType.isMap()) {
            Bson mapDbObj = this.createMap((Map)obj, prop);
            accessor.put(prop, mapDbObj);
            return;
        }
        if (prop.isDbReference()) {
            com.mongodb.DBRef dbRefObj = null;
            if (obj instanceof LazyLoadingProxy) {
                dbRefObj = ((LazyLoadingProxy)obj).toDBRef();
            }
            dbRefObj = dbRefObj != null ? dbRefObj : this.createDBRef(obj, prop);
            accessor.put(prop, dbRefObj);
            return;
        }
        if (prop.isAssociation() && prop.isAnnotationPresent(Reference.class)) {
            accessor.put(prop, new DocumentPointerFactory(this.conversionService, this.mappingContext).computePointer(this.mappingContext, prop, obj, valueType.getType()).getPointer());
            return;
        }
        if (obj instanceof LazyLoadingProxy) {
            obj = ((LazyLoadingProxy)obj).getTarget();
        }
        if ((basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass())).isPresent()) {
            accessor.put(prop, this.doConvert(obj, basicTargetType.get()));
            return;
        }
        MongoPersistentEntity<?> entity = valueType.isSubTypeOf(prop.getType()) ? this.mappingContext.getRequiredPersistentEntity((MongoPersistentProperty)((Object)obj.getClass())) : this.mappingContext.getRequiredPersistentEntity((MongoPersistentProperty)((Object)type));
        Object existingValue = accessor.get(prop);
        Document document = existingValue instanceof Document ? (Document)existingValue : new Document();
        this.writeInternal(obj, (Bson)document, entity);
        this.addCustomTypeKeyIfNecessary(ClassTypeInformation.from(prop.getRawType()), obj, document);
        accessor.put(prop, document);
    }

    protected List<Object> createCollection(Collection<?> collection, MongoPersistentProperty property) {
        if (!property.isDbReference()) {
            if (property.isAssociation()) {
                List targetCollection = collection.stream().map(it -> this.documentPointerFactory.computePointer(this.mappingContext, property, it, property.getActualType()).getPointer()).collect(Collectors.toList());
                return this.writeCollectionInternal(targetCollection, ClassTypeInformation.from(DocumentPointer.class), new ArrayList());
            }
            if (property.hasExplicitWriteTarget()) {
                return this.writeCollectionInternal(collection, new FieldTypeInformation(property), new ArrayList());
            }
            return this.writeCollectionInternal(collection, property.getTypeInformation(), new ArrayList());
        }
        ArrayList<Object> dbList = new ArrayList<Object>(collection.size());
        for (Object element : collection) {
            if (element == null) continue;
            com.mongodb.DBRef dbRef = this.createDBRef(element, property);
            dbList.add(dbRef);
        }
        return dbList;
    }

    protected Bson createMap(Map<Object, Object> map, MongoPersistentProperty property) {
        Assert.notNull(map, "Given map must not be null!");
        Assert.notNull((Object)property, "PersistentProperty must not be null!");
        if (!property.isAssociation()) {
            return this.writeMapInternal(map, new Document(), property.getTypeInformation());
        }
        Document document = new Document();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.prepareMapKey(key.toString());
                if (property.isDbReference()) {
                    document.put(simpleKey, (Object)(value != null ? this.createDBRef(value, property) : null));
                    continue;
                }
                document.put(simpleKey, this.documentPointerFactory.computePointer(this.mappingContext, property, value, property.getActualType()).getPointer());
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return document;
    }

    private List<Object> writeCollectionInternal(Collection<?> source, @Nullable TypeInformation<?> type, Collection<?> sink) {
        List<Object> collection;
        TypeInformation<?> componentType = null;
        List<Object> list = collection = sink instanceof List ? (List<Object>)sink : new ArrayList(sink);
        if (type != null) {
            componentType = type.getComponentType();
        }
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                collection.add(this.getPotentiallyConvertedSimpleWrite(element, componentType != null ? componentType.getType() : Object.class));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                collection.add(this.writeCollectionInternal(BsonUtils.asCollection(element), componentType, new ArrayList()));
                continue;
            }
            Document document = new Document();
            this.writeInternal(element, (Bson)document, componentType);
            collection.add(document);
        }
        return collection;
    }

    protected Bson writeMapInternal(Map<Object, Object> obj, Bson bson, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.prepareMapKey(key);
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, bson, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    BsonUtils.addToMap(bson, simpleKey, this.writeCollectionInternal(BsonUtils.asCollection(val), propertyType.getMapValueType(), new ArrayList()));
                    continue;
                }
                Document document = new Document();
                TypeInformation<Object> valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : ClassTypeInformation.OBJECT;
                this.writeInternal(val, (Bson)document, valueTypeInfo);
                BsonUtils.addToMap(bson, simpleKey, document);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return bson;
    }

    private String prepareMapKey(Object key) {
        Assert.notNull(key, "Map key must not be null!");
        String convertedKey = this.potentiallyConvertMapKey(key);
        return this.potentiallyEscapeMapKey(convertedKey);
    }

    protected String potentiallyEscapeMapKey(String source) {
        if (!source.contains(".")) {
            return source;
        }
        if (this.mapKeyDotReplacement == null) {
            throw new MappingException(String.format("Map key %s contains dots but no replacement was configured! Make sure map keys don't contain dots in the first place or configure an appropriate replacement!", source));
        }
        return StringUtils.replace(source, ".", this.mapKeyDotReplacement);
    }

    private String potentiallyConvertMapKey(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        return this.conversions.hasCustomWriteTarget(key.getClass(), String.class) ? (String)this.getPotentiallyConvertedSimpleWrite(key, Object.class) : key.toString();
    }

    protected String potentiallyUnescapeMapKey(String source) {
        return this.mapKeyDotReplacement == null ? source : StringUtils.replace(source, this.mapKeyDotReplacement, ".");
    }

    protected void addCustomTypeKeyIfNecessary(@Nullable TypeInformation<?> type, Object value, Bson bson) {
        boolean notTheSameClass;
        Class<Object> reference = type != null ? type.getRequiredActualType().getType() : Object.class;
        Class<?> valueType = ClassUtils.getUserClass(value.getClass());
        boolean bl = notTheSameClass = !valueType.equals(reference);
        if (notTheSameClass) {
            this.getTypeMapper().writeType(valueType, bson);
        }
    }

    private void writeSimpleInternal(@Nullable Object value, Bson bson, String key) {
        BsonUtils.addToMap(bson, key, this.getPotentiallyConvertedSimpleWrite(value, Object.class));
    }

    private void writeSimpleInternal(@Nullable Object value, Bson bson, MongoPersistentProperty property) {
        DocumentAccessor accessor = new DocumentAccessor(bson);
        accessor.put(property, this.getPotentiallyConvertedSimpleWrite(value, property.hasExplicitWriteTarget() ? property.getFieldType() : Object.class));
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(@Nullable Object value, @Nullable Class<?> typeHint) {
        Optional<Class<?>> customTarget;
        if (value == null) {
            return null;
        }
        if (typeHint != null && Object.class != typeHint && this.conversionService.canConvert(value.getClass(), typeHint)) {
            value = this.doConvert(value, typeHint);
        }
        if ((customTarget = this.conversions.getCustomWriteTarget(value.getClass())).isPresent()) {
            return this.doConvert(value, customTarget.get());
        }
        if (ObjectUtils.isArray(value)) {
            if (value instanceof byte[]) {
                return value;
            }
            return BsonUtils.asCollection(value);
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    protected Object getPotentiallyConvertedSimpleRead(Object value, TypeInformation<?> target) {
        return this.getPotentiallyConvertedSimpleRead(value, target.getType());
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, @Nullable Class<?> target) {
        if (target == null) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.doConvert(value, target);
        }
        if (ClassUtils.isAssignableValue(target, value)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.doConvert(value, target);
    }

    protected com.mongodb.DBRef createDBRef(Object target, @Nullable MongoPersistentProperty property) {
        Assert.notNull(target, "Target object must not be null!");
        if (target instanceof com.mongodb.DBRef) {
            return (com.mongodb.DBRef)target;
        }
        MongoPersistentEntity<?> targetEntity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)target.getClass()));
        MongoPersistentEntity<?> mongoPersistentEntity = targetEntity = targetEntity != null ? targetEntity : this.mappingContext.getPersistentEntity(property);
        if (null == targetEntity) {
            throw new MappingException("No mapping metadata found for " + target.getClass());
        }
        MongoPersistentEntity<?> entity = targetEntity;
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            Object id;
            Object object = id = target.getClass().equals(idProperty.getType()) ? target : entity.getPropertyAccessor(target).getProperty(idProperty);
            if (null == id) {
                throw new MappingException("Cannot create a reference to an object with a NULL id.");
            }
            return this.dbRefResolver.createDbRef(property == null ? null : property.getDBRef(), entity, this.idMapper.convertId(id, idProperty != null ? idProperty.getFieldType() : ObjectId.class));
        }
        throw new MappingException("No id property found on class " + entity.getType());
    }

    @Nullable
    private Object getValueInternal(ConversionContext context, MongoPersistentProperty prop, Bson bson, SpELExpressionEvaluator evaluator) {
        return new MongoDbPropertyValueProvider(context, bson, evaluator).getPropertyValue(prop);
    }

    protected Object readCollectionOrArray(ConversionContext context, Collection<?> source, TypeInformation<?> targetType) {
        Collection<?> items;
        Assert.notNull(targetType, "Target type must not be null!");
        Class collectionType = targetType.isSubTypeOf(Collection.class) ? targetType.getType() : List.class;
        TypeInformation<Object> componentType = targetType.getComponentType() != null ? targetType.getComponentType() : ClassTypeInformation.OBJECT;
        Class<Object> rawComponentType = componentType.getType();
        Collection collection = items = targetType.getType().isArray() ? new ArrayList(source.size()) : CollectionFactory.createCollection(collectionType, rawComponentType, source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
        }
        if (!com.mongodb.DBRef.class.equals(rawComponentType) && MappingMongoConverter.isCollectionOfDbRefWhereBulkFetchIsPossible(source)) {
            List objects = this.bulkReadAndConvertDBRefs(context, (List)source, componentType);
            return this.getPotentiallyConvertedSimpleRead(objects, targetType.getType());
        }
        for (Object element : source) {
            items.add(element != null ? context.convert(element, componentType) : element);
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    @Deprecated
    protected Map<Object, Object> readMap(TypeInformation<?> type, Bson bson, ObjectPath path) {
        return this.readMap(this.getConversionContext(path), bson, type);
    }

    protected Map<Object, Object> readMap(ConversionContext context, Bson bson, TypeInformation<?> targetType) {
        Assert.notNull((Object)bson, "Document must not be null!");
        Assert.notNull(targetType, "TypeInformation must not be null!");
        Class<?> mapType = this.getTypeMapper().readType(bson, targetType).getType();
        TypeInformation<?> keyType = targetType.getComponentType();
        TypeInformation<Object> valueType = targetType.getMapValueType() == null ? ClassTypeInformation.OBJECT : targetType.getRequiredMapValueType();
        Class rawKeyType = keyType != null ? keyType.getType() : Object.class;
        Class<Object> rawValueType = valueType.getType();
        Map<String, Object> sourceMap = BsonUtils.asMap(bson);
        Map<Object, Object> map = CollectionFactory.createMap(mapType, rawKeyType, sourceMap.keySet().size());
        if (!com.mongodb.DBRef.class.equals(rawValueType) && MappingMongoConverter.isCollectionOfDbRefWhereBulkFetchIsPossible(sourceMap.values())) {
            this.bulkReadAndConvertDBRefMapIntoTarget(context, valueType, sourceMap, map);
            return map;
        }
        sourceMap.forEach((k, v) -> {
            Object value;
            if (this.getTypeMapper().isTypeKey((String)k)) {
                return;
            }
            String key = this.potentiallyUnescapeMapKey((String)k);
            if (!rawKeyType.isAssignableFrom(key.getClass())) {
                key = this.doConvert(key, rawKeyType);
            }
            map.put(key, (value = v) == null ? value : context.convert(value, valueType));
        });
        return map;
    }

    @Override
    @Nullable
    public Object convertToMongoType(@Nullable Object obj, @Nullable TypeInformation<?> typeInformation) {
        if (obj == null) {
            return null;
        }
        Optional<Class<?>> target = this.conversions.getCustomWriteTarget(obj.getClass());
        if (target.isPresent()) {
            return this.doConvert(obj, target.get());
        }
        if (this.conversions.isSimpleType(obj.getClass())) {
            Class conversionTargetType = typeInformation != null && this.conversions.isSimpleType(typeInformation.getType()) ? typeInformation.getType() : Object.class;
            return this.getPotentiallyConvertedSimpleWrite(obj, conversionTargetType);
        }
        if (obj instanceof List) {
            return this.maybeConvertList((List)obj, typeInformation);
        }
        if (obj instanceof Document) {
            Document newValueDocument = new Document();
            for (String vk : ((Document)obj).keySet()) {
                Object o = ((Document)obj).get(vk);
                newValueDocument.put(vk, this.convertToMongoType(o, typeInformation));
            }
            return newValueDocument;
        }
        if (obj instanceof DBObject) {
            Document newValueDbo = new Document();
            for (String vk : ((DBObject)obj).keySet()) {
                Object o = ((DBObject)obj).get(vk);
                newValueDbo.put(vk, this.convertToMongoType(o, typeInformation));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            Document result = new Document();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.put(entry.getKey().toString(), this.convertToMongoType(entry.getValue(), typeInformation));
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertList(Arrays.asList((Object[])obj), typeInformation);
        }
        if (obj instanceof Collection) {
            return this.maybeConvertList((Collection)obj, typeInformation);
        }
        Document newDocument = new Document();
        this.write(obj, newDocument);
        if (typeInformation == null) {
            return this.removeTypeInfo(newDocument, true);
        }
        if (typeInformation.getType().equals(NestedDocument.class)) {
            return this.removeTypeInfo(newDocument, false);
        }
        return !obj.getClass().equals(typeInformation.getType()) ? newDocument : this.removeTypeInfo(newDocument, true);
    }

    @Override
    public Object convertToMongoType(@Nullable Object obj, MongoPersistentEntity entity) {
        Document newDocument = new Document();
        this.writeInternal(obj, (Bson)newDocument, entity);
        return newDocument;
    }

    public List<Object> maybeConvertList(Iterable<?> source, @Nullable TypeInformation<?> typeInformation) {
        ArrayList<Object> newDbl = new ArrayList<Object>();
        for (Object element : source) {
            newDbl.add(this.convertToMongoType(element, typeInformation));
        }
        return newDbl;
    }

    private Object removeTypeInfo(Object object, boolean recursively) {
        if (!(object instanceof Document)) {
            return object;
        }
        Document document = (Document)object;
        String keyToRemove = null;
        for (String key : document.keySet()) {
            if (recursively) {
                Object value = document.get(key);
                if (value instanceof BasicDBList) {
                    for (Object element : (BasicDBList)value) {
                        this.removeTypeInfo(element, recursively);
                    }
                } else if (value instanceof List) {
                    for (Object element : (List)value) {
                        this.removeTypeInfo(element, recursively);
                    }
                } else {
                    this.removeTypeInfo(value, recursively);
                }
            }
            if (!this.getTypeMapper().isTypeKey(key)) continue;
            keyToRemove = key;
            if (recursively) continue;
            break;
        }
        if (keyToRemove != null) {
            document.remove(keyToRemove);
        }
        return document;
    }

    @Nullable
    <T> T readValue(ConversionContext context, @Nullable Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        Assert.notNull(type, "TypeInformation must not be null");
        Class<?> rawType = type.getType();
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            return (T)this.doConvert(value, rawType);
        }
        if (value instanceof com.mongodb.DBRef) {
            return (T)this.readDBRef(context, (com.mongodb.DBRef)value, type);
        }
        return (T)context.convert(value, type);
    }

    @Nullable
    private Object readDBRef(ConversionContext context, @Nullable com.mongodb.DBRef dbref, TypeInformation<?> type) {
        Object object;
        if (type.getType().equals(com.mongodb.DBRef.class)) {
            return dbref;
        }
        ObjectPath path = context.getPath();
        Object v0 = object = dbref == null ? null : path.getPathItem(dbref.getId(), dbref.getCollectionName(), type.getType());
        if (object != null) {
            return object;
        }
        List result = this.bulkReadAndConvertDBRefs(context, Collections.singletonList(dbref), type);
        return CollectionUtils.isEmpty(result) ? null : result.iterator().next();
    }

    private void bulkReadAndConvertDBRefMapIntoTarget(ConversionContext context, TypeInformation<?> valueType, Map<String, Object> sourceMap, Map<Object, Object> targetMap) {
        LinkedHashMap<String, Object> referenceMap = new LinkedHashMap<String, Object>(sourceMap);
        List convertedObjects = this.bulkReadAndConvertDBRefs(context.withPath(ObjectPath.ROOT), new ArrayList<Object>(referenceMap.values()), valueType);
        int index = 0;
        for (String key : referenceMap.keySet()) {
            targetMap.put(key, convertedObjects.get(index));
            ++index;
        }
    }

    private <T> List<T> bulkReadAndConvertDBRefs(ConversionContext context, List<com.mongodb.DBRef> dbrefs, TypeInformation<?> type) {
        if (CollectionUtils.isEmpty(dbrefs)) {
            return Collections.emptyList();
        }
        List<Document> referencedRawDocuments = dbrefs.size() == 1 ? Collections.singletonList(this.readRef(dbrefs.iterator().next())) : this.bulkReadRefs(dbrefs);
        String collectionName = dbrefs.iterator().next().getCollectionName();
        ArrayList<Object> targetList = new ArrayList<Object>(dbrefs.size());
        for (Document document : referencedRawDocuments) {
            Object target = null;
            if (document != null) {
                this.maybeEmitEvent(new AfterLoadEvent(document, type.getType(), collectionName));
                target = this.readDocument(context, document, type);
            }
            if (target != null) {
                this.maybeEmitEvent(new AfterConvertEvent<Object>(document, target, collectionName));
                target = this.maybeCallAfterConvert(target, document, collectionName);
            }
            targetList.add(target);
        }
        return targetList;
    }

    private void maybeEmitEvent(MongoMappingEvent<?> event) {
        if (this.canPublishEvent()) {
            this.applicationContext.publishEvent(event);
        }
    }

    private boolean canPublishEvent() {
        return this.applicationContext != null;
    }

    protected <T> T maybeCallAfterConvert(T object, Document document, String collection) {
        if (null != this.entityCallbacks) {
            return this.entityCallbacks.callback(AfterConvertCallback.class, object, document, collection);
        }
        return object;
    }

    @Nullable
    Document readRef(com.mongodb.DBRef ref) {
        return this.dbRefResolver.fetch(ref);
    }

    List<Document> bulkReadRefs(List<com.mongodb.DBRef> references) {
        return this.dbRefResolver.bulkFetch(references);
    }

    public Class<?> getWriteTarget(Class<?> source) {
        return this.conversions.getCustomWriteTarget(source).orElse(source);
    }

    public MappingMongoConverter with(MongoDatabaseFactory dbFactory) {
        MappingMongoConverter target = new MappingMongoConverter(new DefaultDbRefResolver(dbFactory), this.mappingContext);
        target.applicationContext = this.applicationContext;
        target.conversions = this.conversions;
        target.spELContext = this.spELContext;
        target.setInstantiators(this.instantiators);
        target.defaultTypeMapper = this.defaultTypeMapper;
        target.typeMapper = this.typeMapper;
        target.setCodecRegistryProvider(dbFactory);
        target.afterPropertiesSet();
        return target;
    }

    private <T> T doConvert(Object value, Class<? extends T> target) {
        return this.doConvert(value, target, null);
    }

    private <T> T doConvert(Object value, Class<? extends T> target, @Nullable Class<? extends T> fallback) {
        if (this.conversionService.canConvert(value.getClass(), target) || fallback == null) {
            return this.conversionService.convert(value, target);
        }
        return this.conversionService.convert(value, fallback);
    }

    private static boolean isCollectionOfDbRefWhereBulkFetchIsPossible(Iterable<?> source) {
        Assert.notNull(source, "Iterable of DBRefs must not be null!");
        HashSet<String> collectionsFound = new HashSet<String>();
        for (Object dbObjItem : source) {
            if (!(dbObjItem instanceof com.mongodb.DBRef)) {
                return false;
            }
            collectionsFound.add(((com.mongodb.DBRef)dbObjItem).getCollectionName());
            if (collectionsFound.size() <= 1) continue;
            return false;
        }
        return true;
    }

    protected static class ConversionContext {
        private final CustomConversions conversions;
        private final ObjectPath path;
        private final ContainerValueConverter<Bson> documentConverter;
        private final ContainerValueConverter<Collection<?>> collectionConverter;
        private final ContainerValueConverter<Bson> mapConverter;
        private final ContainerValueConverter<com.mongodb.DBRef> dbRefConverter;
        private final ValueConverter<Object> elementConverter;

        ConversionContext(CustomConversions customConversions, ObjectPath path, ContainerValueConverter<Bson> documentConverter, ContainerValueConverter<Collection<?>> collectionConverter, ContainerValueConverter<Bson> mapConverter, ContainerValueConverter<com.mongodb.DBRef> dbRefConverter, ValueConverter<Object> elementConverter) {
            this.conversions = customConversions;
            this.path = path;
            this.documentConverter = documentConverter;
            this.collectionConverter = collectionConverter;
            this.mapConverter = mapConverter;
            this.dbRefConverter = dbRefConverter;
            this.elementConverter = elementConverter;
        }

        public <S> S convert(Object source, TypeInformation<? extends S> typeHint) {
            Assert.notNull(source, "Source must not be null");
            Assert.notNull(typeHint, "TypeInformation must not be null");
            if (this.conversions.hasCustomReadTarget(source.getClass(), typeHint.getType())) {
                return (S)this.elementConverter.convert(source, typeHint);
            }
            if (source instanceof Collection) {
                Class<S> rawType = typeHint.getType();
                if (!(Object.class.equals(rawType) || rawType.isArray() || ClassUtils.isAssignable(Iterable.class, rawType))) {
                    throw new MappingException(String.format(MappingMongoConverter.INCOMPATIBLE_TYPES, source, source.getClass(), rawType, this.getPath()));
                }
                if (typeHint.isCollectionLike() || typeHint.getType().isAssignableFrom(Collection.class)) {
                    return (S)this.collectionConverter.convert(this, (Collection)source, typeHint);
                }
            }
            if (typeHint.isMap()) {
                if (ClassUtils.isAssignable(Document.class, typeHint.getType())) {
                    return (S)this.documentConverter.convert(this, BsonUtils.asBson(source), typeHint);
                }
                if (BsonUtils.supportsBson(source)) {
                    return (S)this.mapConverter.convert(this, BsonUtils.asBson(source), typeHint);
                }
                throw new IllegalArgumentException(String.format("Expected map like structure but found %s", source.getClass()));
            }
            if (source instanceof com.mongodb.DBRef) {
                return (S)this.dbRefConverter.convert(this, (com.mongodb.DBRef)source, typeHint);
            }
            if (source instanceof Collection) {
                throw new MappingException(String.format(MappingMongoConverter.INCOMPATIBLE_TYPES, source, BasicDBList.class, typeHint.getType(), this.getPath()));
            }
            if (BsonUtils.supportsBson(source)) {
                return (S)this.documentConverter.convert(this, BsonUtils.asBson(source), typeHint);
            }
            return (S)this.elementConverter.convert(source, typeHint);
        }

        public ConversionContext withPath(ObjectPath currentPath) {
            Assert.notNull((Object)currentPath, "ObjectPath must not be null");
            return new ConversionContext(this.conversions, currentPath, this.documentConverter, this.collectionConverter, this.mapConverter, this.dbRefConverter, this.elementConverter);
        }

        public ObjectPath getPath() {
            return this.path;
        }

        static interface ContainerValueConverter<T> {
            public Object convert(ConversionContext var1, T var2, TypeInformation<?> var3);
        }

        static interface ValueConverter<T> {
            public Object convert(T var1, TypeInformation<?> var2);
        }
    }

    private static class FieldTypeInformation<S>
    implements TypeInformation<S> {
        private final MongoPersistentProperty persistentProperty;
        private final TypeInformation<S> delegate;

        public FieldTypeInformation(MongoPersistentProperty property) {
            this.persistentProperty = property;
            this.delegate = property.getTypeInformation();
        }

        @Override
        public List<TypeInformation<?>> getParameterTypes(Constructor constructor) {
            return this.persistentProperty.getTypeInformation().getParameterTypes(constructor);
        }

        @Override
        public TypeInformation<?> getProperty(String property) {
            return this.delegate.getProperty(property);
        }

        @Override
        public boolean isCollectionLike() {
            return this.delegate.isCollectionLike();
        }

        @Override
        public TypeInformation<?> getComponentType() {
            return ClassTypeInformation.from(this.persistentProperty.getFieldType());
        }

        @Override
        public boolean isMap() {
            return this.delegate.isMap();
        }

        @Override
        public TypeInformation<?> getMapValueType() {
            return ClassTypeInformation.from(this.persistentProperty.getFieldType());
        }

        @Override
        public Class<S> getType() {
            return this.delegate.getType();
        }

        @Override
        public ClassTypeInformation<?> getRawTypeInformation() {
            return this.delegate.getRawTypeInformation();
        }

        @Override
        public TypeInformation<?> getActualType() {
            return this.delegate.getActualType();
        }

        @Override
        public TypeInformation<?> getReturnType(Method method) {
            return this.delegate.getReturnType(method);
        }

        @Override
        public List<TypeInformation<?>> getParameterTypes(Method method) {
            return this.delegate.getParameterTypes(method);
        }

        @Override
        public TypeInformation<?> getSuperTypeInformation(Class superType) {
            return this.delegate.getSuperTypeInformation(superType);
        }

        @Override
        public boolean isAssignableFrom(TypeInformation target) {
            return this.delegate.isAssignableFrom(target);
        }

        @Override
        public List<TypeInformation<?>> getTypeArguments() {
            return this.delegate.getTypeArguments();
        }

        @Override
        public TypeInformation<? extends S> specialize(ClassTypeInformation type) {
            return this.delegate.specialize(type);
        }
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<MongoPersistentProperty>
    {
        INSTANCE;


        @Override
        public <T> T getParameterValue(PreferredConstructor.Parameter<T, MongoPersistentProperty> parameter) {
            return null;
        }
    }

    static class NestedDocument {
        NestedDocument() {
        }
    }

    private static class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<MongoPersistentProperty> {
        private final ConversionContext context;

        public ConverterAwareSpELExpressionParameterValueProvider(ConversionContext context, SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<MongoPersistentProperty> delegate) {
            super(evaluator, conversionService, delegate);
            Assert.notNull((Object)context, "ConversionContext must no be null!");
            this.context = context;
        }

        @Override
        protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, MongoPersistentProperty> parameter) {
            return this.context.convert(object, parameter.getType());
        }
    }

    class AssociationAwareMongoDbPropertyValueProvider
    extends MongoDbPropertyValueProvider {
        AssociationAwareMongoDbPropertyValueProvider(ConversionContext context, DocumentAccessor source, SpELExpressionEvaluator evaluator) {
            super(context, source, evaluator);
        }

        @Override
        @Nullable
        public <T> T getPropertyValue(MongoPersistentProperty property) {
            if (property.isDbReference() && property.getDBRef().lazy()) {
                Object rawRefValue = this.accessor.get(property);
                if (rawRefValue == null) {
                    return null;
                }
                DefaultDbRefResolverCallback callback = new DefaultDbRefResolverCallback(this.accessor.getDocument(), this.context.getPath(), this.evaluator, (prop, bson, evaluator, path) -> MappingMongoConverter.this.getValueInternal(this.context, prop, bson, evaluator));
                com.mongodb.DBRef dbref = rawRefValue instanceof com.mongodb.DBRef ? (com.mongodb.DBRef)rawRefValue : null;
                return (T)MappingMongoConverter.this.dbRefResolver.resolveDbRef(property, dbref, callback, MappingMongoConverter.this.dbRefProxyHandler);
            }
            if (property.isDocumentReference()) {
                return (T)MappingMongoConverter.this.dbRefResolver.resolveReference(property, this.accessor.get(property), MappingMongoConverter.this.referenceLookupDelegate, this.context::convert);
            }
            return super.getPropertyValue(property);
        }
    }

    static class MongoDbPropertyValueProvider
    implements PropertyValueProvider<MongoPersistentProperty> {
        final ConversionContext context;
        final DocumentAccessor accessor;
        final SpELExpressionEvaluator evaluator;

        MongoDbPropertyValueProvider(ConversionContext context, Bson source, SpELExpressionEvaluator evaluator) {
            this(context, new DocumentAccessor(source), evaluator);
        }

        MongoDbPropertyValueProvider(ConversionContext context, DocumentAccessor accessor, SpELExpressionEvaluator evaluator) {
            Assert.notNull((Object)context, "ConversionContext must no be null!");
            Assert.notNull((Object)accessor, "DocumentAccessor must no be null!");
            Assert.notNull((Object)evaluator, "SpELExpressionEvaluator must not be null!");
            this.context = context;
            this.accessor = accessor;
            this.evaluator = evaluator;
        }

        @Override
        @Nullable
        public <T> T getPropertyValue(MongoPersistentProperty property) {
            Object value;
            String expression = property.getSpelExpression();
            Object object = value = expression != null ? this.evaluator.evaluate(expression) : this.accessor.get(property);
            if (value == null) {
                return null;
            }
            return (T)this.context.convert(value, property.getTypeInformation());
        }
    }
}

