/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.ClientSessionException;
import org.springframework.data.mongodb.LazyLoadingException;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.util.ReflectionUtils;

class LazyLoadingProxyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyLoadingProxyFactory.class);
    private final ObjenesisStd objenesis;
    private final PersistenceExceptionTranslator exceptionTranslator;

    public LazyLoadingProxyFactory(PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
        this.objenesis = new ObjenesisStd(true);
    }

    public Object createLazyLoadingProxy(MongoPersistentProperty property, DbRefResolverCallback callback, Object source) {
        Class<?> propertyType = property.getType();
        LazyLoadingInterceptor interceptor = new LazyLoadingInterceptor(property, callback, source, this.exceptionTranslator);
        if (!propertyType.isInterface()) {
            Factory factory = (Factory)this.objenesis.newInstance(this.getEnhancedTypeFor(propertyType));
            factory.setCallbacks(new Callback[]{interceptor});
            return factory;
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        for (Class<?> type : propertyType.getInterfaces()) {
            proxyFactory.addInterface(type);
        }
        proxyFactory.addInterface(LazyLoadingProxy.class);
        proxyFactory.addInterface(propertyType);
        proxyFactory.addAdvice(interceptor);
        return proxyFactory.getProxy(LazyLoadingProxy.class.getClassLoader());
    }

    private Class<?> getEnhancedTypeFor(Class<?> type) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setCallbackType(MethodInterceptor.class);
        enhancer.setInterfaces(new Class[]{LazyLoadingProxy.class});
        return enhancer.createClass();
    }

    public static class LazyLoadingInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    MethodInterceptor,
    Serializable {
        private static final Method INITIALIZE_METHOD;
        private static final Method TO_DBREF_METHOD;
        private static final Method FINALIZE_METHOD;
        private static final Method GET_SOURCE_METHOD;
        private final MongoPersistentProperty property;
        private final DbRefResolverCallback callback;
        private final Object source;
        private final PersistenceExceptionTranslator exceptionTranslator;
        private volatile boolean resolved;
        @Nullable
        private Object result;

        public LazyLoadingInterceptor(MongoPersistentProperty property, DbRefResolverCallback callback, Object source, PersistenceExceptionTranslator exceptionTranslator) {
            this.property = property;
            this.callback = callback;
            this.source = source;
            this.exceptionTranslator = exceptionTranslator;
        }

        @Override
        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            return this.intercept(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), null);
        }

        @Override
        @Nullable
        public Object intercept(Object o, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object target;
            if (INITIALIZE_METHOD.equals(method)) {
                return this.ensureResolved();
            }
            if (TO_DBREF_METHOD.equals(method)) {
                return this.source instanceof DBRef ? this.source : null;
            }
            if (GET_SOURCE_METHOD.equals(method)) {
                return this.source;
            }
            if (ReflectionUtils.isObjectMethod(method) && Object.class.equals(method.getDeclaringClass())) {
                if (ReflectionUtils.isToStringMethod(method)) {
                    return this.proxyToString(this.source);
                }
                if (ReflectionUtils.isEqualsMethod(method)) {
                    return this.proxyEquals(o, args[0]);
                }
                if (ReflectionUtils.isHashCodeMethod(method)) {
                    return this.proxyHashCode();
                }
                if (FINALIZE_METHOD.equals(method)) {
                    return null;
                }
            }
            if ((target = this.ensureResolved()) == null) {
                return null;
            }
            ReflectionUtils.makeAccessible(method);
            return method.invoke(target, args);
        }

        @Nullable
        private Object ensureResolved() {
            if (!this.resolved) {
                this.result = this.resolve();
                this.resolved = true;
            }
            return this.result;
        }

        private String proxyToString(@Nullable Object source) {
            StringBuilder description = new StringBuilder();
            if (source != null) {
                if (source instanceof DBRef) {
                    description.append(((DBRef)source).getCollectionName());
                    description.append(":");
                    description.append(((DBRef)source).getId());
                } else {
                    description.append(source);
                }
            } else {
                description.append(System.identityHashCode(source));
            }
            description.append("$").append(LazyLoadingProxy.class.getSimpleName());
            return description.toString();
        }

        private boolean proxyEquals(@Nullable Object proxy, Object that) {
            if (!(that instanceof LazyLoadingProxy)) {
                return false;
            }
            if (that == proxy) {
                return true;
            }
            return this.proxyToString(proxy).equals(that.toString());
        }

        private int proxyHashCode() {
            return this.proxyToString(this.source).hashCode();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.ensureResolved();
            out.writeObject(this.result);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            try {
                this.resolved = true;
                this.result = in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new LazyLoadingException("Could not deserialize result", e);
            }
        }

        @Nullable
        private synchronized Object resolve() {
            if (this.resolved) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Accessing already resolved lazy loading property {}.{}", (Object)(this.property.getOwner() != null ? this.property.getOwner().getName() : "unknown"), (Object)this.property.getName());
                }
                return this.result;
            }
            try {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Resolving lazy loading property {}.{}", (Object)(this.property.getOwner() != null ? this.property.getOwner().getName() : "unknown"), (Object)this.property.getName());
                }
                return this.callback.resolve(this.property);
            }
            catch (RuntimeException ex) {
                DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible(ex);
                if (translatedException instanceof ClientSessionException) {
                    throw new LazyLoadingException("Unable to lazily resolve DBRef! Invalid session state.", ex);
                }
                throw new LazyLoadingException("Unable to lazily resolve DBRef!", translatedException != null ? translatedException : ex);
            }
        }

        static {
            try {
                INITIALIZE_METHOD = LazyLoadingProxy.class.getMethod("getTarget", new Class[0]);
                TO_DBREF_METHOD = LazyLoadingProxy.class.getMethod("toDBRef", new Class[0]);
                FINALIZE_METHOD = Object.class.getDeclaredMethod("finalize", new Class[0]);
                GET_SOURCE_METHOD = LazyLoadingProxy.class.getMethod("getSource", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

