/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.data.domain.Range;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationUtils;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.util.RegexFlags;
import org.springframework.util.Assert;

public class StringOperators {
    public static StringOperatorFactory valueOf(String fieldReference) {
        return new StringOperatorFactory(fieldReference);
    }

    public static StringOperatorFactory valueOf(AggregationExpression fieldReference) {
        return new StringOperatorFactory(fieldReference);
    }

    public static class RegexMatch
    extends AbstractAggregationExpression {
        protected RegexMatch(Object value) {
            super(value);
        }

        public static RegexMatch valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new RegexMatch(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static RegexMatch valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new RegexMatch(Collections.singletonMap("input", expression));
        }

        public RegexMatch options(String options) {
            Assert.notNull((Object)options, "Options must not be null!");
            return new RegexMatch(this.append("options", options));
        }

        public RegexMatch optionsOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new RegexMatch(this.append("options", Fields.field(fieldReference)));
        }

        public RegexMatch optionsOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new RegexMatch(this.append("options", expression));
        }

        public RegexMatch pattern(Pattern pattern) {
            Assert.notNull((Object)pattern, "Pattern must not be null!");
            Map<String, Object> regex = this.append("regex", pattern.pattern());
            regex.put("options", RegexFlags.toRegexOptions(pattern.flags()));
            return new RegexMatch(regex);
        }

        public RegexMatch regex(String regex) {
            Assert.notNull((Object)regex, "Regex must not be null!");
            return new RegexMatch(this.append("regex", regex));
        }

        public RegexMatch regexOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new RegexMatch(this.append("regex", Fields.field(fieldReference)));
        }

        public RegexMatch regexOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new RegexMatch(this.append("regex", expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$regexMatch";
        }
    }

    public static class RegexFindAll
    extends AbstractAggregationExpression {
        protected RegexFindAll(Object value) {
            super(value);
        }

        public static RegexFindAll valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new RegexFindAll(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static RegexFindAll valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new RegexFindAll(Collections.singletonMap("input", expression));
        }

        public RegexFindAll options(String options) {
            Assert.notNull((Object)options, "Options must not be null!");
            return new RegexFindAll(this.append("options", options));
        }

        public RegexFindAll optionsOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "fieldReference must not be null!");
            return new RegexFindAll(this.append("options", Fields.field(fieldReference)));
        }

        public RegexFindAll optionsOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new RegexFindAll(this.append("options", expression));
        }

        public RegexFindAll pattern(Pattern pattern) {
            Assert.notNull((Object)pattern, "Pattern must not be null!");
            Map<String, Object> regex = this.append("regex", pattern.pattern());
            regex.put("options", RegexFlags.toRegexOptions(pattern.flags()));
            return new RegexFindAll(regex);
        }

        public RegexFindAll regex(String regex) {
            Assert.notNull((Object)regex, "Regex must not be null!");
            return new RegexFindAll(this.append("regex", regex));
        }

        public RegexFindAll regexOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "fieldReference must not be null!");
            return new RegexFindAll(this.append("regex", Fields.field(fieldReference)));
        }

        public RegexFindAll regexOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new RegexFindAll(this.append("regex", expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$regexFindAll";
        }
    }

    public static class RegexFind
    extends AbstractAggregationExpression {
        protected RegexFind(Object value) {
            super(value);
        }

        public static RegexFind valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new RegexFind(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static RegexFind valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new RegexFind(Collections.singletonMap("input", expression));
        }

        public RegexFind options(String options) {
            Assert.notNull((Object)options, "Options must not be null!");
            return new RegexFind(this.append("options", options));
        }

        public RegexFind optionsOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new RegexFind(this.append("options", Fields.field(fieldReference)));
        }

        public RegexFind optionsOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new RegexFind(this.append("options", expression));
        }

        public RegexFind regex(String regex) {
            Assert.notNull((Object)regex, "Regex must not be null!");
            return new RegexFind(this.append("regex", regex));
        }

        public RegexFind pattern(Pattern pattern) {
            Assert.notNull((Object)pattern, "Pattern must not be null!");
            Map<String, Object> regex = this.append("regex", pattern.pattern());
            regex.put("options", RegexFlags.toRegexOptions(pattern.flags()));
            return new RegexFind(regex);
        }

        public RegexFind regexOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "fieldReference must not be null!");
            return new RegexFind(this.append("regex", Fields.field(fieldReference)));
        }

        public RegexFind regexOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new RegexFind(this.append("regex", expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$regexFind";
        }
    }

    public static class RTrim
    extends AbstractAggregationExpression {
        private RTrim(Object value) {
            super(value);
        }

        public static RTrim valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new RTrim(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static RTrim valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new RTrim(Collections.singletonMap("input", expression));
        }

        public RTrim chars(String chars) {
            Assert.notNull((Object)chars, "Chars must not be null!");
            return new RTrim(this.append("chars", chars));
        }

        public RTrim charsOf(String fieldReference) {
            return new RTrim(this.append("chars", Fields.field(fieldReference)));
        }

        public RTrim charsOf(AggregationExpression expression) {
            return new RTrim(this.append("chars", expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$rtrim";
        }
    }

    public static class LTrim
    extends AbstractAggregationExpression {
        private LTrim(Object value) {
            super(value);
        }

        public static LTrim valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new LTrim(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static LTrim valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new LTrim(Collections.singletonMap("input", expression));
        }

        public LTrim chars(String chars) {
            Assert.notNull((Object)chars, "Chars must not be null!");
            return new LTrim(this.append("chars", chars));
        }

        public LTrim charsOf(String fieldReference) {
            return new LTrim(this.append("chars", Fields.field(fieldReference)));
        }

        public LTrim charsOf(AggregationExpression expression) {
            return new LTrim(this.append("chars", expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$ltrim";
        }
    }

    public static class Trim
    extends AbstractAggregationExpression {
        private Trim(Object value) {
            super(value);
        }

        public static Trim valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new Trim(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static Trim valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new Trim(Collections.singletonMap("input", expression));
        }

        public Trim chars(String chars) {
            Assert.notNull((Object)chars, "Chars must not be null!");
            return new Trim(this.append("chars", chars));
        }

        public Trim charsOf(String fieldReference) {
            return new Trim(this.append("chars", Fields.field(fieldReference)));
        }

        public Trim charsOf(AggregationExpression expression) {
            return new Trim(this.append("chars", expression));
        }

        public LTrim left() {
            return new LTrim(this.argumentMap());
        }

        public RTrim right() {
            return new RTrim(this.argumentMap());
        }

        @Override
        protected String getMongoMethod() {
            return "$trim";
        }
    }

    public static class SubstrCP
    extends AbstractAggregationExpression {
        private SubstrCP(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$substrCP";
        }

        public static SubstrCP valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new SubstrCP(SubstrCP.asFields(fieldReference));
        }

        public static SubstrCP valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new SubstrCP(Collections.singletonList(expression));
        }

        public SubstrCP substringCP(int start) {
            return this.substringCP(start, -1);
        }

        public SubstrCP substringCP(int start, int nrOfChars) {
            return new SubstrCP(this.append(Arrays.asList(start, nrOfChars)));
        }
    }

    public static class StrLenCP
    extends AbstractAggregationExpression {
        private StrLenCP(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$strLenCP";
        }

        public static StrLenCP stringLengthOfCP(String fieldReference) {
            return new StrLenCP(Fields.field(fieldReference));
        }

        public static StrLenCP stringLengthOfCP(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new StrLenCP(expression);
        }
    }

    public static class StrLenBytes
    extends AbstractAggregationExpression {
        private StrLenBytes(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$strLenBytes";
        }

        public static StrLenBytes stringLengthOf(String fieldReference) {
            return new StrLenBytes(Fields.field(fieldReference));
        }

        public static StrLenBytes stringLengthOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new StrLenBytes(expression);
        }
    }

    public static class Split
    extends AbstractAggregationExpression {
        private Split(List<?> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$split";
        }

        public static Split valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new Split(Split.asFields(fieldReference));
        }

        public static Split valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new Split(Collections.singletonList(expression));
        }

        public Split split(String delimiter) {
            Assert.notNull((Object)delimiter, "Delimiter must not be null!");
            return new Split(this.append(delimiter));
        }

        public Split split(Field fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new Split(this.append(fieldReference));
        }

        public Split split(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new Split(this.append(expression));
        }
    }

    public static class IndexOfCP
    extends AbstractAggregationExpression {
        private IndexOfCP(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$indexOfCP";
        }

        public static SubstringBuilder valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new SubstringBuilder(Fields.field(fieldReference));
        }

        public static SubstringBuilder valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new SubstringBuilder(expression);
        }

        public IndexOfCP within(Range<Long> range) {
            return new IndexOfCP(this.append(AggregationUtils.toRangeValues(range)));
        }

        public static class SubstringBuilder {
            private final Object stringExpression;

            private SubstringBuilder(Object stringExpression) {
                this.stringExpression = stringExpression;
            }

            public IndexOfCP indexOf(String substring) {
                return new IndexOfCP(Arrays.asList(this.stringExpression, substring));
            }

            public IndexOfCP indexOf(AggregationExpression expression) {
                return new IndexOfCP(Arrays.asList(this.stringExpression, expression));
            }

            public IndexOfCP indexOf(Field fieldReference) {
                return new IndexOfCP(Arrays.asList(this.stringExpression, fieldReference));
            }
        }
    }

    public static class IndexOfBytes
    extends AbstractAggregationExpression {
        private IndexOfBytes(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$indexOfBytes";
        }

        public static SubstringBuilder valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new SubstringBuilder(Fields.field(fieldReference));
        }

        public static SubstringBuilder valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new SubstringBuilder(expression);
        }

        public IndexOfBytes within(Range<Long> range) {
            return new IndexOfBytes(this.append(AggregationUtils.toRangeValues(range)));
        }

        public static class SubstringBuilder {
            private final Object stringExpression;

            private SubstringBuilder(Object stringExpression) {
                this.stringExpression = stringExpression;
            }

            public IndexOfBytes indexOf(String substring) {
                return new IndexOfBytes(Arrays.asList(this.stringExpression, substring));
            }

            public IndexOfBytes indexOf(AggregationExpression expression) {
                return new IndexOfBytes(Arrays.asList(this.stringExpression, expression));
            }

            public IndexOfBytes indexOf(Field fieldReference) {
                return new IndexOfBytes(Arrays.asList(this.stringExpression, fieldReference));
            }
        }
    }

    public static class StrCaseCmp
    extends AbstractAggregationExpression {
        private StrCaseCmp(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$strcasecmp";
        }

        public static StrCaseCmp valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new StrCaseCmp(StrCaseCmp.asFields(fieldReference));
        }

        public static StrCaseCmp valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new StrCaseCmp(Collections.singletonList(expression));
        }

        public static StrCaseCmp stringValue(String value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new StrCaseCmp(Collections.singletonList(value));
        }

        public StrCaseCmp strcasecmp(String value) {
            return new StrCaseCmp(this.append(value));
        }

        public StrCaseCmp strcasecmpValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new StrCaseCmp(this.append(Fields.field(fieldReference)));
        }

        public StrCaseCmp strcasecmpValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new StrCaseCmp(this.append(expression));
        }
    }

    public static class ToUpper
    extends AbstractAggregationExpression {
        private ToUpper(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toUpper";
        }

        public static ToUpper upperValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new ToUpper(Fields.field(fieldReference));
        }

        public static ToUpper upperValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new ToUpper(Collections.singletonList(expression));
        }

        public static ToUpper upper(String value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new ToUpper(value);
        }
    }

    public static class ToLower
    extends AbstractAggregationExpression {
        private ToLower(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toLower";
        }

        public static ToLower lowerValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new ToLower(Fields.field(fieldReference));
        }

        public static ToLower lowerValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new ToLower(Collections.singletonList(expression));
        }

        public static ToLower lower(String value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new ToLower(value);
        }
    }

    public static class Substr
    extends AbstractAggregationExpression {
        private Substr(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$substr";
        }

        public static Substr valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new Substr(Substr.asFields(fieldReference));
        }

        public static Substr valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new Substr(Collections.singletonList(expression));
        }

        public Substr substring(int start) {
            return this.substring(start, -1);
        }

        public Substr substring(int start, int nrOfChars) {
            return new Substr(this.append(Arrays.asList(start, nrOfChars)));
        }
    }

    public static class Concat
    extends AbstractAggregationExpression {
        private Concat(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$concat";
        }

        public static Concat valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new Concat(Concat.asFields(fieldReference));
        }

        public static Concat valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new Concat(Collections.singletonList(expression));
        }

        public static Concat stringValue(String value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new Concat(Collections.singletonList(value));
        }

        public Concat concatValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return new Concat(this.append(Fields.field(fieldReference)));
        }

        public Concat concatValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return new Concat(this.append(expression));
        }

        public Concat concat(String value) {
            return new Concat(this.append(value));
        }
    }

    public static class StringOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public StringOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public StringOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            this.fieldReference = null;
            this.expression = expression;
        }

        public Concat concatValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return this.createConcat().concatValueOf(fieldReference);
        }

        public Concat concatValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return this.createConcat().concatValueOf(expression);
        }

        public Concat concat(String value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return this.createConcat().concat(value);
        }

        private Concat createConcat() {
            return this.usesFieldRef() ? Concat.valueOf(this.fieldReference) : Concat.valueOf(this.expression);
        }

        public Substr substring(int start) {
            return this.substring(start, -1);
        }

        public Substr substring(int start, int nrOfChars) {
            return this.createSubstr().substring(start, nrOfChars);
        }

        private Substr createSubstr() {
            return this.usesFieldRef() ? Substr.valueOf(this.fieldReference) : Substr.valueOf(this.expression);
        }

        public ToLower toLower() {
            return this.usesFieldRef() ? ToLower.lowerValueOf(this.fieldReference) : ToLower.lowerValueOf(this.expression);
        }

        public ToUpper toUpper() {
            return this.usesFieldRef() ? ToUpper.upperValueOf(this.fieldReference) : ToUpper.upperValueOf(this.expression);
        }

        public StrCaseCmp strCaseCmp(String value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return this.createStrCaseCmp().strcasecmp(value);
        }

        public StrCaseCmp strCaseCmpValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return this.createStrCaseCmp().strcasecmpValueOf(fieldReference);
        }

        public StrCaseCmp strCaseCmpValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return this.createStrCaseCmp().strcasecmpValueOf(expression);
        }

        private StrCaseCmp createStrCaseCmp() {
            return this.usesFieldRef() ? StrCaseCmp.valueOf(this.fieldReference) : StrCaseCmp.valueOf(this.expression);
        }

        public IndexOfBytes indexOf(String substring) {
            Assert.notNull((Object)substring, "Substring must not be null!");
            return this.createIndexOfBytesSubstringBuilder().indexOf(substring);
        }

        public IndexOfBytes indexOf(Field fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return this.createIndexOfBytesSubstringBuilder().indexOf(fieldReference);
        }

        public IndexOfBytes indexOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return this.createIndexOfBytesSubstringBuilder().indexOf(expression);
        }

        private IndexOfBytes.SubstringBuilder createIndexOfBytesSubstringBuilder() {
            return this.usesFieldRef() ? IndexOfBytes.valueOf(this.fieldReference) : IndexOfBytes.valueOf(this.expression);
        }

        public IndexOfCP indexOfCP(String substring) {
            Assert.notNull((Object)substring, "Substring must not be null!");
            return this.createIndexOfCPSubstringBuilder().indexOf(substring);
        }

        public IndexOfCP indexOfCP(Field fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null!");
            return this.createIndexOfCPSubstringBuilder().indexOf(fieldReference);
        }

        public IndexOfCP indexOfCP(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            return this.createIndexOfCPSubstringBuilder().indexOf(expression);
        }

        private IndexOfCP.SubstringBuilder createIndexOfCPSubstringBuilder() {
            return this.usesFieldRef() ? IndexOfCP.valueOf(this.fieldReference) : IndexOfCP.valueOf(this.expression);
        }

        public Split split(String delimiter) {
            return this.createSplit().split(delimiter);
        }

        public Split split(Field fieldReference) {
            return this.createSplit().split(fieldReference);
        }

        public Split split(AggregationExpression expression) {
            return this.createSplit().split(expression);
        }

        private Split createSplit() {
            return this.usesFieldRef() ? Split.valueOf(this.fieldReference) : Split.valueOf(this.expression);
        }

        public StrLenBytes length() {
            return this.usesFieldRef() ? StrLenBytes.stringLengthOf(this.fieldReference) : StrLenBytes.stringLengthOf(this.expression);
        }

        public StrLenCP lengthCP() {
            return this.usesFieldRef() ? StrLenCP.stringLengthOfCP(this.fieldReference) : StrLenCP.stringLengthOfCP(this.expression);
        }

        public SubstrCP substringCP(int codePointStart) {
            return this.substringCP(codePointStart, -1);
        }

        public SubstrCP substringCP(int codePointStart, int nrOfCodePoints) {
            return this.createSubstrCP().substringCP(codePointStart, nrOfCodePoints);
        }

        private SubstrCP createSubstrCP() {
            return this.usesFieldRef() ? SubstrCP.valueOf(this.fieldReference) : SubstrCP.valueOf(this.expression);
        }

        public Trim trim() {
            return this.createTrim();
        }

        public Trim trim(String chars) {
            return this.trim().chars(chars);
        }

        public Trim trim(AggregationExpression expression) {
            return this.trim().charsOf(expression);
        }

        private Trim createTrim() {
            return this.usesFieldRef() ? Trim.valueOf(this.fieldReference) : Trim.valueOf(this.expression);
        }

        public LTrim ltrim() {
            return this.createLTrim();
        }

        public LTrim ltrim(String chars) {
            return this.ltrim().chars(chars);
        }

        public LTrim ltrim(AggregationExpression expression) {
            return this.ltrim().charsOf(expression);
        }

        private LTrim createLTrim() {
            return this.usesFieldRef() ? LTrim.valueOf(this.fieldReference) : LTrim.valueOf(this.expression);
        }

        public RTrim rtrim() {
            return this.createRTrim();
        }

        public RTrim rtrim(String chars) {
            return this.rtrim().chars(chars);
        }

        public RTrim rtrim(AggregationExpression expression) {
            return this.rtrim().charsOf(expression);
        }

        private RTrim createRTrim() {
            return this.usesFieldRef() ? RTrim.valueOf(this.fieldReference) : RTrim.valueOf(this.expression);
        }

        public RegexFind regexFind(String regex) {
            return this.createRegexFind().regex(regex);
        }

        public RegexFind regexFind(AggregationExpression expression) {
            return this.createRegexFind().regexOf(expression);
        }

        public RegexFind regexFind(Pattern pattern) {
            return this.createRegexFind().pattern(pattern);
        }

        public RegexFind regexFind(String regex, String options) {
            return this.createRegexFind().regex(regex).options(options);
        }

        private RegexFind createRegexFind() {
            return this.usesFieldRef() ? RegexFind.valueOf(this.fieldReference) : RegexFind.valueOf(this.expression);
        }

        public RegexFindAll regexFindAll(String regex) {
            return this.createRegexFindAll().regex(regex);
        }

        public RegexFindAll regexFindAll(AggregationExpression expression) {
            return this.createRegexFindAll().regexOf(expression);
        }

        public RegexFindAll regexFindAll(Pattern pattern) {
            return this.createRegexFindAll().pattern(pattern);
        }

        public RegexFindAll regexFindAll(String regex, String options) {
            return this.createRegexFindAll().regex(regex).options(options);
        }

        private RegexFindAll createRegexFindAll() {
            return this.usesFieldRef() ? RegexFindAll.valueOf(this.fieldReference) : RegexFindAll.valueOf(this.expression);
        }

        public RegexMatch regexMatch(String regex) {
            return this.createRegexMatch().regex(regex);
        }

        public RegexMatch regexMatch(AggregationExpression expression) {
            return this.createRegexMatch().regexOf(expression);
        }

        public RegexMatch regexMatch(Pattern pattern) {
            return this.createRegexMatch().pattern(pattern);
        }

        public RegexMatch regexMatch(String regex, String options) {
            return this.createRegexMatch().regex(regex).options(options);
        }

        private RegexMatch createRegexMatch() {
            return this.usesFieldRef() ? RegexMatch.valueOf(this.fieldReference) : RegexMatch.valueOf(this.expression);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }
}

