/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SortByCountOperation
implements AggregationOperation {
    @Nullable
    private final Field groupByField;
    @Nullable
    private final AggregationExpression groupByExpression;

    public SortByCountOperation(Field groupByField) {
        Assert.notNull((Object)groupByField, "Group by field must not be null!");
        this.groupByField = groupByField;
        this.groupByExpression = null;
    }

    public SortByCountOperation(AggregationExpression groupByExpression) {
        Assert.notNull((Object)groupByExpression, "Group by expression must not be null!");
        this.groupByExpression = groupByExpression;
        this.groupByField = null;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return new Document(this.getOperator(), this.groupByExpression == null ? context.getReference(this.groupByField).toString() : this.groupByExpression.toDocument(context));
    }

    @Override
    public String getOperator() {
        return "$sortByCount";
    }
}

