/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ScriptOperators {
    public static Function function(String body) {
        return Function.function(body);
    }

    public static Accumulator.AccumulatorInitBuilder accumulatorBuilder() {
        return new Accumulator.AccumulatorBuilder();
    }

    public static class Accumulator
    extends AbstractAggregationExpression {
        private Accumulator(Map<String, Object> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$accumulator";
        }

        static class AccumulatorBuilder
        implements AccumulatorInitBuilder,
        AccumulatorInitArgsBuilder,
        AccumulatorAccumulateBuilder,
        AccumulatorAccumulateArgsBuilder,
        AccumulatorMergeBuilder,
        AccumulatorFinalizeBuilder {
            private List<Object> initArgs;
            private String initFunction;
            private List<Object> accumulateArgs;
            private String accumulateFunction;
            private String mergeFunction;
            private String finalizeFunction;
            private String lang = "js";

            AccumulatorBuilder() {
            }

            @Override
            public AccumulatorBuilder init(String function) {
                this.initFunction = function;
                return this;
            }

            @Override
            public AccumulatorBuilder initArgs(List<Object> args) {
                Assert.notNull(args, "Args must not be null");
                this.initArgs = new ArrayList<Object>(args);
                return this;
            }

            @Override
            public AccumulatorBuilder accumulate(String function) {
                Assert.notNull((Object)function, "Accumulate function must not be null");
                this.accumulateFunction = function;
                return this;
            }

            @Override
            public AccumulatorBuilder accumulateArgs(List<Object> args) {
                Assert.notNull(args, "Args must not be null");
                this.accumulateArgs = new ArrayList<Object>(args);
                return this;
            }

            @Override
            public AccumulatorBuilder merge(String function) {
                Assert.notNull((Object)function, "Merge function must not be null");
                this.mergeFunction = function;
                return this;
            }

            @Override
            public AccumulatorBuilder lang(String lang) {
                Assert.hasText(lang, "Lang must not be null nor empty! The default would be 'js'.");
                this.lang = lang;
                return this;
            }

            @Override
            public Accumulator finalize(String function) {
                Assert.notNull((Object)function, "Finalize function must not be null");
                this.finalizeFunction = function;
                Map<String, Object> args = this.createArgumentMap();
                args.put(Fields.FINALIZE.toString(), this.finalizeFunction);
                return new Accumulator(args);
            }

            @Override
            public Accumulator build() {
                return new Accumulator(this.createArgumentMap());
            }

            private Map<String, Object> createArgumentMap() {
                LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
                args.put(Fields.INIT.toString(), this.initFunction);
                if (!CollectionUtils.isEmpty(this.initArgs)) {
                    args.put(Fields.INIT_ARGS.toString(), this.initArgs);
                }
                args.put(Fields.ACCUMULATE.toString(), this.accumulateFunction);
                if (!CollectionUtils.isEmpty(this.accumulateArgs)) {
                    args.put(Fields.ACCUMULATE_ARGS.toString(), this.accumulateArgs);
                }
                args.put(Fields.MERGE.toString(), this.mergeFunction);
                args.put(Fields.LANG.toString(), this.lang);
                return args;
            }
        }

        public static interface AccumulatorFinalizeBuilder {
            public Accumulator finalize(String var1);

            public Accumulator build();
        }

        public static interface AccumulatorMergeBuilder {
            public AccumulatorFinalizeBuilder merge(String var1);
        }

        public static interface AccumulatorAccumulateArgsBuilder
        extends AccumulatorMergeBuilder {
            default public AccumulatorMergeBuilder accumulateArgs(Object ... args) {
                return this.accumulateArgs(Arrays.asList(args));
            }

            public AccumulatorMergeBuilder accumulateArgs(List<Object> var1);
        }

        public static interface AccumulatorAccumulateBuilder {
            default public AccumulatorMergeBuilder accumulate(Function function) {
                return this.accumulate(function.getBody()).accumulateArgs(function.getArgs());
            }

            public AccumulatorAccumulateArgsBuilder accumulate(String var1);
        }

        public static interface AccumulatorInitArgsBuilder
        extends AccumulatorAccumulateBuilder {
            default public AccumulatorAccumulateBuilder initArgs(Object ... args) {
                return this.initArgs(Arrays.asList(args));
            }

            public AccumulatorAccumulateBuilder initArgs(List<Object> var1);
        }

        public static interface AccumulatorInitBuilder {
            default public AccumulatorAccumulateBuilder init(Function function) {
                return this.init(function.getBody()).initArgs(function.getArgs());
            }

            public AccumulatorInitArgsBuilder init(String var1);

            public AccumulatorInitBuilder lang(String var1);
        }

        static enum Fields {
            ACCUMULATE("accumulate"),
            ACCUMULATE_ARGS("accumulateArgs"),
            FINALIZE("finalize"),
            INIT("init"),
            INIT_ARGS("initArgs"),
            LANG("lang"),
            MERGE("merge");

            private String field;

            private Fields(String field) {
                this.field = field;
            }

            public String toString() {
                return this.field;
            }
        }
    }

    public static class Function
    extends AbstractAggregationExpression {
        private Function(Map<String, Object> values) {
            super(values);
        }

        public static Function function(String body) {
            Assert.notNull((Object)body, "Function body must not be null!");
            LinkedHashMap<String, Object> function = new LinkedHashMap<String, Object>(2);
            function.put(Fields.BODY.toString(), body);
            function.put(Fields.ARGS.toString(), Collections.emptyList());
            function.put(Fields.LANG.toString(), "js");
            return new Function(function);
        }

        public Function args(Object ... args) {
            return this.args(Arrays.asList(args));
        }

        public Function args(List<Object> args) {
            Assert.notNull(args, "Args must not be null! Use an empty list instead.");
            return new Function(this.appendAt(1, Fields.ARGS.toString(), args));
        }

        public Function lang(String lang) {
            Assert.hasText(lang, "Lang must not be null nor empty! The default would be 'js'.");
            return new Function(this.appendAt(2, Fields.LANG.toString(), lang));
        }

        @Nullable
        List<Object> getArgs() {
            return (List)this.get(Fields.ARGS.toString());
        }

        String getBody() {
            return (String)this.get(Fields.BODY.toString());
        }

        String getLang() {
            return (String)this.get(Fields.LANG.toString());
        }

        @Override
        protected String getMongoMethod() {
            return "$function";
        }

        static enum Fields {
            BODY,
            ARGS,
            LANG;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

