/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ConditionalOperators;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.util.Assert;

public class RedactOperation
implements AggregationOperation {
    public static final String DESCEND = "$$DESCEND";
    public static final String KEEP = "$$KEEP";
    public static final String PRUNE = "$$PRUNE";
    private final AggregationExpression condition;

    public RedactOperation(AggregationExpression condition) {
        Assert.notNull((Object)condition, "Condition must not be null!");
        this.condition = condition;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return new Document(this.getOperator(), this.condition.toDocument(context));
    }

    @Override
    public String getOperator() {
        return "$redact";
    }

    public static RedactOperationBuilder builder() {
        return new RedactOperationBuilder();
    }

    public static class RedactOperationBuilder {
        private Object when;
        private Object then;
        private Object otherwise;

        private RedactOperationBuilder() {
        }

        public RedactOperationBuilder when(CriteriaDefinition criteria) {
            this.when = criteria;
            return this;
        }

        public RedactOperationBuilder when(AggregationExpression condition) {
            this.when = condition;
            return this;
        }

        public RedactOperationBuilder when(Document condition) {
            this.when = condition;
            return this;
        }

        public RedactOperationBuilder thenDescend() {
            return this.then(RedactOperation.DESCEND);
        }

        public RedactOperationBuilder thenKeep() {
            return this.then(RedactOperation.KEEP);
        }

        public RedactOperationBuilder thenPrune() {
            return this.then(RedactOperation.PRUNE);
        }

        public RedactOperationBuilder then(Object then) {
            this.then = then;
            return this;
        }

        public RedactOperationBuilder otherwiseDescend() {
            return this.otherwise(RedactOperation.DESCEND);
        }

        public RedactOperationBuilder otherwiseKeep() {
            return this.otherwise(RedactOperation.KEEP);
        }

        public RedactOperationBuilder otherwisePrune() {
            return this.otherwise(RedactOperation.PRUNE);
        }

        public RedactOperationBuilder otherwise(Object otherwise) {
            this.otherwise = otherwise;
            return this;
        }

        public RedactOperation build() {
            return new RedactOperation(this.when().then(this.then).otherwise(this.otherwise));
        }

        private ConditionalOperators.Cond.ThenBuilder when() {
            if (this.when instanceof CriteriaDefinition) {
                return ConditionalOperators.Cond.when((CriteriaDefinition)this.when);
            }
            if (this.when instanceof AggregationExpression) {
                return ConditionalOperators.Cond.when((AggregationExpression)this.when);
            }
            if (this.when instanceof Document) {
                return ConditionalOperators.Cond.when((Document)this.when);
            }
            throw new IllegalArgumentException(String.format("Invalid Condition. Expected CriteriaDefinition, AggregationExpression or Document but was %s.", this.when));
        }
    }
}

