/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.util.Assert;

public class MatchOperation
implements AggregationOperation {
    private final CriteriaDefinition criteriaDefinition;
    private final AggregationExpression expression;

    public MatchOperation(CriteriaDefinition criteriaDefinition) {
        Assert.notNull((Object)criteriaDefinition, "Criteria must not be null!");
        this.criteriaDefinition = criteriaDefinition;
        this.expression = null;
    }

    public MatchOperation(AggregationExpression expression) {
        Assert.notNull((Object)expression, "Expression must not be null!");
        this.criteriaDefinition = null;
        this.expression = expression;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return new Document(this.getOperator(), context.getMappedObject(this.expression != null ? this.expression.toDocument() : this.criteriaDefinition.getCriteriaObject()));
    }

    @Override
    public String getOperator() {
        return "$match";
    }
}

