/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class LookupOperation
implements FieldsExposingAggregationOperation,
FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private final Field from;
    private final Field localField;
    private final Field foreignField;
    private final ExposedFields.ExposedField as;

    public LookupOperation(Field from, Field localField, Field foreignField, Field as) {
        Assert.notNull((Object)from, "From must not be null!");
        Assert.notNull((Object)localField, "LocalField must not be null!");
        Assert.notNull((Object)foreignField, "ForeignField must not be null!");
        Assert.notNull((Object)as, "As must not be null!");
        this.from = from;
        this.localField = localField;
        this.foreignField = foreignField;
        this.as = new ExposedFields.ExposedField(as, true);
    }

    @Override
    public ExposedFields getFields() {
        return ExposedFields.from(this.as);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document lookupObject = new Document();
        lookupObject.append("from", this.from.getTarget());
        lookupObject.append("localField", this.localField.getTarget());
        lookupObject.append("foreignField", this.foreignField.getTarget());
        lookupObject.append("as", this.as.getTarget());
        return new Document(this.getOperator(), lookupObject);
    }

    @Override
    public String getOperator() {
        return "$lookup";
    }

    public static FromBuilder newLookup() {
        return new LookupOperationBuilder();
    }

    public static final class LookupOperationBuilder
    implements FromBuilder,
    LocalFieldBuilder,
    ForeignFieldBuilder,
    AsBuilder {
        @Nullable
        private Field from;
        @Nullable
        private Field localField;
        @Nullable
        private Field foreignField;
        @Nullable
        private ExposedFields.ExposedField as;

        public static FromBuilder newBuilder() {
            return new LookupOperationBuilder();
        }

        @Override
        public LocalFieldBuilder from(String name) {
            Assert.hasText(name, "'From' must not be null or empty!");
            this.from = Fields.field(name);
            return this;
        }

        @Override
        public LookupOperation as(String name) {
            Assert.hasText(name, "'As' must not be null or empty!");
            this.as = new ExposedFields.ExposedField(Fields.field(name), true);
            return new LookupOperation(this.from, this.localField, this.foreignField, this.as);
        }

        @Override
        public AsBuilder foreignField(String name) {
            Assert.hasText(name, "'ForeignField' must not be null or empty!");
            this.foreignField = Fields.field(name);
            return this;
        }

        @Override
        public ForeignFieldBuilder localField(String name) {
            Assert.hasText(name, "'LocalField' must not be null or empty!");
            this.localField = Fields.field(name);
            return this;
        }
    }

    public static interface AsBuilder {
        public LookupOperation as(String var1);
    }

    public static interface ForeignFieldBuilder {
        public AsBuilder foreignField(String var1);
    }

    public static interface LocalFieldBuilder {
        public ForeignFieldBuilder localField(String var1);
    }

    public static interface FromBuilder {
        public LocalFieldBuilder from(String var1);
    }
}

