/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GeoNearOperation
implements AggregationOperation {
    private final NearQuery nearQuery;
    private final String distanceField;
    @Nullable
    private final String indexKey;

    public GeoNearOperation(NearQuery nearQuery, String distanceField) {
        this(nearQuery, distanceField, null);
    }

    private GeoNearOperation(NearQuery nearQuery, String distanceField, @Nullable String indexKey) {
        Assert.notNull((Object)nearQuery, "NearQuery must not be null.");
        Assert.hasLength(distanceField, "Distance field must not be null or empty.");
        this.nearQuery = nearQuery;
        this.distanceField = distanceField;
        this.indexKey = indexKey;
    }

    public GeoNearOperation useIndex(String key) {
        return new GeoNearOperation(this.nearQuery, this.distanceField, key);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document command = context.getMappedObject(this.nearQuery.toDocument());
        if (command.containsKey("query")) {
            command.replace("query", context.getMappedObject((Document)((Object)command.get((Object)"query", Document.class))));
        }
        command.remove("collation");
        command.put("distanceField", (Object)this.distanceField);
        if (StringUtils.hasText(this.indexKey)) {
            command.put("key", (Object)this.indexKey);
        }
        return new Document(this.getOperator(), command);
    }

    @Override
    public String getOperator() {
        return "$geoNear";
    }

    @Override
    public List<Document> toPipelineStages(AggregationOperationContext context) {
        Document command = this.toDocument(context);
        Number limit = (Number)((Document)((Object)command.get((Object)"$geoNear", Document.class))).remove("num");
        ArrayList<Document> stages = new ArrayList<Document>();
        stages.add(command);
        if (this.nearQuery.getSkip() != null && this.nearQuery.getSkip() > 0L) {
            stages.add(new Document("$skip", this.nearQuery.getSkip()));
        }
        if (limit != null) {
            stages.add(new Document("$limit", limit.longValue()));
        }
        return stages;
    }
}

