/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.InheritingExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.SpelExpressionTransformer;
import org.springframework.util.Assert;

abstract class DocumentEnhancingOperation
implements FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private final Map<Object, Object> valueMap;
    private ExposedFields exposedFields = ExposedFields.empty();

    protected DocumentEnhancingOperation(Map<Object, Object> source) {
        this.valueMap = new LinkedHashMap<Object, Object>(source);
        for (Object key : source.keySet()) {
            this.exposedFields = this.add(key);
        }
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        InheritingExposedFieldsAggregationOperationContext operationContext = new InheritingExposedFieldsAggregationOperationContext(this.exposedFields, context);
        if (this.valueMap.size() == 1) {
            return context.getMappedObject(new Document(this.mongoOperator(), DocumentEnhancingOperation.toSetEntry(this.valueMap.entrySet().iterator().next(), operationContext)));
        }
        Document $set = new Document();
        this.valueMap.entrySet().stream().map(it -> DocumentEnhancingOperation.toSetEntry(it, operationContext)).forEach($set::putAll);
        return context.getMappedObject(new Document(this.mongoOperator(), $set));
    }

    protected abstract String mongoOperator();

    @Override
    public String getOperator() {
        return this.mongoOperator();
    }

    protected Map<Object, Object> getValueMap() {
        return this.valueMap;
    }

    @Override
    public ExposedFields getFields() {
        return this.exposedFields;
    }

    private ExposedFields add(Object field) {
        if (field instanceof Field) {
            return this.exposedFields.and(new ExposedFields.ExposedField((Field)field, true));
        }
        if (field instanceof String) {
            return this.exposedFields.and(new ExposedFields.ExposedField(Fields.field((String)field), true));
        }
        throw new IllegalArgumentException(String.format("Expected %s to be a field/property.", field));
    }

    private static Document toSetEntry(Map.Entry<Object, Object> entry, AggregationOperationContext context) {
        String field = entry.getKey() instanceof String ? context.getReference((String)entry.getKey()).getRaw() : context.getReference((Field)entry.getKey()).getRaw();
        Object value = DocumentEnhancingOperation.computeValue(entry.getValue(), context);
        return new Document(field, value);
    }

    private static Object computeValue(Object value, AggregationOperationContext context) {
        if (value instanceof Field) {
            return context.getReference((Field)value).toString();
        }
        if (value instanceof ExpressionProjection) {
            return ((ExpressionProjection)value).toExpression(context);
        }
        if (value instanceof AggregationExpression) {
            return ((AggregationExpression)value).toDocument(context);
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(it -> DocumentEnhancingOperation.computeValue(it, context)).collect(Collectors.toList());
        }
        return value;
    }

    static class ExpressionProjection {
        private static final SpelExpressionTransformer TRANSFORMER = new SpelExpressionTransformer();
        private final String expression;
        private final Object[] params;

        ExpressionProjection(String expression, Object[] parameters) {
            Assert.notNull((Object)expression, "Expression must not be null!");
            Assert.notNull((Object)parameters, "Parameters must not be null!");
            this.expression = expression;
            this.params = (Object[])parameters.clone();
        }

        Object toExpression(AggregationOperationContext context) {
            return TRANSFORMER.transform(this.expression, context, this.params);
        }
    }
}

