/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.WriteConcern;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import org.bson.codecs.configuration.CodecRegistry;
import org.reactivestreams.Publisher;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.SessionAwareMethodInterceptor;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Mono;

public class SimpleReactiveMongoDatabaseFactory
implements DisposableBean,
ReactiveMongoDatabaseFactory {
    private final MongoClient mongo;
    private final String databaseName;
    private final boolean mongoInstanceCreated;
    private final PersistenceExceptionTranslator exceptionTranslator;
    @Nullable
    private WriteConcern writeConcern;

    public SimpleReactiveMongoDatabaseFactory(ConnectionString connectionString) {
        this(MongoClients.create((ConnectionString)connectionString), connectionString.getDatabase(), true);
    }

    public SimpleReactiveMongoDatabaseFactory(MongoClient mongoClient, String databaseName) {
        this(mongoClient, databaseName, false);
    }

    private SimpleReactiveMongoDatabaseFactory(MongoClient client, String databaseName, boolean mongoInstanceCreated) {
        Assert.notNull((Object)client, "MongoClient must not be null!");
        Assert.hasText(databaseName, "Database name must not be empty!");
        Assert.isTrue(databaseName.matches("[^/\\\\.$\"\\s]+"), "Database name must not contain slashes, dots, spaces, quotes, or dollar signs!");
        this.mongo = client;
        this.databaseName = databaseName;
        this.mongoInstanceCreated = mongoInstanceCreated;
        this.exceptionTranslator = new MongoExceptionTranslator();
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    @Override
    public Mono<MongoDatabase> getMongoDatabase() throws DataAccessException {
        return this.getMongoDatabase(this.databaseName);
    }

    @Override
    public Mono<MongoDatabase> getMongoDatabase(String dbName) throws DataAccessException {
        Assert.hasText(dbName, "Database name must not be empty.");
        return Mono.fromSupplier(() -> {
            MongoDatabase db = this.mongo.getDatabase(dbName);
            return this.writeConcern != null ? db.withWriteConcern(this.writeConcern) : db;
        });
    }

    @Override
    public void destroy() throws Exception {
        if (this.mongoInstanceCreated) {
            this.mongo.close();
        }
    }

    @Override
    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.mongo.getDatabase(this.databaseName).getCodecRegistry();
    }

    @Override
    public Mono<ClientSession> getSession(ClientSessionOptions options) {
        return Mono.from((Publisher)this.mongo.startSession(options));
    }

    @Override
    public ReactiveMongoDatabaseFactory withSession(ClientSession session) {
        return new ClientSessionBoundMongoDbFactory(session, this);
    }

    static final class ClientSessionBoundMongoDbFactory
    implements ReactiveMongoDatabaseFactory {
        private final ClientSession session;
        private final ReactiveMongoDatabaseFactory delegate;

        ClientSessionBoundMongoDbFactory(ClientSession session, ReactiveMongoDatabaseFactory delegate) {
            this.session = session;
            this.delegate = delegate;
        }

        @Override
        public Mono<MongoDatabase> getMongoDatabase() throws DataAccessException {
            return this.delegate.getMongoDatabase().map(this::decorateDatabase);
        }

        @Override
        public Mono<MongoDatabase> getMongoDatabase(String dbName) throws DataAccessException {
            return this.delegate.getMongoDatabase(dbName).map(this::decorateDatabase);
        }

        @Override
        public PersistenceExceptionTranslator getExceptionTranslator() {
            return this.delegate.getExceptionTranslator();
        }

        @Override
        public CodecRegistry getCodecRegistry() {
            return this.delegate.getCodecRegistry();
        }

        @Override
        public Mono<ClientSession> getSession(ClientSessionOptions options) {
            return this.delegate.getSession(options);
        }

        @Override
        public ReactiveMongoDatabaseFactory withSession(ClientSession session) {
            return this.delegate.withSession(session);
        }

        @Override
        public boolean isTransactionActive() {
            return this.session != null && this.session.hasActiveTransaction();
        }

        private MongoDatabase decorateDatabase(MongoDatabase database) {
            return this.createProxyInstance((com.mongodb.session.ClientSession)this.session, database, MongoDatabase.class);
        }

        private MongoDatabase proxyDatabase(com.mongodb.session.ClientSession session, MongoDatabase database) {
            return this.createProxyInstance(session, database, MongoDatabase.class);
        }

        private MongoCollection proxyCollection(com.mongodb.session.ClientSession session, MongoCollection collection) {
            return this.createProxyInstance(session, collection, MongoCollection.class);
        }

        private <T> T createProxyInstance(com.mongodb.session.ClientSession session, T target, Class<T> targetType) {
            ProxyFactory factory = new ProxyFactory();
            factory.setTarget(target);
            factory.setInterfaces(targetType);
            factory.setOpaque(true);
            factory.addAdvice(new SessionAwareMethodInterceptor<MongoDatabase, MongoCollection>(session, target, ClientSession.class, MongoDatabase.class, this::proxyDatabase, MongoCollection.class, this::proxyCollection));
            return targetType.cast(factory.getProxy(target.getClass().getClassLoader()));
        }

        public ClientSession getSession() {
            return this.session;
        }

        public ReactiveMongoDatabaseFactory getDelegate() {
            return this.delegate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientSessionBoundMongoDbFactory that = (ClientSessionBoundMongoDbFactory)o;
            if (!ObjectUtils.nullSafeEquals(this.session, that.session)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.delegate, that.delegate);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode(this.session);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.delegate);
            return result;
        }

        public String toString() {
            return "SimpleReactiveMongoDatabaseFactory.ClientSessionBoundMongoDbFactory(session=" + this.getSession() + ", delegate=" + this.getDelegate() + ")";
        }
    }
}

