/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.mongodb.core.MongoDatabaseFactorySupport;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;

public class SimpleMongoClientDatabaseFactory
extends MongoDatabaseFactorySupport<MongoClient>
implements DisposableBean {
    public SimpleMongoClientDatabaseFactory(String connectionString) {
        this(new ConnectionString(connectionString));
    }

    public SimpleMongoClientDatabaseFactory(ConnectionString connectionString) {
        this(MongoClients.create(connectionString), connectionString.getDatabase(), true);
    }

    public SimpleMongoClientDatabaseFactory(MongoClient mongoClient, String databaseName) {
        this(mongoClient, databaseName, false);
    }

    SimpleMongoClientDatabaseFactory(MongoClient mongoClient, String databaseName, boolean mongoInstanceCreated) {
        super(mongoClient, databaseName, mongoInstanceCreated, new MongoExceptionTranslator());
    }

    @Override
    public ClientSession getSession(ClientSessionOptions options) {
        return ((MongoClient)this.getMongoClient()).startSession(options);
    }

    @Override
    protected void closeClient() {
        ((MongoClient)this.getMongoClient()).close();
    }

    @Override
    protected MongoDatabase doGetMongoDatabase(String dbName) {
        return ((MongoClient)this.getMongoClient()).getDatabase(dbName);
    }
}

