/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.DeleteResult;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.ReactiveRemoveOperation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveRemoveOperationSupport
implements ReactiveRemoveOperation {
    private static final Query ALL_QUERY = new Query();
    private final ReactiveMongoTemplate tempate;

    ReactiveRemoveOperationSupport(ReactiveMongoTemplate tempate) {
        this.tempate = tempate;
    }

    @Override
    public <T> ReactiveRemoveOperation.ReactiveRemove<T> remove(Class<T> domainType) {
        Assert.notNull(domainType, "DomainType must not be null!");
        return new ReactiveRemoveSupport<T>(this.tempate, domainType, ALL_QUERY, null);
    }

    static class ReactiveRemoveSupport<T>
    implements ReactiveRemoveOperation.ReactiveRemove<T>,
    ReactiveRemoveOperation.RemoveWithCollection<T> {
        private final ReactiveMongoTemplate template;
        private final Class<T> domainType;
        private final Query query;
        private final String collection;

        ReactiveRemoveSupport(ReactiveMongoTemplate template, Class<T> domainType, Query query, String collection) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.collection = collection;
        }

        @Override
        public ReactiveRemoveOperation.RemoveWithQuery<T> inCollection(String collection) {
            Assert.hasText(collection, "Collection must not be null nor empty!");
            return new ReactiveRemoveSupport<T>(this.template, this.domainType, this.query, collection);
        }

        @Override
        public ReactiveRemoveOperation.TerminatingRemove<T> matching(Query query) {
            Assert.notNull((Object)query, "Query must not be null!");
            return new ReactiveRemoveSupport<T>(this.template, this.domainType, query, this.collection);
        }

        @Override
        public Mono<DeleteResult> all() {
            String collectionName = this.getCollectionName();
            return this.template.doRemove(collectionName, this.query, this.domainType);
        }

        @Override
        public Flux<T> findAndRemove() {
            String collectionName = this.getCollectionName();
            return this.template.doFindAndDelete(collectionName, this.query, this.domainType);
        }

        private String getCollectionName() {
            return StringUtils.hasText(this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }
    }
}

