/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import org.springframework.data.mongodb.core.ReactiveAggregationOperation;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

class ReactiveAggregationOperationSupport
implements ReactiveAggregationOperation {
    private final ReactiveMongoTemplate template;

    ReactiveAggregationOperationSupport(ReactiveMongoTemplate template) {
        Assert.notNull((Object)template, "Template must not be null!");
        this.template = template;
    }

    @Override
    public <T> ReactiveAggregationOperation.ReactiveAggregation<T> aggregateAndReturn(Class<T> domainType) {
        Assert.notNull(domainType, "DomainType must not be null!");
        return new ReactiveAggregationSupport<T>(this.template, domainType, null, null);
    }

    static class ReactiveAggregationSupport<T>
    implements ReactiveAggregationOperation.AggregationOperationWithAggregation<T>,
    ReactiveAggregationOperation.ReactiveAggregation<T>,
    ReactiveAggregationOperation.TerminatingAggregationOperation<T> {
        private final ReactiveMongoTemplate template;
        private final Class<T> domainType;
        private final Aggregation aggregation;
        private final String collection;

        ReactiveAggregationSupport(ReactiveMongoTemplate template, Class<T> domainType, Aggregation aggregation, String collection) {
            this.template = template;
            this.domainType = domainType;
            this.aggregation = aggregation;
            this.collection = collection;
        }

        @Override
        public ReactiveAggregationOperation.AggregationOperationWithAggregation<T> inCollection(String collection) {
            Assert.hasText(collection, "Collection must not be null nor empty!");
            return new ReactiveAggregationSupport<T>(this.template, this.domainType, this.aggregation, collection);
        }

        @Override
        public ReactiveAggregationOperation.TerminatingAggregationOperation<T> by(Aggregation aggregation) {
            Assert.notNull((Object)aggregation, "Aggregation must not be null!");
            return new ReactiveAggregationSupport<T>(this.template, this.domainType, aggregation, this.collection);
        }

        @Override
        public Flux<T> all() {
            return this.template.aggregate(this.aggregation, this.getCollectionName(this.aggregation), this.domainType);
        }

        private String getCollectionName(Aggregation aggregation) {
            TypedAggregation typedAggregation;
            if (StringUtils.hasText(this.collection)) {
                return this.collection;
            }
            if (aggregation instanceof TypedAggregation && (typedAggregation = (TypedAggregation)aggregation).getInputType() != null) {
                return this.template.getCollectionName(typedAggregation.getInputType());
            }
            return this.template.getCollectionName(this.domainType);
        }
    }
}

