/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.TimeSeriesGranularity;
import com.mongodb.client.model.TimeSeriesOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoDatabaseUtils;
import org.springframework.data.mongodb.SessionSynchronization;
import org.springframework.data.mongodb.core.AggregationUtil;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.CountQuery;
import org.springframework.data.mongodb.core.CursorPreparer;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.DefaultBulkOperations;
import org.springframework.data.mongodb.core.DefaultIndexOperations;
import org.springframework.data.mongodb.core.DefaultScriptOperations;
import org.springframework.data.mongodb.core.DefaultWriteConcernResolver;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.data.mongodb.core.EntityOperations;
import org.springframework.data.mongodb.core.ExecutableAggregationOperation;
import org.springframework.data.mongodb.core.ExecutableAggregationOperationSupport;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.ExecutableFindOperationSupport;
import org.springframework.data.mongodb.core.ExecutableInsertOperation;
import org.springframework.data.mongodb.core.ExecutableInsertOperationSupport;
import org.springframework.data.mongodb.core.ExecutableMapReduceOperation;
import org.springframework.data.mongodb.core.ExecutableMapReduceOperationSupport;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.ExecutableRemoveOperationSupport;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.ExecutableUpdateOperationSupport;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.IndexConverters;
import org.springframework.data.mongodb.core.MappedDocument;
import org.springframework.data.mongodb.core.MongoAction;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.PropertyOperations;
import org.springframework.data.mongodb.core.QueryOperations;
import org.springframework.data.mongodb.core.ScriptOperations;
import org.springframework.data.mongodb.core.SessionScoped;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.WriteConcernResolver;
import org.springframework.data.mongodb.core.WriteResultChecking;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.JsonSchemaMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.MongoJsonSchemaMapper;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.IndexOperationsProvider;
import org.springframework.data.mongodb.core.index.MongoMappingEventPublisher;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexCreator;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.core.mapreduce.GroupBy;
import org.springframework.data.mongodb.core.mapreduce.GroupByResults;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.mapreduce.MapReduceResults;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.core.timeseries.Granularity;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.util.CloseableIterator;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class MongoTemplate
implements MongoOperations,
ApplicationContextAware,
IndexOperationsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoTemplate.class);
    private static final WriteResultChecking DEFAULT_WRITE_RESULT_CHECKING = WriteResultChecking.NONE;
    private final MongoConverter mongoConverter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoDatabaseFactory mongoDbFactory;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final QueryMapper queryMapper;
    private final UpdateMapper updateMapper;
    private final JsonSchemaMapper schemaMapper;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private final EntityOperations operations;
    private final PropertyOperations propertyOperations;
    private final QueryOperations queryOperations;
    @Nullable
    private WriteConcern writeConcern;
    private WriteConcernResolver writeConcernResolver = DefaultWriteConcernResolver.INSTANCE;
    private WriteResultChecking writeResultChecking = WriteResultChecking.NONE;
    @Nullable
    private ReadPreference readPreference;
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    @Nullable
    private EntityCallbacks entityCallbacks;
    @Nullable
    private ResourceLoader resourceLoader;
    @Nullable
    private MongoPersistentEntityIndexCreator indexCreator;
    private SessionSynchronization sessionSynchronization = SessionSynchronization.ON_ACTUAL_TRANSACTION;

    public MongoTemplate(MongoClient mongoClient, String databaseName) {
        this((MongoDatabaseFactory)new SimpleMongoClientDatabaseFactory(mongoClient, databaseName), (MongoConverter)null);
    }

    public MongoTemplate(MongoDatabaseFactory mongoDbFactory) {
        this(mongoDbFactory, (MongoConverter)null);
    }

    public MongoTemplate(MongoDatabaseFactory mongoDbFactory, @Nullable MongoConverter mongoConverter) {
        MongoMappingContext mappingContext;
        Assert.notNull((Object)mongoDbFactory, "MongoDbFactory must not be null!");
        this.mongoDbFactory = mongoDbFactory;
        this.exceptionTranslator = mongoDbFactory.getExceptionTranslator();
        this.mongoConverter = mongoConverter == null ? MongoTemplate.getDefaultMongoConverter(mongoDbFactory) : mongoConverter;
        this.queryMapper = new QueryMapper(this.mongoConverter);
        this.updateMapper = new UpdateMapper(this.mongoConverter);
        this.schemaMapper = new MongoJsonSchemaMapper(this.mongoConverter);
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.operations = new EntityOperations(this.mongoConverter.getMappingContext());
        this.propertyOperations = new PropertyOperations(this.mongoConverter.getMappingContext());
        this.queryOperations = new QueryOperations(this.queryMapper, this.updateMapper, this.operations, this.propertyOperations, mongoDbFactory);
        this.mappingContext = this.mongoConverter.getMappingContext();
        if (this.mappingContext instanceof MongoMappingContext && (mappingContext = (MongoMappingContext)this.mappingContext).isAutoIndexCreation()) {
            this.indexCreator = new MongoPersistentEntityIndexCreator(mappingContext, this);
            this.eventPublisher = new MongoMappingEventPublisher(this.indexCreator);
            mappingContext.setApplicationEventPublisher(this.eventPublisher);
        }
    }

    private MongoTemplate(MongoDatabaseFactory dbFactory, MongoTemplate that) {
        this.mongoDbFactory = dbFactory;
        this.exceptionTranslator = that.exceptionTranslator;
        this.sessionSynchronization = that.sessionSynchronization;
        this.mongoConverter = that.mongoConverter instanceof MappingMongoConverter ? ((MappingMongoConverter)that.mongoConverter).with(dbFactory) : that.mongoConverter;
        this.queryMapper = that.queryMapper;
        this.updateMapper = that.updateMapper;
        this.schemaMapper = that.schemaMapper;
        this.projectionFactory = that.projectionFactory;
        this.mappingContext = that.mappingContext;
        this.operations = that.operations;
        this.propertyOperations = that.propertyOperations;
        this.queryOperations = that.queryOperations;
    }

    public void setWriteResultChecking(@Nullable WriteResultChecking resultChecking) {
        this.writeResultChecking = resultChecking == null ? DEFAULT_WRITE_RESULT_CHECKING : resultChecking;
    }

    public void setWriteConcern(@Nullable WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setWriteConcernResolver(@Nullable WriteConcernResolver writeConcernResolver) {
        this.writeConcernResolver = writeConcernResolver == null ? DefaultWriteConcernResolver.INSTANCE : writeConcernResolver;
    }

    public void setReadPreference(@Nullable ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.prepareIndexCreator(applicationContext);
        this.eventPublisher = applicationContext;
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create(applicationContext));
        }
        if (this.mappingContext instanceof ApplicationEventPublisherAware) {
            ((ApplicationEventPublisherAware)((Object)this.mappingContext)).setApplicationEventPublisher(this.eventPublisher);
        }
        this.resourceLoader = applicationContext;
        this.projectionFactory.setBeanFactory(applicationContext);
        this.projectionFactory.setBeanClassLoader(applicationContext.getClassLoader());
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, "EntityCallbacks must not be null!");
        this.entityCallbacks = entityCallbacks;
    }

    private void prepareIndexCreator(ApplicationContext context) {
        String[] indexCreators;
        for (String creator : indexCreators = context.getBeanNamesForType(MongoPersistentEntityIndexCreator.class)) {
            MongoPersistentEntityIndexCreator creatorBean = context.getBean(creator, MongoPersistentEntityIndexCreator.class);
            if (!creatorBean.isIndexCreatorFor(this.mappingContext)) continue;
            return;
        }
        if (context instanceof ConfigurableApplicationContext && this.indexCreator != null) {
            ((ConfigurableApplicationContext)context).addApplicationListener(this.indexCreator);
        }
    }

    @Override
    public MongoConverter getConverter() {
        return this.mongoConverter;
    }

    @Override
    public <T> CloseableIterator<T> stream(Query query, Class<T> entityType) {
        return this.stream(query, entityType, this.getCollectionName(entityType));
    }

    @Override
    public <T> CloseableIterator<T> stream(Query query, Class<T> entityType, String collectionName) {
        return this.doStream(query, entityType, collectionName, entityType);
    }

    protected <T> CloseableIterator<T> doStream(Query query, Class<?> entityType, String collectionName, Class<T> returnType) {
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.notNull(entityType, "Entity type must not be null!");
        Assert.hasText(collectionName, "Collection name must not be null or empty!");
        Assert.notNull(returnType, "ReturnType must not be null!");
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoPersistentEntity<?> persistentEntity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)entityType));
            QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(query);
            Document mappedQuery = queryContext.getMappedQuery(persistentEntity);
            Document mappedFields = queryContext.getMappedFields(persistentEntity, returnType, this.projectionFactory);
            FindIterable<Document> cursor = new QueryCursorPreparer(query, entityType).initiateFind(collection, col -> col.find(mappedQuery, Document.class).projection(mappedFields));
            return new CloseableIterableCursorAdapter(cursor, this.exceptionTranslator, new ProjectingReadCallback(this.mongoConverter, entityType, returnType, collectionName));
        });
    }

    @Override
    public String getCollectionName(Class<?> entityClass) {
        return this.operations.determineCollectionName(entityClass);
    }

    @Override
    public Document executeCommand(String jsonCommand) {
        Assert.hasText(jsonCommand, "JsonCommand must not be null nor empty!");
        return this.execute(db -> db.runCommand((Bson)Document.parse(jsonCommand), Document.class));
    }

    @Override
    public Document executeCommand(Document command) {
        Assert.notNull((Object)command, "Command must not be null!");
        return this.execute(db -> db.runCommand((Bson)command, Document.class));
    }

    @Override
    public Document executeCommand(Document command, @Nullable ReadPreference readPreference) {
        Assert.notNull((Object)command, "Command must not be null!");
        return this.execute(db -> readPreference != null ? db.runCommand(command, readPreference, Document.class) : db.runCommand((Bson)command, Document.class));
    }

    @Override
    public void executeQuery(Query query, String collectionName, DocumentCallbackHandler dch) {
        this.executeQuery(query, collectionName, dch, new QueryCursorPreparer(query, null));
    }

    protected void executeQuery(Query query, String collectionName, DocumentCallbackHandler documentCallbackHandler, @Nullable CursorPreparer preparer) {
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        Assert.notNull((Object)documentCallbackHandler, "DocumentCallbackHandler must not be null!");
        Document queryObject = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), Optional.empty());
        Document sortObject = query.getSortObject();
        Document fieldsObject = query.getFieldsObject();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing query: {} sort: {} fields: {} in collection: {}", SerializationUtils.serializeToJsonSafely(queryObject), sortObject, fieldsObject, collectionName);
        }
        this.executeQueryInternal(new FindCallback(queryObject, fieldsObject, null), preparer != null ? preparer : CursorPreparer.NO_OP_PREPARER, documentCallbackHandler, collectionName);
    }

    @Override
    public <T> T execute(DbCallback<T> action) {
        Assert.notNull(action, "DbCallback must not be null!");
        try {
            MongoDatabase db = this.prepareDatabase(this.doGetDatabase());
            return action.doInDB(db);
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Override
    public <T> T execute(Class<?> entityClass, CollectionCallback<T> callback) {
        Assert.notNull(entityClass, "EntityClass must not be null!");
        return this.execute(this.getCollectionName(entityClass), callback);
    }

    @Override
    public <T> T execute(String collectionName, CollectionCallback<T> callback) {
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        Assert.notNull(callback, "CollectionCallback must not be null!");
        try {
            MongoCollection<Document> collection = this.getAndPrepareCollection(this.doGetDatabase(), collectionName);
            return callback.doInCollection(collection);
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Override
    public SessionScoped withSession(ClientSessionOptions options) {
        Assert.notNull((Object)options, "ClientSessionOptions must not be null!");
        return this.withSession(() -> this.mongoDbFactory.getSession(options));
    }

    @Override
    public MongoTemplate withSession(ClientSession session) {
        Assert.notNull((Object)session, "ClientSession must not be null!");
        return new SessionBoundMongoTemplate(session, this);
    }

    public void setSessionSynchronization(SessionSynchronization sessionSynchronization) {
        this.sessionSynchronization = sessionSynchronization;
    }

    @Override
    public <T> MongoCollection<Document> createCollection(Class<T> entityClass) {
        return this.createCollection(entityClass, this.operations.forType(entityClass).getCollectionOptions());
    }

    @Override
    public <T> MongoCollection<Document> createCollection(Class<T> entityClass, @Nullable CollectionOptions collectionOptions) {
        Assert.notNull(entityClass, "EntityClass must not be null!");
        CollectionOptions options = collectionOptions != null ? collectionOptions : CollectionOptions.empty();
        options = Optionals.firstNonEmpty(() -> Optional.ofNullable(collectionOptions).flatMap(CollectionOptions::getCollation), () -> this.operations.forType(entityClass).getCollation()).map(options::collation).orElse(options);
        return this.doCreateCollection(this.getCollectionName(entityClass), this.convertToDocument(options, entityClass));
    }

    @Override
    public MongoCollection<Document> createCollection(String collectionName) {
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        return this.doCreateCollection(collectionName, new Document());
    }

    @Override
    public MongoCollection<Document> createCollection(String collectionName, @Nullable CollectionOptions collectionOptions) {
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        return this.doCreateCollection(collectionName, this.convertToDocument(collectionOptions));
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        return this.execute(db -> db.getCollection(collectionName, Document.class));
    }

    @Override
    public <T> boolean collectionExists(Class<T> entityClass) {
        return this.collectionExists(this.getCollectionName(entityClass));
    }

    @Override
    public boolean collectionExists(String collectionName) {
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        return this.execute(db -> {
            for (String name : db.listCollectionNames()) {
                if (!name.equals(collectionName)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public <T> void dropCollection(Class<T> entityClass) {
        this.dropCollection(this.getCollectionName(entityClass));
    }

    @Override
    public void dropCollection(String collectionName) {
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        this.execute(collectionName, (MongoCollection<Document> collection) -> {
            collection.drop();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Dropped collection [{}]", (Object)(collection.getNamespace() != null ? collection.getNamespace().getCollectionName() : collectionName));
            }
            return null;
        });
    }

    @Override
    public IndexOperations indexOps(String collectionName) {
        return this.indexOps(collectionName, null);
    }

    @Override
    public IndexOperations indexOps(String collectionName, @Nullable Class<?> type) {
        return new DefaultIndexOperations(this, collectionName, type);
    }

    @Override
    public IndexOperations indexOps(Class<?> entityClass) {
        return this.indexOps(this.getCollectionName(entityClass), entityClass);
    }

    @Override
    public BulkOperations bulkOps(BulkOperations.BulkMode bulkMode, String collectionName) {
        return this.bulkOps(bulkMode, null, collectionName);
    }

    @Override
    public BulkOperations bulkOps(BulkOperations.BulkMode bulkMode, Class<?> entityClass) {
        return this.bulkOps(bulkMode, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public BulkOperations bulkOps(BulkOperations.BulkMode mode, @Nullable Class<?> entityType, String collectionName) {
        Assert.notNull((Object)mode, "BulkMode must not be null!");
        Assert.hasText(collectionName, "Collection name must not be null or empty!");
        DefaultBulkOperations operations = new DefaultBulkOperations(this, collectionName, new DefaultBulkOperations.BulkOperationContext(mode, Optional.ofNullable(this.getPersistentEntity(entityType)), this.queryMapper, this.updateMapper, this.eventPublisher, this.entityCallbacks));
        operations.setDefaultWriteConcern(this.writeConcern);
        return operations;
    }

    @Override
    public ScriptOperations scriptOps() {
        return new DefaultScriptOperations(this);
    }

    @Override
    @Nullable
    public <T> T findOne(Query query, Class<T> entityClass) {
        return this.findOne(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findOne(Query query, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.notNull(entityClass, "EntityClass must not be null!");
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        if (ObjectUtils.isEmpty(query.getSortObject())) {
            return this.doFindOne(collectionName, query.getQueryObject(), query.getFieldsObject(), new QueryCursorPreparer(query, entityClass), entityClass);
        }
        query.limit(1);
        List<T> results = this.find(query, entityClass, collectionName);
        return results.isEmpty() ? null : (T)results.get(0);
    }

    @Override
    public boolean exists(Query query, Class<?> entityClass) {
        return this.exists(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public boolean exists(Query query, String collectionName) {
        return this.exists(query, null, collectionName);
    }

    @Override
    public boolean exists(Query query, @Nullable Class<?> entityClass, String collectionName) {
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to exist can't be null");
        }
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(query);
        Document mappedQuery = queryContext.getMappedQuery(entityClass, this::getPersistentEntity);
        return this.execute(collectionName, new ExistsCallback(mappedQuery, queryContext.getCollation(entityClass).orElse(null)));
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass) {
        return this.find(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        Assert.notNull(entityClass, "EntityClass must not be null!");
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass, new QueryCursorPreparer(query, entityClass));
    }

    @Override
    @Nullable
    public <T> T findById(Object id, Class<T> entityClass) {
        return this.findById(id, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findById(Object id, Class<T> entityClass, String collectionName) {
        Assert.notNull(id, "Id must not be null!");
        Assert.notNull(entityClass, "EntityClass must not be null!");
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        String idKey = this.operations.getIdPropertyName(entityClass);
        return this.doFindOne(collectionName, new Document(idKey, id), new Document(), entityClass);
    }

    @Override
    public <T> List<T> findDistinct(Query query, String field, Class<?> entityClass, Class<T> resultClass) {
        return this.findDistinct(query, field, this.getCollectionName(entityClass), entityClass, resultClass);
    }

    @Override
    public <T> List<T> findDistinct(Query query, String field, String collectionName, Class<?> entityClass, Class<T> resultClass) {
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.notNull((Object)field, "Field must not be null!");
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        Assert.notNull(entityClass, "EntityClass must not be null!");
        Assert.notNull(resultClass, "ResultClass must not be null!");
        MongoPersistentEntity<?> entity = entityClass != Object.class ? this.getPersistentEntity(entityClass) : null;
        QueryOperations.DistinctQueryContext distinctQueryContext = this.queryOperations.distinctQueryContext(query, field);
        Document mappedQuery = distinctQueryContext.getMappedQuery(entity);
        String mappedFieldName = distinctQueryContext.getMappedFieldName(entity);
        Class mongoDriverCompatibleType = distinctQueryContext.getDriverCompatibleClass(resultClass);
        MongoIterable<Object> result = this.execute(collectionName, (MongoCollection<Document> collection) -> {
            QueryCursorPreparer preparer;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing findDistinct using query {} for field: {} in collection: {}", SerializationUtils.serializeToJsonSafely(mappedQuery), field, collectionName);
            }
            if ((preparer = new QueryCursorPreparer(query, entityClass)).hasReadPreference()) {
                collection = collection.withReadPreference(preparer.getReadPreference());
            }
            DistinctIterable iterable = collection.distinct(mappedFieldName, mappedQuery, mongoDriverCompatibleType);
            distinctQueryContext.applyCollation(entityClass, iterable::collation);
            return iterable;
        });
        if (resultClass == Object.class || mongoDriverCompatibleType != resultClass) {
            MongoConverter converter = this.getConverter();
            DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(this.mongoDbFactory);
            result = result.map(source -> converter.mapValueToTargetType(source, distinctQueryContext.getMostSpecificConversionTargetType(resultClass, entityClass), dbRefResolver));
        }
        try {
            return result.into(new ArrayList());
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Override
    public <T> GeoResults<T> geoNear(NearQuery near, Class<T> entityClass) {
        return this.geoNear(near, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public <T> GeoResults<T> geoNear(NearQuery near, Class<T> domainType, String collectionName) {
        return this.geoNear(near, domainType, collectionName, domainType);
    }

    public <T> GeoResults<T> geoNear(NearQuery near, Class<?> domainType, String collectionName, Class<T> returnType) {
        if (near == null) {
            throw new InvalidDataAccessApiUsageException("NearQuery must not be null!");
        }
        if (domainType == null) {
            throw new InvalidDataAccessApiUsageException("Entity class must not be null!");
        }
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        Assert.notNull(returnType, "ReturnType must not be null!");
        String collection = StringUtils.hasText(collectionName) ? collectionName : this.getCollectionName(domainType);
        String distanceField = this.operations.nearQueryDistanceFieldName(domainType);
        Aggregation $geoNear = TypedAggregation.newAggregation(domainType, Aggregation.geoNear(near, distanceField)).withOptions(AggregationOptions.builder().collation(near.getCollation()).build());
        AggregationResults<Document> results = this.aggregate($geoNear, collection, Document.class);
        GeoNearResultDocumentCallback callback = new GeoNearResultDocumentCallback(distanceField, new ProjectingReadCallback(this.mongoConverter, domainType, returnType, collection), near.getMetric());
        ArrayList<GeoResult> result = new ArrayList<GeoResult>();
        BigDecimal aggregate = BigDecimal.ZERO;
        for (Document element : results) {
            GeoResult geoResult = (GeoResult)callback.doWith(element);
            aggregate = aggregate.add(BigDecimal.valueOf(geoResult.getDistance().getValue()));
            result.add(geoResult);
        }
        Distance avgDistance = new Distance(result.size() == 0 ? 0.0 : aggregate.divide(new BigDecimal(result.size()), RoundingMode.HALF_UP).doubleValue(), near.getMetric());
        return new GeoResults(result, avgDistance);
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, UpdateDefinition update, Class<T> entityClass) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, this.getCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, UpdateDefinition update, Class<T> entityClass, String collectionName) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, collectionName);
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, UpdateDefinition update, FindAndModifyOptions options, Class<T> entityClass) {
        return this.findAndModify(query, update, options, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, UpdateDefinition update, FindAndModifyOptions options, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.notNull((Object)update, "Update must not be null!");
        Assert.notNull((Object)options, "Options must not be null!");
        Assert.notNull(entityClass, "EntityClass must not be null!");
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        FindAndModifyOptions optionsToUse = FindAndModifyOptions.of(options);
        Optionals.ifAllPresent(query.getCollation(), optionsToUse.getCollation(), (l, r) -> {
            throw new IllegalArgumentException("Both Query and FindAndModifyOptions define a collation. Please provide the collation only via one of the two.");
        });
        if (!options.getCollation().isPresent()) {
            this.operations.forType(entityClass).getCollation(query).ifPresent(optionsToUse::collation);
        }
        return this.doFindAndModify(collectionName, query.getQueryObject(), query.getFieldsObject(), this.getMappedSortObject(query, entityClass), entityClass, update, optionsToUse);
    }

    @Override
    public <S, T> T findAndReplace(Query query, S replacement, FindAndReplaceOptions options, Class<S> entityType, String collectionName, Class<T> resultType) {
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.notNull(replacement, "Replacement must not be null!");
        Assert.notNull((Object)options, "Options must not be null! Use FindAndReplaceOptions#empty() instead.");
        Assert.notNull(entityType, "EntityType must not be null!");
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        Assert.notNull(resultType, "ResultType must not be null! Use Object.class instead.");
        Assert.isTrue(query.getLimit() <= 1, "Query must not define a limit other than 1 ore none!");
        Assert.isTrue(query.getSkip() <= 0L, "Query must not define skip.");
        MongoPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)entityType));
        QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(query);
        Document mappedQuery = queryContext.getMappedQuery(entity);
        Document mappedFields = queryContext.getMappedFields(entity, resultType, this.projectionFactory);
        Document mappedSort = queryContext.getMappedSort(entity);
        replacement = this.maybeCallBeforeConvert(replacement, collectionName);
        Document mappedReplacement = this.operations.forEntity(replacement).toMappedDocument(this.mongoConverter).getDocument();
        this.maybeEmitEvent(new BeforeSaveEvent<S>(replacement, mappedReplacement, collectionName));
        this.maybeCallBeforeSave(replacement, mappedReplacement, collectionName);
        T saved = this.doFindAndReplace(collectionName, mappedQuery, mappedFields, mappedSort, queryContext.getCollation(entityType).orElse(null), entityType, mappedReplacement, options, resultType);
        if (saved != null) {
            this.maybeEmitEvent(new AfterSaveEvent<T>(saved, mappedReplacement, collectionName));
            return this.maybeCallAfterSave(saved, mappedReplacement, collectionName);
        }
        return saved;
    }

    @Override
    @Nullable
    public <T> T findAndRemove(Query query, Class<T> entityClass) {
        return this.findAndRemove(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findAndRemove(Query query, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.notNull(entityClass, "EntityClass must not be null!");
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        return this.doFindAndRemove(collectionName, query.getQueryObject(), query.getFieldsObject(), this.getMappedSortObject(query, entityClass), this.operations.forType(entityClass).getCollation(query).orElse(null), entityClass);
    }

    @Override
    public long count(Query query, Class<?> entityClass) {
        Assert.notNull(entityClass, "Entity class must not be null!");
        return this.count(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public long count(Query query, String collectionName) {
        return this.count(query, null, collectionName);
    }

    @Override
    public long count(Query query, @Nullable Class<?> entityClass, String collectionName) {
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.hasText(collectionName, "Collection name must not be null or empty!");
        QueryOperations.CountContext countContext = this.queryOperations.countQueryContext(query);
        CountOptions options = countContext.getCountOptions(entityClass);
        Document mappedQuery = countContext.getMappedQuery(entityClass, this.mappingContext::getPersistentEntity);
        return this.doCount(collectionName, mappedQuery, options);
    }

    protected long doCount(String collectionName, Document filter, CountOptions options) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing count: {} in collection: {}", (Object)SerializationUtils.serializeToJsonSafely(filter), (Object)collectionName);
        }
        return this.execute(collectionName, (MongoCollection<Document> collection) -> collection.countDocuments(CountQuery.of(filter).toQueryDocument(), options));
    }

    @Override
    public long estimatedCount(String collectionName) {
        return this.doEstimatedCount(collectionName, new EstimatedDocumentCountOptions());
    }

    protected long doEstimatedCount(String collectionName, EstimatedDocumentCountOptions options) {
        return this.execute(collectionName, (MongoCollection<Document> collection) -> collection.estimatedDocumentCount(options));
    }

    @Override
    public <T> T insert(T objectToSave) {
        Assert.notNull(objectToSave, "ObjectToSave must not be null!");
        this.ensureNotIterable(objectToSave);
        return this.insert(objectToSave, this.getCollectionName(ClassUtils.getUserClass(objectToSave)));
    }

    @Override
    public <T> T insert(T objectToSave, String collectionName) {
        Assert.notNull(objectToSave, "ObjectToSave must not be null!");
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        this.ensureNotIterable(objectToSave);
        return (T)this.doInsert(collectionName, objectToSave, this.mongoConverter);
    }

    protected void ensureNotIterable(@Nullable Object source) {
        this.ensureNotCollectionLike(source);
    }

    protected void ensureNotCollectionLike(@Nullable Object source) {
        if (EntityOperations.isCollectionLike(source)) {
            throw new IllegalArgumentException("Cannot use a collection here.");
        }
    }

    protected MongoCollection<Document> prepareCollection(MongoCollection<Document> collection) {
        if (this.readPreference != null) {
            collection = collection.withReadPreference(this.readPreference);
        }
        return collection;
    }

    @Nullable
    protected WriteConcern prepareWriteConcern(MongoAction mongoAction) {
        WriteConcern wc = this.writeConcernResolver.resolve(mongoAction);
        return this.potentiallyForceAcknowledgedWrite(wc);
    }

    @Nullable
    private WriteConcern potentiallyForceAcknowledgedWrite(@Nullable WriteConcern wc) {
        if (ObjectUtils.nullSafeEquals((Object)WriteResultChecking.EXCEPTION, (Object)this.writeResultChecking) && (wc == null || wc.getWObject() == null || wc.getWObject() instanceof Number && ((Number)wc.getWObject()).intValue() < 1)) {
            return WriteConcern.ACKNOWLEDGED;
        }
        return wc;
    }

    protected <T> T doInsert(String collectionName, T objectToSave, MongoWriter<T> writer) {
        BeforeConvertEvent<T> event = new BeforeConvertEvent<T>(objectToSave, collectionName);
        Object toConvert = this.maybeEmitEvent(event).getSource();
        toConvert = this.maybeCallBeforeConvert(toConvert, collectionName);
        EntityOperations.AdaptibleEntity<T> entity = this.operations.forEntity(toConvert, this.mongoConverter.getConversionService());
        entity.assertUpdateableIdIfNotSet();
        Object initialized = entity.initializeVersionProperty();
        Document dbDoc = entity.toMappedDocument(writer).getDocument();
        this.maybeEmitEvent(new BeforeSaveEvent(initialized, dbDoc, collectionName));
        initialized = this.maybeCallBeforeSave(initialized, dbDoc, collectionName);
        Object id = this.insertDocument(collectionName, dbDoc, initialized.getClass());
        Object saved = this.populateIdIfNecessary(initialized, id);
        this.maybeEmitEvent(new AfterSaveEvent(saved, dbDoc, collectionName));
        return this.maybeCallAfterSave(saved, dbDoc, collectionName);
    }

    @Override
    public <T> Collection<T> insert(Collection<? extends T> batchToSave, Class<?> entityClass) {
        Assert.notNull(batchToSave, "BatchToSave must not be null!");
        return this.doInsertBatch(this.getCollectionName(entityClass), batchToSave, this.mongoConverter);
    }

    @Override
    public <T> Collection<T> insert(Collection<? extends T> batchToSave, String collectionName) {
        Assert.notNull(batchToSave, "BatchToSave must not be null!");
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        return this.doInsertBatch(collectionName, batchToSave, this.mongoConverter);
    }

    @Override
    public <T> Collection<T> insertAll(Collection<? extends T> objectsToSave) {
        Assert.notNull(objectsToSave, "ObjectsToSave must not be null!");
        return this.doInsertAll(objectsToSave, this.mongoConverter);
    }

    protected <T> Collection<T> doInsertAll(Collection<? extends T> listToSave, MongoWriter<T> writer) {
        HashMap<String, ArrayList<T>> elementsByCollection = new HashMap<String, ArrayList<T>>();
        ArrayList<Object> savedObjects = new ArrayList<Object>(listToSave.size());
        for (T t2 : listToSave) {
            if (t2 == null) continue;
            String collection = this.getCollectionName(ClassUtils.getUserClass(t2));
            ArrayList<T> collectionElements = (ArrayList<T>)elementsByCollection.get(collection);
            if (null == collectionElements) {
                collectionElements = new ArrayList<T>();
                elementsByCollection.put(collection, collectionElements);
            }
            collectionElements.add(t2);
        }
        for (Map.Entry entry : elementsByCollection.entrySet()) {
            savedObjects.addAll(this.doInsertBatch((String)entry.getKey(), (Collection)entry.getValue(), this.mongoConverter));
        }
        return savedObjects;
    }

    protected <T> Collection<T> doInsertBatch(String collectionName, Collection<? extends T> batchToSave, MongoWriter<T> writer) {
        Assert.notNull(writer, "MongoWriter must not be null!");
        ArrayList<Document> documentList = new ArrayList<Document>();
        ArrayList initializedBatchToSave = new ArrayList(batchToSave.size());
        for (T uninitialized : batchToSave) {
            BeforeConvertEvent<T> event = new BeforeConvertEvent<T>(uninitialized, collectionName);
            Object toConvert = this.maybeEmitEvent(event).getSource();
            toConvert = this.maybeCallBeforeConvert(toConvert, collectionName);
            EntityOperations.AdaptibleEntity<T> entity = this.operations.forEntity(toConvert, this.mongoConverter.getConversionService());
            entity.assertUpdateableIdIfNotSet();
            Object initialized = entity.initializeVersionProperty();
            Document document = entity.toMappedDocument(writer).getDocument();
            this.maybeEmitEvent(new BeforeSaveEvent(initialized, document, collectionName));
            initialized = this.maybeCallBeforeSave(initialized, document, collectionName);
            documentList.add(document);
            initializedBatchToSave.add(initialized);
        }
        List<Object> ids = this.insertDocumentList(collectionName, documentList);
        ArrayList savedObjects = new ArrayList(documentList.size());
        int i = 0;
        for (Object obj : initializedBatchToSave) {
            if (i < ids.size()) {
                Object saved = this.populateIdIfNecessary(obj, ids.get(i));
                Document doc = (Document)documentList.get(i);
                this.maybeEmitEvent(new AfterSaveEvent(saved, doc, collectionName));
                savedObjects.add(this.maybeCallAfterSave(saved, doc, collectionName));
            } else {
                savedObjects.add(obj);
            }
            ++i;
        }
        return savedObjects;
    }

    @Override
    public <T> T save(T objectToSave) {
        Assert.notNull(objectToSave, "Object to save must not be null!");
        return this.save(objectToSave, this.getCollectionName(ClassUtils.getUserClass(objectToSave)));
    }

    @Override
    public <T> T save(T objectToSave, String collectionName) {
        Assert.notNull(objectToSave, "Object to save must not be null!");
        Assert.hasText(collectionName, "Collection name must not be null or empty!");
        this.ensureNotCollectionLike(objectToSave);
        EntityOperations.AdaptibleEntity<T> source = this.operations.forEntity(objectToSave, this.mongoConverter.getConversionService());
        return (T)(source.isVersionedEntity() ? this.doSaveVersioned(source, collectionName) : this.doSave(collectionName, objectToSave, this.mongoConverter));
    }

    private <T> T doSaveVersioned(EntityOperations.AdaptibleEntity<T> source, String collectionName) {
        if (source.isNew()) {
            return (T)this.doInsert(collectionName, source.getBean(), this.mongoConverter);
        }
        Query query = source.getQueryForVersion();
        T toSave = source.incrementVersion();
        toSave = this.maybeEmitEvent(new BeforeConvertEvent<T>(toSave, collectionName)).getSource();
        toSave = this.maybeCallBeforeConvert(toSave, collectionName);
        if (source.getBean() != toSave) {
            source = this.operations.forEntity(toSave, this.mongoConverter.getConversionService());
        }
        source.assertUpdateableIdIfNotSet();
        MappedDocument mapped = source.toMappedDocument(this.mongoConverter);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(toSave, mapped.getDocument(), collectionName));
        toSave = this.maybeCallBeforeSave(toSave, mapped.getDocument(), collectionName);
        UpdateDefinition update = mapped.updateWithoutId();
        UpdateResult result = this.doUpdate(collectionName, query, update, toSave.getClass(), false, false);
        if (result.getModifiedCount() == 0L) {
            throw new OptimisticLockingFailureException(String.format("Cannot save entity %s with version %s to collection %s. Has it been modified meanwhile?", source.getId(), source.getVersion(), collectionName));
        }
        this.maybeEmitEvent(new AfterSaveEvent<T>(toSave, mapped.getDocument(), collectionName));
        return this.maybeCallAfterSave(toSave, mapped.getDocument(), collectionName);
    }

    protected <T> T doSave(String collectionName, T objectToSave, MongoWriter<T> writer) {
        objectToSave = this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave, collectionName)).getSource();
        objectToSave = this.maybeCallBeforeConvert(objectToSave, collectionName);
        EntityOperations.AdaptibleEntity<T> entity = this.operations.forEntity(objectToSave, this.mongoConverter.getConversionService());
        entity.assertUpdateableIdIfNotSet();
        MappedDocument mapped = entity.toMappedDocument(writer);
        Document dbDoc = mapped.getDocument();
        this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, dbDoc, collectionName));
        objectToSave = this.maybeCallBeforeSave(objectToSave, dbDoc, collectionName);
        Object id = this.saveDocument(collectionName, dbDoc, objectToSave.getClass());
        T saved = this.populateIdIfNecessary(objectToSave, id);
        this.maybeEmitEvent(new AfterSaveEvent<T>(saved, dbDoc, collectionName));
        return this.maybeCallAfterSave(saved, dbDoc, collectionName);
    }

    protected Object insertDocument(String collectionName, Document document, Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inserting Document containing fields: {} in collection: {}", (Object)document.keySet(), (Object)collectionName);
        }
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.INSERT, collectionName, entityClass, document, null);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            if (writeConcernToUse == null) {
                collection.insertOne(document);
            } else {
                collection.withWriteConcern(writeConcernToUse).insertOne(document);
            }
            return this.operations.forEntity(document).getId();
        });
    }

    protected List<Object> insertDocumentList(String collectionName, List<Document> documents) {
        if (documents.isEmpty()) {
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inserting list of Documents containing {} items", (Object)documents.size());
        }
        this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.INSERT_LIST, collectionName, null, null, null);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            if (writeConcernToUse == null) {
                collection.insertMany(documents);
            } else {
                collection.withWriteConcern(writeConcernToUse).insertMany(documents);
            }
            return null;
        });
        return MappedDocument.toIds(documents);
    }

    protected Object saveDocument(String collectionName, Document dbDoc, Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Saving Document containing fields: {}", (Object)dbDoc.keySet());
        }
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoCollection<Document> collectionToUse;
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.SAVE, collectionName, entityClass, dbDoc, null);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            MappedDocument mapped = MappedDocument.of(dbDoc);
            MongoCollection<Document> mongoCollection = collectionToUse = writeConcernToUse == null ? collection : collection.withWriteConcern(writeConcernToUse);
            if (!mapped.hasId()) {
                collectionToUse.insertOne(dbDoc);
            } else {
                MongoPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)entityClass));
                QueryOperations.UpdateContext updateContext = this.queryOperations.replaceSingleContext(mapped, true);
                Document replacement = updateContext.getMappedUpdate(entity);
                Document filter = updateContext.getMappedQuery(entity);
                if (updateContext.requiresShardKey(filter, entity)) {
                    filter = entity.getShardKey().isImmutable() ? updateContext.applyShardKey(entity, filter, null) : updateContext.applyShardKey(entity, filter, (Document)collection.find(filter, Document.class).projection(updateContext.getMappedShardKey(entity)).first());
                }
                collectionToUse.replaceOne(filter, replacement, new ReplaceOptions().upsert(true));
            }
            return mapped.getId();
        });
    }

    @Override
    public UpdateResult upsert(Query query, UpdateDefinition update, Class<?> entityClass) {
        return this.doUpdate(this.getCollectionName(entityClass), query, update, entityClass, true, false);
    }

    @Override
    public UpdateResult upsert(Query query, UpdateDefinition update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, true, false);
    }

    @Override
    public UpdateResult upsert(Query query, UpdateDefinition update, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, "EntityClass must not be null!");
        return this.doUpdate(collectionName, query, update, entityClass, true, false);
    }

    @Override
    public UpdateResult updateFirst(Query query, UpdateDefinition update, Class<?> entityClass) {
        return this.doUpdate(this.getCollectionName(entityClass), query, update, entityClass, false, false);
    }

    @Override
    public UpdateResult updateFirst(Query query, UpdateDefinition update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, false);
    }

    @Override
    public UpdateResult updateFirst(Query query, UpdateDefinition update, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, "EntityClass must not be null!");
        return this.doUpdate(collectionName, query, update, entityClass, false, false);
    }

    @Override
    public UpdateResult updateMulti(Query query, UpdateDefinition update, Class<?> entityClass) {
        return this.doUpdate(this.getCollectionName(entityClass), query, update, entityClass, false, true);
    }

    @Override
    public UpdateResult updateMulti(Query query, UpdateDefinition update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, true);
    }

    @Override
    public UpdateResult updateMulti(Query query, UpdateDefinition update, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, "EntityClass must not be null!");
        return this.doUpdate(collectionName, query, update, entityClass, false, true);
    }

    protected UpdateResult doUpdate(String collectionName, Query query, UpdateDefinition update, @Nullable Class<?> entityClass, boolean upsert, boolean multi) {
        Assert.notNull((Object)collectionName, "CollectionName must not be null!");
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.notNull((Object)update, "Update must not be null!");
        if (query.isSorted() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("{} does not support sort ('{}'). Please use findAndModify() instead.", (Object)(upsert ? "Upsert" : "UpdateFirst"), (Object)SerializationUtils.serializeToJsonSafely(query.getSortObject()));
        }
        MongoPersistentEntity<?> entity = entityClass == null ? null : this.getPersistentEntity(entityClass);
        QueryOperations.UpdateContext updateContext = multi ? this.queryOperations.updateContext(update, query, upsert) : this.queryOperations.updateSingleContext(update, query, upsert);
        updateContext.increaseVersionForUpdateIfNecessary(entity);
        Document queryObj = updateContext.getMappedQuery(entity);
        UpdateOptions opts = updateContext.getUpdateOptions(entityClass);
        if (updateContext.isAggregationUpdate()) {
            List<Document> pipeline = updateContext.getUpdatePipeline(entityClass);
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.UPDATE, collectionName, entityClass, update.getUpdateObject(), queryObj);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            return this.execute(collectionName, (MongoCollection<Document> collection) -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Calling update using query: {} and update: {} in collection: {}", SerializationUtils.serializeToJsonSafely(queryObj), SerializationUtils.serializeToJsonSafely(pipeline), collectionName);
                }
                collection = writeConcernToUse != null ? collection.withWriteConcern(writeConcernToUse) : collection;
                return multi ? collection.updateMany((Bson)queryObj, pipeline, opts) : collection.updateOne((Bson)queryObj, pipeline, opts);
            });
        }
        Document updateObj = updateContext.getMappedUpdate(entity);
        MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.UPDATE, collectionName, entityClass, updateObj, queryObj);
        WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling update using query: {} and update: {} in collection: {}", SerializationUtils.serializeToJsonSafely(queryObj), SerializationUtils.serializeToJsonSafely(updateObj), collectionName);
            }
            MongoCollection<Document> mongoCollection = collection = writeConcernToUse != null ? collection.withWriteConcern(writeConcernToUse) : collection;
            if (!UpdateMapper.isUpdateObject(updateObj)) {
                Document filter = new Document(queryObj);
                if (updateContext.requiresShardKey(filter, entity)) {
                    filter = entity.getShardKey().isImmutable() ? updateContext.applyShardKey(entity, filter, null) : updateContext.applyShardKey(entity, filter, (Document)collection.find(filter, Document.class).projection(updateContext.getMappedShardKey(entity)).first());
                }
                ReplaceOptions replaceOptions = updateContext.getReplaceOptions(entityClass);
                return collection.replaceOne(filter, updateObj, replaceOptions);
            }
            return multi ? collection.updateMany((Bson)queryObj, (Bson)updateObj, opts) : collection.updateOne((Bson)queryObj, (Bson)updateObj, opts);
        });
    }

    @Override
    public DeleteResult remove(Object object) {
        Assert.notNull(object, "Object must not be null!");
        return this.remove(object, this.getCollectionName(object.getClass()));
    }

    @Override
    public DeleteResult remove(Object object, String collectionName) {
        Assert.notNull(object, "Object must not be null!");
        Assert.hasText(collectionName, "Collection name must not be null or empty!");
        Query query = this.operations.forEntity(object).getRemoveByQuery();
        return this.doRemove(collectionName, query, object.getClass(), false);
    }

    @Override
    public DeleteResult remove(Query query, String collectionName) {
        return this.doRemove(collectionName, query, null, true);
    }

    @Override
    public DeleteResult remove(Query query, Class<?> entityClass) {
        return this.remove(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public DeleteResult remove(Query query, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, "EntityClass must not be null!");
        return this.doRemove(collectionName, query, entityClass, true);
    }

    protected <T> DeleteResult doRemove(String collectionName, Query query, @Nullable Class<T> entityClass, boolean multi) {
        Assert.notNull((Object)query, "Query must not be null!");
        Assert.hasText(collectionName, "Collection name must not be null or empty!");
        MongoPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        QueryOperations.DeleteContext deleteContext = multi ? this.queryOperations.deleteQueryContext(query) : this.queryOperations.deleteSingleContext(query);
        Document queryObject = deleteContext.getMappedQuery(entity);
        DeleteOptions options = deleteContext.getDeleteOptions(entityClass);
        MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.REMOVE, collectionName, entityClass, null, queryObject);
        WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            this.maybeEmitEvent(new BeforeDeleteEvent(queryObject, entityClass, collectionName));
            Document removeQuery = queryObject;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Remove using query: {} in collection: {}.", new Object[]{SerializationUtils.serializeToJsonSafely(removeQuery), collectionName});
            }
            if (query.getLimit() > 0 || query.getSkip() > 0L) {
                Iterator cursor = new QueryCursorPreparer(query, entityClass).prepare(collection.find(removeQuery).projection(MappedDocument.getIdOnlyProjection())).iterator();
                LinkedHashSet<Object> ids = new LinkedHashSet<Object>();
                while (cursor.hasNext()) {
                    ids.add(MappedDocument.of((Document)cursor.next()).getId());
                }
                removeQuery = MappedDocument.getIdIn(ids);
            }
            MongoCollection collectionToUse = writeConcernToUse != null ? collection.withWriteConcern(writeConcernToUse) : collection;
            DeleteResult result = multi ? collectionToUse.deleteMany(removeQuery, options) : collectionToUse.deleteOne(removeQuery, options);
            this.maybeEmitEvent(new AfterDeleteEvent(queryObject, entityClass, collectionName));
            return result;
        });
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        return this.findAll(entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass, String collectionName) {
        return this.executeFindMultiInternal(new FindCallback(new Document(), new Document(), this.operations.forType(entityClass).getCollation().map(Collation::toMongoCollation).orElse(null)), CursorPreparer.NO_OP_PREPARER, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return this.mapReduce(new Query(), inputCollectionName, mapFunction, reduceFunction, new MapReduceOptions().outputTypeInline(), entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, @Nullable MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        return this.mapReduce(new Query(), inputCollectionName, mapFunction, reduceFunction, mapReduceOptions, entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return this.mapReduce(query, inputCollectionName, mapFunction, reduceFunction, new MapReduceOptions().outputTypeInline(), entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, @Nullable MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        return new MapReduceResults<T>(this.mapReduce(query, entityClass, inputCollectionName, mapFunction, reduceFunction, mapReduceOptions, entityClass), new Document());
    }

    public <T> List<T> mapReduce(Query query, Class<?> domainType, String inputCollectionName, String mapFunction, String reduceFunction, @Nullable MapReduceOptions mapReduceOptions, Class<T> resultType) {
        Document mappedSort;
        Assert.notNull(domainType, "Domain type must not be null!");
        Assert.notNull((Object)inputCollectionName, "Input collection name must not be null!");
        Assert.notNull(resultType, "Result type must not be null!");
        Assert.notNull((Object)mapFunction, "Map function must not be null!");
        Assert.notNull((Object)reduceFunction, "Reduce function must not be null!");
        String mapFunc = this.replaceWithResourceIfNecessary(mapFunction);
        String reduceFunc = this.replaceWithResourceIfNecessary(reduceFunction);
        MongoCollection<Document> inputCollection = this.getAndPrepareCollection(this.doGetDatabase(), inputCollectionName);
        MapReduceIterable<Document> mapReduce = inputCollection.mapReduce(mapFunc, reduceFunc, Document.class);
        if (query.getLimit() > 0 && mapReduceOptions != null && mapReduceOptions.getLimit() == null) {
            mapReduce = mapReduce.limit(query.getLimit());
        }
        if (query.getMeta().getMaxTimeMsec() != null) {
            mapReduce = mapReduce.maxTime(query.getMeta().getMaxTimeMsec(), TimeUnit.MILLISECONDS);
        }
        if ((mappedSort = this.getMappedSortObject(query, domainType)) != null && !mappedSort.isEmpty()) {
            mapReduce = mapReduce.sort(this.getMappedSortObject(query, domainType));
        }
        mapReduce = mapReduce.filter(this.queryMapper.getMappedObject((Bson)query.getQueryObject(), this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)domainType))));
        Optional<Collation> collation = query.getCollation();
        if (mapReduceOptions != null) {
            Optionals.ifAllPresent(collation, mapReduceOptions.getCollation(), (l, r) -> {
                throw new IllegalArgumentException("Both Query and MapReduceOptions define a collation. Please provide the collation only via one of the two.");
            });
            if (mapReduceOptions.getCollation().isPresent()) {
                collation = mapReduceOptions.getCollation();
            }
            if (!CollectionUtils.isEmpty(mapReduceOptions.getScopeVariables())) {
                mapReduce = mapReduce.scope(new Document(mapReduceOptions.getScopeVariables()));
            }
            if (mapReduceOptions.getLimit() != null && mapReduceOptions.getLimit() > 0) {
                mapReduce = mapReduce.limit(mapReduceOptions.getLimit());
            }
            if (mapReduceOptions.getFinalizeFunction().filter(StringUtils::hasText).isPresent()) {
                mapReduce = mapReduce.finalizeFunction(mapReduceOptions.getFinalizeFunction().get());
            }
            if (mapReduceOptions.getJavaScriptMode() != null) {
                mapReduce = mapReduce.jsMode(mapReduceOptions.getJavaScriptMode());
            }
            if (mapReduceOptions.getOutputSharded().isPresent()) {
                mapReduce = mapReduce.sharded(mapReduceOptions.getOutputSharded().get());
            }
            if (StringUtils.hasText(mapReduceOptions.getOutputCollection()) && !mapReduceOptions.usesInlineOutput()) {
                mapReduce = mapReduce.collectionName(mapReduceOptions.getOutputCollection()).action(mapReduceOptions.getMapReduceAction());
                if (mapReduceOptions.getOutputDatabase().isPresent()) {
                    mapReduce = mapReduce.databaseName(mapReduceOptions.getOutputDatabase().get());
                }
            }
        }
        if (!collation.isPresent()) {
            collation = this.operations.forType(domainType).getCollation();
        }
        mapReduce = collation.map(Collation::toMongoCollation).map(mapReduce::collation).orElse(mapReduce);
        ArrayList mappedResults = new ArrayList();
        ReadDocumentCallback<Object> callback = new ReadDocumentCallback<Object>(this.mongoConverter, resultType, inputCollectionName);
        for (Document document : mapReduce) {
            mappedResults.add(callback.doWith(document));
        }
        return mappedResults;
    }

    @Override
    public <T> GroupByResults<T> group(String inputCollectionName, GroupBy groupBy, Class<T> entityClass) {
        return this.group(null, inputCollectionName, groupBy, entityClass);
    }

    @Override
    public <T> GroupByResults<T> group(@Nullable Criteria criteria, String inputCollectionName, GroupBy groupBy, Class<T> entityClass) {
        Object initialObj;
        Document document = groupBy.getGroupByObject();
        document.put("ns", (Object)inputCollectionName);
        if (criteria == null) {
            document.put("cond", (Object)null);
        } else {
            document.put("cond", (Object)this.queryMapper.getMappedObject((Bson)criteria.getCriteriaObject(), Optional.empty()));
        }
        if (document.containsKey("initial") && (initialObj = document.get("initial")) instanceof String) {
            String initialAsString = this.replaceWithResourceIfNecessary((String)initialObj);
            document.put("initial", (Object)Document.parse(initialAsString));
        }
        if (document.containsKey("$reduce")) {
            document.put("$reduce", (Object)this.replaceWithResourceIfNecessary(ObjectUtils.nullSafeToString(document.get("$reduce"))));
        }
        if (document.containsKey("$keyf")) {
            document.put("$keyf", (Object)this.replaceWithResourceIfNecessary(ObjectUtils.nullSafeToString(document.get("$keyf"))));
        }
        if (document.containsKey("finalize")) {
            document.put("finalize", (Object)this.replaceWithResourceIfNecessary(ObjectUtils.nullSafeToString(document.get("finalize"))));
        }
        Document commandObject = new Document("group", document);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing Group with Document [{}]", (Object)SerializationUtils.serializeToJsonSafely(commandObject));
        }
        Document commandResult = this.executeCommand(commandObject, this.readPreference);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Group command result = [{}]", (Object)commandResult);
        }
        Iterable resultSet = (Iterable)commandResult.get("retval");
        ArrayList mappedResults = new ArrayList();
        ReadDocumentCallback<Object> callback = new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, inputCollectionName);
        for (Document resultDocument : resultSet) {
            mappedResults.add(callback.doWith(resultDocument));
        }
        return new GroupByResults(mappedResults, commandResult);
    }

    @Override
    public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, Class<O> outputType) {
        return this.aggregate(aggregation, this.getCollectionName(aggregation.getInputType()), outputType);
    }

    @Override
    public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, String inputCollectionName, Class<O> outputType) {
        Assert.notNull(aggregation, "Aggregation pipeline must not be null!");
        return this.aggregate(aggregation, inputCollectionName, outputType, null);
    }

    @Override
    public <O> AggregationResults<O> aggregate(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        return this.aggregate(aggregation, this.getCollectionName(inputType), outputType, this.queryOperations.createAggregation(aggregation, inputType).getAggregationOperationContext());
    }

    @Override
    public <O> AggregationResults<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType) {
        return this.aggregate(aggregation, collectionName, outputType, null);
    }

    @Override
    public <O> CloseableIterator<O> aggregateStream(TypedAggregation<?> aggregation, String inputCollectionName, Class<O> outputType) {
        Assert.notNull(aggregation, "Aggregation pipeline must not be null!");
        TypeBasedAggregationOperationContext context = new TypeBasedAggregationOperationContext(aggregation.getInputType(), this.mappingContext, this.queryMapper);
        return this.aggregateStream(aggregation, inputCollectionName, outputType, context);
    }

    @Override
    public <O> CloseableIterator<O> aggregateStream(TypedAggregation<?> aggregation, Class<O> outputType) {
        return this.aggregateStream(aggregation, this.getCollectionName(aggregation.getInputType()), outputType);
    }

    @Override
    public <O> CloseableIterator<O> aggregateStream(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        return this.aggregateStream(aggregation, this.getCollectionName(inputType), outputType, new TypeBasedAggregationOperationContext(inputType, this.mappingContext, this.queryMapper));
    }

    @Override
    public <O> CloseableIterator<O> aggregateStream(Aggregation aggregation, String collectionName, Class<O> outputType) {
        return this.aggregateStream(aggregation, collectionName, outputType, null);
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, String collectionName) {
        return this.findAllAndRemove(query, Object.class, collectionName);
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, Class<T> entityClass) {
        return this.findAllAndRemove(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return this.doFindAndDelete(collectionName, query, entityClass);
    }

    protected <T> List<T> doFindAndDelete(String collectionName, Query query, Class<T> entityClass) {
        List<T> result = this.find(query, entityClass, collectionName);
        if (!CollectionUtils.isEmpty(result)) {
            Query byIdInQuery = this.operations.getByIdInQuery(result);
            this.remove(byIdInQuery, entityClass, collectionName);
        }
        return result;
    }

    protected <O> AggregationResults<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType, @Nullable AggregationOperationContext context) {
        Assert.hasText(collectionName, "Collection name must not be null or empty!");
        Assert.notNull((Object)aggregation, "Aggregation pipeline must not be null!");
        Assert.notNull(outputType, "Output type must not be null!");
        return this.doAggregate(aggregation, collectionName, outputType, this.queryOperations.createAggregation(aggregation, context));
    }

    private <O> AggregationResults<O> doAggregate(Aggregation aggregation, String collectionName, Class<O> outputType, QueryOperations.AggregationDefinition context) {
        return this.doAggregate(aggregation, collectionName, outputType, context.getAggregationOperationContext());
    }

    protected <O> AggregationResults<O> doAggregate(Aggregation aggregation, String collectionName, Class<O> outputType, AggregationOperationContext context) {
        ReadDocumentCallback<Object> callback = new ReadDocumentCallback<Object>(this.mongoConverter, outputType, collectionName);
        AggregationOptions options = aggregation.getOptions();
        AggregationUtil aggregationUtil = new AggregationUtil(this.queryMapper, this.mappingContext);
        if (options.isExplain()) {
            Document command = aggregationUtil.createCommand(collectionName, aggregation, context);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing aggregation: {}", (Object)SerializationUtils.serializeToJsonSafely(command));
            }
            Document commandResult = this.executeCommand(command);
            return new AggregationResults(commandResult.get((Object)"results", new ArrayList(0)).stream().map(callback::doWith).collect(Collectors.toList()), commandResult);
        }
        List<Document> pipeline = aggregationUtil.createPipeline(aggregation, context);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing aggregation: {} in collection {}", (Object)SerializationUtils.serializeToJsonSafely(pipeline), (Object)collectionName);
        }
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            ArrayList rawResult = new ArrayList();
            Class domainType = aggregation instanceof TypedAggregation ? ((TypedAggregation)aggregation).getInputType() : null;
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = options::getCollation;
            supplierArray[1] = () -> this.operations.forType(domainType).getCollation();
            Optional<Collation> collation = Optionals.firstNonEmpty(supplierArray);
            MongoIterable<Document> aggregateIterable = collection.aggregate(pipeline, Document.class).collation(collation.map(Collation::toMongoCollation).orElse(null)).allowDiskUse(options.isAllowDiskUse());
            if (options.getCursorBatchSize() != null) {
                aggregateIterable = aggregateIterable.batchSize(options.getCursorBatchSize());
            }
            options.getComment().ifPresent(arg_0 -> aggregateIterable.comment(arg_0));
            options.getHint().ifPresent(arg_0 -> aggregateIterable.hint(arg_0));
            if (options.hasExecutionTimeLimit()) {
                aggregateIterable = aggregateIterable.maxTime(options.getMaxTime().toMillis(), TimeUnit.MILLISECONDS);
            }
            if (options.isSkipResults()) {
                if (aggregation.getPipeline().isOutOrMerge()) {
                    aggregateIterable.toCollection();
                } else {
                    aggregateIterable.first();
                }
                return new AggregationResults(Collections.emptyList(), new Document());
            }
            MongoIterable<Object> iterable = aggregateIterable.map(val -> {
                rawResult.add(val);
                return callback.doWith((Document)val);
            });
            return new AggregationResults(iterable.into(new ArrayList()), new Document("results", rawResult).append("ok", 1.0));
        });
    }

    protected <O> CloseableIterator<O> aggregateStream(Aggregation aggregation, String collectionName, Class<O> outputType, @Nullable AggregationOperationContext context) {
        Assert.hasText(collectionName, "Collection name must not be null or empty!");
        Assert.notNull((Object)aggregation, "Aggregation pipeline must not be null!");
        Assert.notNull(outputType, "Output type must not be null!");
        Assert.isTrue(!aggregation.getOptions().isExplain(), "Can't use explain option with streaming!");
        QueryOperations.AggregationDefinition aggregationDefinition = this.queryOperations.createAggregation(aggregation, context);
        AggregationOptions options = aggregation.getOptions();
        List<Document> pipeline = aggregationDefinition.getAggregationPipeline();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Streaming aggregation: {} in collection {}", (Object)SerializationUtils.serializeToJsonSafely(pipeline), (Object)collectionName);
        }
        ReadDocumentCallback<Object> readCallback = new ReadDocumentCallback<Object>(this.mongoConverter, outputType, collectionName);
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoIterable<Document> cursor = collection.aggregate(pipeline, Document.class).allowDiskUse(options.isAllowDiskUse());
            if (options.getCursorBatchSize() != null) {
                cursor = cursor.batchSize(options.getCursorBatchSize());
            }
            options.getComment().ifPresent(arg_0 -> cursor.comment(arg_0));
            options.getHint().ifPresent(arg_0 -> cursor.hint(arg_0));
            Class domainType = aggregation instanceof TypedAggregation ? ((TypedAggregation)aggregation).getInputType() : null;
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = options::getCollation;
            supplierArray[1] = () -> this.operations.forType(domainType).getCollation();
            Optionals.firstNonEmpty(supplierArray).map(Collation::toMongoCollation).ifPresent(arg_0 -> cursor.collation(arg_0));
            return new CloseableIterableCursorAdapter(cursor, this.exceptionTranslator, readCallback);
        });
    }

    @Override
    public <T> ExecutableFindOperation.ExecutableFind<T> query(Class<T> domainType) {
        return new ExecutableFindOperationSupport(this).query(domainType);
    }

    @Override
    public <T> ExecutableUpdateOperation.ExecutableUpdate<T> update(Class<T> domainType) {
        return new ExecutableUpdateOperationSupport(this).update(domainType);
    }

    @Override
    public <T> ExecutableRemoveOperation.ExecutableRemove<T> remove(Class<T> domainType) {
        return new ExecutableRemoveOperationSupport(this).remove(domainType);
    }

    @Override
    public <T> ExecutableAggregationOperation.ExecutableAggregation<T> aggregateAndReturn(Class<T> domainType) {
        return new ExecutableAggregationOperationSupport(this).aggregateAndReturn(domainType);
    }

    public <T> ExecutableMapReduceOperation.ExecutableMapReduce<T> mapReduce(Class<T> domainType) {
        return new ExecutableMapReduceOperationSupport(this).mapReduce((Class)domainType);
    }

    @Override
    public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        return new ExecutableInsertOperationSupport(this).insert(domainType);
    }

    protected String replaceWithResourceIfNecessary(String function) {
        String func = function;
        if (this.resourceLoader != null && ResourceUtils.isUrl(function)) {
            Resource functionResource = this.resourceLoader.getResource(func);
            if (!functionResource.exists()) {
                throw new InvalidDataAccessApiUsageException(String.format("Resource %s not found!", function));
            }
            try (Scanner scanner = null;){
                scanner = new Scanner(functionResource.getInputStream());
                String string = scanner.useDelimiter("\\A").next();
                return string;
            }
        }
        return func;
    }

    @Override
    public Set<String> getCollectionNames() {
        return this.execute(db -> {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String name : db.listCollectionNames()) {
                result.add(name);
            }
            return result;
        });
    }

    public MongoDatabase getDb() {
        return this.doGetDatabase();
    }

    protected MongoDatabase doGetDatabase() {
        return MongoDatabaseUtils.getDatabase(this.mongoDbFactory, this.sessionSynchronization);
    }

    protected MongoDatabase prepareDatabase(MongoDatabase database) {
        return database;
    }

    protected <E extends MongoMappingEvent<T>, T> E maybeEmitEvent(E event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
        return event;
    }

    protected <T> T maybeCallBeforeConvert(T object, String collection) {
        if (this.entityCallbacks != null) {
            return this.entityCallbacks.callback(BeforeConvertCallback.class, object, collection);
        }
        return object;
    }

    protected <T> T maybeCallBeforeSave(T object, Document document, String collection) {
        if (this.entityCallbacks != null) {
            return this.entityCallbacks.callback(BeforeSaveCallback.class, object, document, collection);
        }
        return object;
    }

    protected <T> T maybeCallAfterSave(T object, Document document, String collection) {
        if (this.entityCallbacks != null) {
            return this.entityCallbacks.callback(AfterSaveCallback.class, object, document, collection);
        }
        return object;
    }

    protected <T> T maybeCallAfterConvert(T object, Document document, String collection) {
        if (this.entityCallbacks != null) {
            return this.entityCallbacks.callback(AfterConvertCallback.class, object, document, collection);
        }
        return object;
    }

    protected MongoCollection<Document> doCreateCollection(String collectionName, Document collectionOptions) {
        return this.execute(db -> {
            CreateCollectionOptions co = new CreateCollectionOptions();
            if (collectionOptions.containsKey("capped")) {
                co.capped((Boolean)collectionOptions.get("capped"));
            }
            if (collectionOptions.containsKey("size")) {
                co.sizeInBytes(((Number)collectionOptions.get("size")).longValue());
            }
            if (collectionOptions.containsKey("max")) {
                co.maxDocuments(((Number)collectionOptions.get("max")).longValue());
            }
            if (collectionOptions.containsKey("collation")) {
                co.collation(IndexConverters.fromDocument((Document)((Object)collectionOptions.get((Object)"collation", Document.class))));
            }
            if (collectionOptions.containsKey("validator")) {
                ValidationOptions options = new ValidationOptions();
                if (collectionOptions.containsKey("validationLevel")) {
                    options.validationLevel(ValidationLevel.fromString(collectionOptions.getString("validationLevel")));
                }
                if (collectionOptions.containsKey("validationAction")) {
                    options.validationAction(ValidationAction.fromString(collectionOptions.getString("validationAction")));
                }
                options.validator((Bson)((Object)collectionOptions.get((Object)"validator", Document.class)));
                co.validationOptions(options);
            }
            if (collectionOptions.containsKey("timeseries")) {
                Document timeSeries = (Document)((Object)collectionOptions.get((Object)"timeseries", Document.class));
                TimeSeriesOptions options = new TimeSeriesOptions(timeSeries.getString("timeField"));
                if (timeSeries.containsKey("metaField")) {
                    options.metaField(timeSeries.getString("metaField"));
                }
                if (timeSeries.containsKey("granularity")) {
                    options.granularity(TimeSeriesGranularity.valueOf(timeSeries.getString("granularity").toUpperCase()));
                }
                co.timeSeriesOptions(options);
            }
            db.createCollection(collectionName, co);
            MongoCollection<Document> coll = db.getCollection(collectionName, Document.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created collection [{}]", (Object)(coll.getNamespace() != null ? coll.getNamespace().getCollectionName() : collectionName));
            }
            return coll;
        });
    }

    protected <T> T doFindOne(String collectionName, Document query, Document fields, Class<T> entityClass) {
        return this.doFindOne(collectionName, query, fields, CursorPreparer.NO_OP_PREPARER, entityClass);
    }

    protected <T> T doFindOne(String collectionName, Document query, Document fields, CursorPreparer preparer, Class<T> entityClass) {
        MongoPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)entityClass));
        QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(new BasicQuery(query, fields));
        Document mappedFields = queryContext.getMappedFields(entity, entityClass, this.projectionFactory);
        Document mappedQuery = queryContext.getMappedQuery(entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("findOne using query: {} fields: {} for class: {} in collection: {}", SerializationUtils.serializeToJsonSafely(query), mappedFields, entityClass, collectionName);
        }
        return (T)this.executeFindOneInternal(new FindOneCallback(mappedQuery, mappedFields, preparer), new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    protected <T> List<T> doFind(String collectionName, Document query, Document fields, Class<T> entityClass) {
        return this.doFind(collectionName, query, fields, entityClass, null, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName));
    }

    protected <T> List<T> doFind(String collectionName, Document query, Document fields, Class<T> entityClass, CursorPreparer preparer) {
        return this.doFind(collectionName, query, fields, entityClass, preparer, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName));
    }

    protected <S, T> List<T> doFind(String collectionName, Document query, Document fields, Class<S> entityClass, @Nullable CursorPreparer preparer, DocumentCallback<T> objectCallback) {
        MongoPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)entityClass));
        QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(new BasicQuery(query, fields));
        Document mappedFields = queryContext.getMappedFields(entity, entityClass, this.projectionFactory);
        Document mappedQuery = queryContext.getMappedQuery(entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("find using query: {} fields: {} for class: {} in collection: {}", SerializationUtils.serializeToJsonSafely(mappedQuery), mappedFields, entityClass, collectionName);
        }
        return this.executeFindMultiInternal(new FindCallback(mappedQuery, mappedFields, null), preparer != null ? preparer : CursorPreparer.NO_OP_PREPARER, objectCallback, collectionName);
    }

    <S, T> List<T> doFind(String collectionName, Document query, Document fields, Class<S> sourceClass, Class<T> targetClass, CursorPreparer preparer) {
        MongoPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)sourceClass));
        QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(new BasicQuery(query, fields));
        Document mappedFields = queryContext.getMappedFields(entity, targetClass, this.projectionFactory);
        Document mappedQuery = queryContext.getMappedQuery(entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("find using query: {} fields: {} for class: {} in collection: {}", SerializationUtils.serializeToJsonSafely(mappedQuery), mappedFields, sourceClass, collectionName);
        }
        return this.executeFindMultiInternal(new FindCallback(mappedQuery, mappedFields, null), preparer, new ProjectingReadCallback<S, T>(this.mongoConverter, sourceClass, targetClass, collectionName), collectionName);
    }

    protected Document convertToDocument(@Nullable CollectionOptions collectionOptions, Class<?> targetType) {
        Document doc = this.convertToDocument(collectionOptions);
        if (collectionOptions != null) {
            collectionOptions.getValidationOptions().ifPresent(it -> it.getValidator().ifPresent(val -> doc.put("validator", (Object)this.getMappedValidator((Validator)val, targetType))));
            collectionOptions.getTimeSeriesOptions().map(this.operations.forType(targetType)::mapTimeSeriesOptions).ifPresent(it -> {
                Document timeseries = new Document("timeField", it.getTimeField());
                if (StringUtils.hasText(it.getMetaField())) {
                    timeseries.append("metaField", it.getMetaField());
                }
                if (!Granularity.DEFAULT.equals(it.getGranularity())) {
                    timeseries.append("granularity", it.getGranularity().name().toLowerCase());
                }
                doc.put("timeseries", (Object)timeseries);
            });
        }
        return doc;
    }

    @Deprecated
    protected Document convertToDocument(@Nullable CollectionOptions collectionOptions) {
        Document document = new Document();
        if (collectionOptions != null) {
            collectionOptions.getCapped().ifPresent(val -> document.put("capped", val));
            collectionOptions.getSize().ifPresent(val -> document.put("size", val));
            collectionOptions.getMaxDocuments().ifPresent(val -> document.put("max", val));
            collectionOptions.getCollation().ifPresent(val -> document.append("collation", val.toDocument()));
            collectionOptions.getValidationOptions().ifPresent(it -> {
                it.getValidationLevel().ifPresent(val -> document.append("validationLevel", val.getValue()));
                it.getValidationAction().ifPresent(val -> document.append("validationAction", val.getValue()));
                it.getValidator().ifPresent(val -> document.append("validator", this.getMappedValidator((Validator)val, Object.class)));
            });
        }
        return document;
    }

    Document getMappedValidator(Validator validator, Class<?> domainType) {
        Document validationRules = validator.toDocument();
        if (validationRules.containsKey("$jsonSchema")) {
            return this.schemaMapper.mapSchema(validationRules, domainType);
        }
        return this.queryMapper.getMappedObject((Bson)validationRules, this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)domainType)));
    }

    protected <T> T doFindAndRemove(String collectionName, Document query, Document fields, Document sort, @Nullable Collation collation, Class<T> entityClass) {
        MongoConverter readerToUse = this.mongoConverter;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("findAndRemove using query: {} fields: {} sort: {} for class: {} in collection: {}", SerializationUtils.serializeToJsonSafely(query), fields, sort, entityClass, collectionName);
        }
        MongoPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)entityClass));
        return (T)this.executeFindOneInternal(new FindAndRemoveCallback(this.queryMapper.getMappedObject((Bson)query, entity), fields, sort, collation), new ReadDocumentCallback<Object>(readerToUse, entityClass, collectionName), collectionName);
    }

    protected <T> T doFindAndModify(String collectionName, Document query, Document fields, Document sort, Class<T> entityClass, UpdateDefinition update, @Nullable FindAndModifyOptions options) {
        Object mappedUpdate;
        MongoConverter readerToUse = this.mongoConverter;
        if (options == null) {
            options = new FindAndModifyOptions();
        }
        MongoPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)entityClass));
        QueryOperations.UpdateContext updateContext = this.queryOperations.updateSingleContext(update, query, false);
        updateContext.increaseVersionForUpdateIfNecessary(entity);
        Document mappedQuery = updateContext.getMappedQuery(entity);
        Object object = mappedUpdate = updateContext.isAggregationUpdate() ? updateContext.getUpdatePipeline(entityClass) : updateContext.getMappedUpdate(entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("findAndModify using query: {} fields: {} sort: {} for class: {} and update: {} in collection: {}", SerializationUtils.serializeToJsonSafely(mappedQuery), fields, sort, entityClass, SerializationUtils.serializeToJsonSafely(mappedUpdate), collectionName);
        }
        return (T)this.executeFindOneInternal(new FindAndModifyCallback(mappedQuery, fields, sort, mappedUpdate, update.getArrayFilters().stream().map(UpdateDefinition.ArrayFilter::asDocument).collect(Collectors.toList()), options), new ReadDocumentCallback<Object>(readerToUse, entityClass, collectionName), collectionName);
    }

    @Nullable
    protected <T> T doFindAndReplace(String collectionName, Document mappedQuery, Document mappedFields, Document mappedSort, @Nullable com.mongodb.client.model.Collation collation, Class<?> entityType, Document replacement, FindAndReplaceOptions options, Class<T> resultType) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("findAndReplace using query: {} fields: {} sort: {} for class: {} and replacement: {} in collection: {}", SerializationUtils.serializeToJsonSafely(mappedQuery), SerializationUtils.serializeToJsonSafely(mappedFields), SerializationUtils.serializeToJsonSafely(mappedSort), entityType, SerializationUtils.serializeToJsonSafely(replacement), collectionName);
        }
        return this.executeFindOneInternal(new FindAndReplaceCallback(mappedQuery, mappedFields, mappedSort, replacement, collation, options), new ProjectingReadCallback(this.mongoConverter, entityType, resultType, collectionName), collectionName);
    }

    protected <T> T populateIdIfNecessary(T savedObject, Object id) {
        return this.operations.forEntity(savedObject, this.mongoConverter.getConversionService()).populateIdIfNecessary(id);
    }

    private MongoCollection<Document> getAndPrepareCollection(MongoDatabase db, String collectionName) {
        try {
            MongoCollection<Document> collection = db.getCollection(collectionName, Document.class);
            collection = this.prepareCollection(collection);
            return collection;
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Nullable
    private <T> T executeFindOneInternal(CollectionCallback<Document> collectionCallback, DocumentCallback<T> documentCallback, String collectionName) {
        try {
            Document document = collectionCallback.doInCollection(this.getAndPrepareCollection(this.doGetDatabase(), collectionName));
            return document != null ? (T)documentCallback.doWith(document) : null;
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> List<T> executeFindMultiInternal(CollectionCallback<FindIterable<Document>> collectionCallback, CursorPreparer preparer, DocumentCallback<T> documentCallback, String collectionName) {
        try (Iterator cursor = preparer.initiateFind(this.getAndPrepareCollection(this.doGetDatabase(), collectionName), collectionCallback::doInCollection).iterator();){
            ArrayList<T> result = new ArrayList<T>();
            while (cursor.hasNext()) {
                Document object = (Document)cursor.next();
                result.add(documentCallback.doWith(object));
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    private void executeQueryInternal(CollectionCallback<FindIterable<Document>> collectionCallback, CursorPreparer preparer, DocumentCallbackHandler callbackHandler, String collectionName) {
        try (Iterator cursor = preparer.initiateFind(this.getAndPrepareCollection(this.doGetDatabase(), collectionName), collectionCallback::doInCollection).iterator();){
            while (cursor.hasNext()) {
                callbackHandler.processDocument((Document)cursor.next());
            }
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    @Nullable
    private MongoPersistentEntity<?> getPersistentEntity(@Nullable Class<?> type) {
        return type != null ? this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)type)) : null;
    }

    private static MongoConverter getDefaultMongoConverter(MongoDatabaseFactory factory) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MongoCustomConversions conversions = new MongoCustomConversions(Collections.emptyList());
        MongoMappingContext mappingContext = new MongoMappingContext();
        mappingContext.setSimpleTypeHolder(conversions.getSimpleTypeHolder());
        mappingContext.afterPropertiesSet();
        MappingMongoConverter converter = new MappingMongoConverter(dbRefResolver, mappingContext);
        converter.setCustomConversions(conversions);
        converter.setCodecRegistryProvider(factory);
        converter.afterPropertiesSet();
        return converter;
    }

    private Document getMappedSortObject(Query query, Class<?> type) {
        if (query == null || ObjectUtils.isEmpty(query.getSortObject())) {
            return null;
        }
        return this.queryMapper.getMappedSort(query.getSortObject(), this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)type)));
    }

    static RuntimeException potentiallyConvertRuntimeException(RuntimeException ex, PersistenceExceptionTranslator exceptionTranslator) {
        DataAccessException resolved = exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    @Deprecated
    public MongoDatabaseFactory getMongoDbFactory() {
        return this.getMongoDatabaseFactory();
    }

    public MongoDatabaseFactory getMongoDatabaseFactory() {
        return this.mongoDbFactory;
    }

    static class SessionBoundMongoTemplate
    extends MongoTemplate {
        private final MongoTemplate delegate;
        private final ClientSession session;

        SessionBoundMongoTemplate(ClientSession session, MongoTemplate that) {
            super(that.getMongoDbFactory().withSession(session), that);
            this.delegate = that;
            this.session = session;
        }

        @Override
        public MongoCollection<Document> getCollection(String collectionName) {
            return this.delegate.getCollection(collectionName);
        }

        @Override
        public MongoDatabase getDb() {
            return this.delegate.getDb();
        }
    }

    static class CloseableIterableCursorAdapter<T>
    implements CloseableIterator<T> {
        @Nullable
        private volatile MongoCursor<Document> cursor;
        private PersistenceExceptionTranslator exceptionTranslator;
        private DocumentCallback<T> objectReadCallback;

        CloseableIterableCursorAdapter(MongoIterable<Document> cursor, PersistenceExceptionTranslator exceptionTranslator, DocumentCallback<T> objectReadCallback) {
            this.cursor = cursor.iterator();
            this.exceptionTranslator = exceptionTranslator;
            this.objectReadCallback = objectReadCallback;
        }

        CloseableIterableCursorAdapter(MongoCursor<Document> cursor, PersistenceExceptionTranslator exceptionTranslator, DocumentCallback<T> objectReadCallback) {
            this.cursor = cursor;
            this.exceptionTranslator = exceptionTranslator;
            this.objectReadCallback = objectReadCallback;
        }

        @Override
        public boolean hasNext() {
            MongoCursor<Document> cursor = this.cursor;
            if (cursor == null) {
                return false;
            }
            try {
                return cursor.hasNext();
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
        }

        @Override
        @Nullable
        public T next() {
            if (this.cursor == null) {
                return null;
            }
            try {
                Document item = this.cursor.next();
                return this.objectReadCallback.doWith(item);
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
        }

        @Override
        public void close() {
            MongoCursor<Document> c = this.cursor;
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
            finally {
                this.cursor = null;
                this.exceptionTranslator = null;
                this.objectReadCallback = null;
            }
        }
    }

    static class GeoNearResultDocumentCallback<T>
    implements DocumentCallback<GeoResult<T>> {
        private final String distanceField;
        private final DocumentCallback<T> delegate;
        private final Metric metric;

        GeoNearResultDocumentCallback(String distanceField, DocumentCallback<T> delegate, Metric metric) {
            Assert.notNull(delegate, "DocumentCallback must not be null!");
            this.distanceField = distanceField;
            this.delegate = delegate;
            this.metric = metric;
        }

        @Override
        public GeoResult<T> doWith(Document object) {
            double distance = Double.NaN;
            if (object.containsKey(this.distanceField)) {
                distance = NumberUtils.convertNumberToTargetClass((Number)((Object)object.get((Object)this.distanceField, Number.class)), Double.class);
            }
            T doWith = this.delegate.doWith(object);
            return new GeoResult<T>(doWith, new Distance(distance, this.metric));
        }
    }

    class QueryCursorPreparer
    implements CursorPreparer {
        private final Query query;
        @Nullable
        private final Class<?> type;

        QueryCursorPreparer(@Nullable Query query, Class<?> type) {
            this.query = query;
            this.type = type;
        }

        @Override
        public FindIterable<Document> prepare(FindIterable<Document> iterable) {
            MongoIterable<Document> cursorToUse = iterable;
            MongoTemplate.this.operations.forType(this.type).getCollation(this.query).map(Collation::toMongoCollation).ifPresent(arg_0 -> cursorToUse.collation(arg_0));
            Meta meta = this.query.getMeta();
            if (this.query.getSkip() <= 0L && this.query.getLimit() <= 0 && ObjectUtils.isEmpty(this.query.getSortObject()) && !StringUtils.hasText(this.query.getHint()) && !meta.hasValues() && !this.query.getCollation().isPresent()) {
                return cursorToUse;
            }
            try {
                if (this.query.getSkip() > 0L) {
                    cursorToUse = cursorToUse.skip((int)this.query.getSkip());
                }
                if (this.query.getLimit() > 0) {
                    cursorToUse = cursorToUse.limit(this.query.getLimit());
                }
                if (!ObjectUtils.isEmpty(this.query.getSortObject())) {
                    Document sort = this.type != null ? MongoTemplate.this.getMappedSortObject(this.query, this.type) : this.query.getSortObject();
                    cursorToUse = cursorToUse.sort(sort);
                }
                if (StringUtils.hasText(this.query.getHint())) {
                    String hint = this.query.getHint();
                    cursorToUse = BsonUtils.isJsonDocument(hint) ? cursorToUse.hint(BsonUtils.parse(hint, MongoTemplate.this.mongoDbFactory)) : cursorToUse.hintString(hint);
                }
                if (meta.hasValues()) {
                    if (StringUtils.hasText(meta.getComment())) {
                        cursorToUse = cursorToUse.comment(meta.getComment());
                    }
                    if (meta.getMaxTimeMsec() != null) {
                        cursorToUse = cursorToUse.maxTime(meta.getMaxTimeMsec(), TimeUnit.MILLISECONDS);
                    }
                    if (meta.getCursorBatchSize() != null) {
                        cursorToUse = cursorToUse.batchSize(meta.getCursorBatchSize());
                    }
                    if (meta.getAllowDiskUse() != null) {
                        cursorToUse = cursorToUse.allowDiskUse(meta.getAllowDiskUse());
                    }
                    block7: for (Meta.CursorOption option : meta.getFlags()) {
                        switch (option) {
                            case NO_TIMEOUT: {
                                cursorToUse = cursorToUse.noCursorTimeout(true);
                                continue block7;
                            }
                            case PARTIAL: {
                                cursorToUse = cursorToUse.partial(true);
                                continue block7;
                            }
                            case SECONDARY_READS: 
                            case SLAVE_OK: {
                                continue block7;
                            }
                        }
                        throw new IllegalArgumentException(String.format("%s is no supported flag.", new Object[]{option}));
                    }
                }
            }
            catch (RuntimeException e) {
                throw MongoTemplate.potentiallyConvertRuntimeException(e, MongoTemplate.this.exceptionTranslator);
            }
            return cursorToUse;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.query.getMeta().getFlags().contains((Object)Meta.CursorOption.SECONDARY_READS) || this.query.getMeta().getFlags().contains((Object)Meta.CursorOption.SLAVE_OK) ? ReadPreference.primaryPreferred() : null;
        }
    }

    private class ProjectingReadCallback<S, T>
    implements DocumentCallback<T> {
        private final EntityReader<Object, Bson> reader;
        private final Class<S> entityType;
        private final Class<T> targetType;
        private final String collectionName;

        ProjectingReadCallback(EntityReader<Object, Bson> reader, Class<S> entityType, Class<T> targetType, String collectionName) {
            this.reader = reader;
            this.entityType = entityType;
            this.targetType = targetType;
            this.collectionName = collectionName;
        }

        @Override
        public T doWith(Document document) {
            if (document == null) {
                return null;
            }
            Class<S> typeToRead = this.targetType.isInterface() || this.targetType.isAssignableFrom(this.entityType) ? this.entityType : this.targetType;
            MongoTemplate.this.maybeEmitEvent(new AfterLoadEvent<T>(document, this.targetType, this.collectionName));
            S entity = this.reader.read(typeToRead, document);
            if (entity == null) {
                throw new MappingException(String.format("EntityReader %s returned null", this.reader));
            }
            S result = this.targetType.isInterface() ? MongoTemplate.this.projectionFactory.createProjection((Class)this.targetType, (Object)entity) : entity;
            MongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<S>(document, result, this.collectionName));
            return (T)MongoTemplate.this.maybeCallAfterConvert(result, document, this.collectionName);
        }
    }

    private class ReadDocumentCallback<T>
    implements DocumentCallback<T> {
        private final EntityReader<? super T, Bson> reader;
        private final Class<T> type;
        private final String collectionName;

        ReadDocumentCallback(EntityReader<? super T, Bson> reader, Class<T> type, String collectionName) {
            this.reader = reader;
            this.type = type;
            this.collectionName = collectionName;
        }

        @Override
        public T doWith(Document document) {
            MongoTemplate.this.maybeEmitEvent(new AfterLoadEvent<T>(document, this.type, this.collectionName));
            T entity = this.reader.read(this.type, document);
            if (entity == null) {
                throw new MappingException(String.format("EntityReader %s returned null", this.reader));
            }
            MongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<T>(document, entity, this.collectionName));
            entity = MongoTemplate.this.maybeCallAfterConvert(entity, document, this.collectionName);
            return entity;
        }
    }

    static interface DocumentCallback<T> {
        public T doWith(Document var1);
    }

    private static class FindAndReplaceCallback
    implements CollectionCallback<Document> {
        private final Document query;
        private final Document fields;
        private final Document sort;
        private final Document update;
        @Nullable
        private final com.mongodb.client.model.Collation collation;
        private final FindAndReplaceOptions options;

        FindAndReplaceCallback(Document query, Document fields, Document sort, Document update, @Nullable com.mongodb.client.model.Collation collation, FindAndReplaceOptions options) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.update = update;
            this.options = options;
            this.collation = collation;
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindOneAndReplaceOptions opts = new FindOneAndReplaceOptions();
            opts.sort(this.sort);
            opts.collation(this.collation);
            opts.projection(this.fields);
            if (this.options.isUpsert()) {
                opts.upsert(true);
            }
            if (this.options.isReturnNew()) {
                opts.returnDocument(ReturnDocument.AFTER);
            }
            return collection.findOneAndReplace(this.query, this.update, opts);
        }
    }

    private static class FindAndModifyCallback
    implements CollectionCallback<Document> {
        private final Document query;
        private final Document fields;
        private final Document sort;
        private final Object update;
        private final List<Document> arrayFilters;
        private final FindAndModifyOptions options;

        FindAndModifyCallback(Document query, Document fields, Document sort, Object update, List<Document> arrayFilters, FindAndModifyOptions options) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.update = update;
            this.arrayFilters = arrayFilters;
            this.options = options;
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindOneAndUpdateOptions opts = new FindOneAndUpdateOptions();
            opts.sort(this.sort);
            if (this.options.isUpsert()) {
                opts.upsert(true);
            }
            opts.projection(this.fields);
            if (this.options.isReturnNew()) {
                opts.returnDocument(ReturnDocument.AFTER);
            }
            this.options.getCollation().map(Collation::toMongoCollation).ifPresent(opts::collation);
            if (!this.arrayFilters.isEmpty()) {
                opts.arrayFilters(this.arrayFilters);
            }
            if (this.update instanceof Document) {
                return collection.findOneAndUpdate((Bson)this.query, (Bson)((Document)this.update), opts);
            }
            if (this.update instanceof List) {
                return collection.findOneAndUpdate((Bson)this.query, (List)this.update, opts);
            }
            throw new IllegalArgumentException(String.format("Using %s is not supported in findOneAndUpdate", this.update));
        }
    }

    private static class FindAndRemoveCallback
    implements CollectionCallback<Document> {
        private final Document query;
        private final Document fields;
        private final Document sort;
        private final Optional<Collation> collation;

        FindAndRemoveCallback(Document query, Document fields, Document sort, @Nullable Collation collation) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.collation = Optional.ofNullable(collation);
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindOneAndDeleteOptions opts = new FindOneAndDeleteOptions().sort(this.sort).projection(this.fields);
            this.collation.map(Collation::toMongoCollation).ifPresent(opts::collation);
            return collection.findOneAndDelete(this.query, opts);
        }
    }

    private class ExistsCallback
    implements CollectionCallback<Boolean> {
        private final Document mappedQuery;
        private final com.mongodb.client.model.Collation collation;

        ExistsCallback(Document mappedQuery, com.mongodb.client.model.Collation collation) {
            this.mappedQuery = mappedQuery;
            this.collation = collation;
        }

        @Override
        public Boolean doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            return MongoTemplate.this.doCount(collection.getNamespace().getCollectionName(), this.mappedQuery, new CountOptions().limit(1).collation(this.collation)) > 0L;
        }
    }

    private static class FindCallback
    implements CollectionCallback<FindIterable<Document>> {
        private final Document query;
        private final Document fields;
        @Nullable
        private final com.mongodb.client.model.Collation collation;

        public FindCallback(Document query, Document fields, @Nullable com.mongodb.client.model.Collation collation) {
            Assert.notNull((Object)query, "Query must not be null!");
            Assert.notNull((Object)fields, "Fields must not be null!");
            this.query = query;
            this.fields = fields;
            this.collation = collation;
        }

        @Override
        public FindIterable<Document> doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindIterable<Document> findIterable = collection.find(this.query, Document.class).projection(this.fields);
            if (this.collation != null) {
                findIterable = findIterable.collation(this.collation);
            }
            return findIterable;
        }
    }

    private static class FindOneCallback
    implements CollectionCallback<Document> {
        private final Document query;
        private final Optional<Document> fields;
        private final CursorPreparer cursorPreparer;

        FindOneCallback(Document query, Document fields, CursorPreparer preparer) {
            this.query = query;
            this.fields = Optional.of(fields).filter(it -> !ObjectUtils.isEmpty(fields));
            this.cursorPreparer = preparer;
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindIterable<Document> iterable = this.cursorPreparer.initiateFind(collection, col -> col.find(this.query, Document.class));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("findOne using query: {} fields: {} in db.collection: {}", SerializationUtils.serializeToJsonSafely(this.query), SerializationUtils.serializeToJsonSafely(this.fields.orElseGet(Document::new)), collection.getNamespace() != null ? collection.getNamespace().getFullName() : "n/a");
            }
            if (this.fields.isPresent()) {
                iterable = iterable.projection(this.fields.get());
            }
            return (Document)iterable.first();
        }
    }
}

