/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadPreference;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bson.Document;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.FluentMongoOperations;
import org.springframework.data.mongodb.core.ScriptOperations;
import org.springframework.data.mongodb.core.SessionCallback;
import org.springframework.data.mongodb.core.SessionScoped;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.mapreduce.GroupBy;
import org.springframework.data.mongodb.core.mapreduce.GroupByResults;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.mapreduce.MapReduceResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public interface MongoOperations
extends FluentMongoOperations {
    public String getCollectionName(Class<?> var1);

    public Document executeCommand(String var1);

    public Document executeCommand(Document var1);

    public Document executeCommand(Document var1, @Nullable ReadPreference var2);

    public void executeQuery(Query var1, String var2, DocumentCallbackHandler var3);

    @Nullable
    public <T> T execute(DbCallback<T> var1);

    @Nullable
    public <T> T execute(Class<?> var1, CollectionCallback<T> var2);

    @Nullable
    public <T> T execute(String var1, CollectionCallback<T> var2);

    public SessionScoped withSession(ClientSessionOptions var1);

    default public SessionScoped withSession(final Supplier<ClientSession> sessionProvider) {
        Assert.notNull(sessionProvider, "SessionProvider must not be null!");
        return new SessionScoped(){
            private final Object lock = new Object();
            @Nullable
            private ClientSession session = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T execute(SessionCallback<T> action, Consumer<ClientSession> onComplete) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.session == null) {
                        this.session = (ClientSession)sessionProvider.get();
                    }
                }
                try {
                    object = action.doInSession(MongoOperations.this.withSession(this.session));
                    return (T)object;
                }
                finally {
                    onComplete.accept(this.session);
                }
            }
        };
    }

    public MongoOperations withSession(ClientSession var1);

    public <T> CloseableIterator<T> stream(Query var1, Class<T> var2);

    public <T> CloseableIterator<T> stream(Query var1, Class<T> var2, String var3);

    public <T> MongoCollection<Document> createCollection(Class<T> var1);

    public <T> MongoCollection<Document> createCollection(Class<T> var1, @Nullable CollectionOptions var2);

    public MongoCollection<Document> createCollection(String var1);

    public MongoCollection<Document> createCollection(String var1, @Nullable CollectionOptions var2);

    public Set<String> getCollectionNames();

    public MongoCollection<Document> getCollection(String var1);

    public <T> boolean collectionExists(Class<T> var1);

    public boolean collectionExists(String var1);

    public <T> void dropCollection(Class<T> var1);

    public void dropCollection(String var1);

    public IndexOperations indexOps(String var1);

    public IndexOperations indexOps(Class<?> var1);

    @Deprecated
    public ScriptOperations scriptOps();

    public BulkOperations bulkOps(BulkOperations.BulkMode var1, String var2);

    public BulkOperations bulkOps(BulkOperations.BulkMode var1, Class<?> var2);

    public BulkOperations bulkOps(BulkOperations.BulkMode var1, @Nullable Class<?> var2, String var3);

    public <T> List<T> findAll(Class<T> var1);

    public <T> List<T> findAll(Class<T> var1, String var2);

    @Deprecated
    public <T> GroupByResults<T> group(String var1, GroupBy var2, Class<T> var3);

    @Deprecated
    public <T> GroupByResults<T> group(@Nullable Criteria var1, String var2, GroupBy var3, Class<T> var4);

    public <O> AggregationResults<O> aggregate(TypedAggregation<?> var1, String var2, Class<O> var3);

    public <O> AggregationResults<O> aggregate(TypedAggregation<?> var1, Class<O> var2);

    public <O> AggregationResults<O> aggregate(Aggregation var1, Class<?> var2, Class<O> var3);

    public <O> AggregationResults<O> aggregate(Aggregation var1, String var2, Class<O> var3);

    public <O> CloseableIterator<O> aggregateStream(TypedAggregation<?> var1, String var2, Class<O> var3);

    public <O> CloseableIterator<O> aggregateStream(TypedAggregation<?> var1, Class<O> var2);

    public <O> CloseableIterator<O> aggregateStream(Aggregation var1, Class<?> var2, Class<O> var3);

    public <O> CloseableIterator<O> aggregateStream(Aggregation var1, String var2, Class<O> var3);

    public <T> MapReduceResults<T> mapReduce(String var1, String var2, String var3, Class<T> var4);

    public <T> MapReduceResults<T> mapReduce(String var1, String var2, String var3, @Nullable MapReduceOptions var4, Class<T> var5);

    public <T> MapReduceResults<T> mapReduce(Query var1, String var2, String var3, String var4, Class<T> var5);

    public <T> MapReduceResults<T> mapReduce(Query var1, String var2, String var3, String var4, @Nullable MapReduceOptions var5, Class<T> var6);

    @Deprecated
    public <T> GeoResults<T> geoNear(NearQuery var1, Class<T> var2);

    @Deprecated
    public <T> GeoResults<T> geoNear(NearQuery var1, Class<T> var2, String var3);

    @Nullable
    public <T> T findOne(Query var1, Class<T> var2);

    @Nullable
    public <T> T findOne(Query var1, Class<T> var2, String var3);

    public boolean exists(Query var1, String var2);

    public boolean exists(Query var1, Class<?> var2);

    public boolean exists(Query var1, @Nullable Class<?> var2, String var3);

    public <T> List<T> find(Query var1, Class<T> var2);

    public <T> List<T> find(Query var1, Class<T> var2, String var3);

    @Nullable
    public <T> T findById(Object var1, Class<T> var2);

    @Nullable
    public <T> T findById(Object var1, Class<T> var2, String var3);

    default public <T> List<T> findDistinct(String field, Class<?> entityClass, Class<T> resultClass) {
        return this.findDistinct(new Query(), field, entityClass, resultClass);
    }

    public <T> List<T> findDistinct(Query var1, String var2, Class<?> var3, Class<T> var4);

    public <T> List<T> findDistinct(Query var1, String var2, String var3, Class<?> var4, Class<T> var5);

    default public <T> List<T> findDistinct(Query query, String field, String collection, Class<T> resultClass) {
        return this.findDistinct(query, field, collection, Object.class, resultClass);
    }

    @Nullable
    public <T> T findAndModify(Query var1, UpdateDefinition var2, Class<T> var3);

    @Nullable
    public <T> T findAndModify(Query var1, UpdateDefinition var2, Class<T> var3, String var4);

    @Nullable
    public <T> T findAndModify(Query var1, UpdateDefinition var2, FindAndModifyOptions var3, Class<T> var4);

    @Nullable
    public <T> T findAndModify(Query var1, UpdateDefinition var2, FindAndModifyOptions var3, Class<T> var4, String var5);

    @Nullable
    default public <T> T findAndReplace(Query query, T replacement) {
        return this.findAndReplace(query, replacement, FindAndReplaceOptions.empty());
    }

    @Nullable
    default public <T> T findAndReplace(Query query, T replacement, String collectionName) {
        return this.findAndReplace(query, replacement, FindAndReplaceOptions.empty(), collectionName);
    }

    @Nullable
    default public <T> T findAndReplace(Query query, T replacement, FindAndReplaceOptions options) {
        return this.findAndReplace(query, replacement, options, this.getCollectionName(ClassUtils.getUserClass(replacement)));
    }

    @Nullable
    default public <T> T findAndReplace(Query query, T replacement, FindAndReplaceOptions options, String collectionName) {
        Assert.notNull(replacement, "Replacement must not be null!");
        return this.findAndReplace(query, replacement, options, ClassUtils.getUserClass(replacement), collectionName);
    }

    @Nullable
    default public <T> T findAndReplace(Query query, T replacement, FindAndReplaceOptions options, Class<T> entityType, String collectionName) {
        return this.findAndReplace(query, replacement, options, entityType, collectionName, entityType);
    }

    @Nullable
    default public <S, T> T findAndReplace(Query query, S replacement, FindAndReplaceOptions options, Class<S> entityType, Class<T> resultType) {
        return this.findAndReplace(query, replacement, options, entityType, this.getCollectionName(ClassUtils.getUserClass(entityType)), resultType);
    }

    @Nullable
    public <S, T> T findAndReplace(Query var1, S var2, FindAndReplaceOptions var3, Class<S> var4, String var5, Class<T> var6);

    @Nullable
    public <T> T findAndRemove(Query var1, Class<T> var2);

    @Nullable
    public <T> T findAndRemove(Query var1, Class<T> var2, String var3);

    public long count(Query var1, Class<?> var2);

    public long count(Query var1, String var2);

    default public long estimatedCount(Class<?> entityClass) {
        Assert.notNull(entityClass, "Entity class must not be null!");
        return this.estimatedCount(this.getCollectionName(entityClass));
    }

    public long estimatedCount(String var1);

    public long count(Query var1, @Nullable Class<?> var2, String var3);

    public <T> T insert(T var1);

    public <T> T insert(T var1, String var2);

    public <T> Collection<T> insert(Collection<? extends T> var1, Class<?> var2);

    public <T> Collection<T> insert(Collection<? extends T> var1, String var2);

    public <T> Collection<T> insertAll(Collection<? extends T> var1);

    public <T> T save(T var1);

    public <T> T save(T var1, String var2);

    public UpdateResult upsert(Query var1, UpdateDefinition var2, Class<?> var3);

    public UpdateResult upsert(Query var1, UpdateDefinition var2, String var3);

    public UpdateResult upsert(Query var1, UpdateDefinition var2, Class<?> var3, String var4);

    public UpdateResult updateFirst(Query var1, UpdateDefinition var2, Class<?> var3);

    public UpdateResult updateFirst(Query var1, UpdateDefinition var2, String var3);

    public UpdateResult updateFirst(Query var1, UpdateDefinition var2, Class<?> var3, String var4);

    public UpdateResult updateMulti(Query var1, UpdateDefinition var2, Class<?> var3);

    public UpdateResult updateMulti(Query var1, UpdateDefinition var2, String var3);

    public UpdateResult updateMulti(Query var1, UpdateDefinition var2, Class<?> var3, String var4);

    public DeleteResult remove(Object var1);

    public DeleteResult remove(Object var1, String var2);

    public DeleteResult remove(Query var1, Class<?> var2);

    public DeleteResult remove(Query var1, Class<?> var2, String var3);

    public DeleteResult remove(Query var1, String var2);

    public <T> List<T> findAllAndRemove(Query var1, String var2);

    public <T> List<T> findAllAndRemove(Query var1, Class<T> var2);

    public <T> List<T> findAllAndRemove(Query var1, Class<T> var2, String var3);

    public MongoConverter getConverter();
}

