/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.UuidRepresentation;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.SpringDataMongoDB;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoClientFactoryBean
extends AbstractFactoryBean<MongoClient>
implements PersistenceExceptionTranslator {
    private static final PersistenceExceptionTranslator DEFAULT_EXCEPTION_TRANSLATOR = new MongoExceptionTranslator();
    @Nullable
    private MongoClientSettings mongoClientSettings;
    @Nullable
    private String host;
    @Nullable
    private Integer port;
    @Nullable
    private List<MongoCredential> credential = null;
    @Nullable
    private ConnectionString connectionString;
    @Nullable
    private String replicaSet = null;
    private PersistenceExceptionTranslator exceptionTranslator = DEFAULT_EXCEPTION_TRANSLATOR;

    public void setMongoClientSettings(@Nullable MongoClientSettings mongoClientOptions) {
        this.mongoClientSettings = mongoClientOptions;
    }

    public void setCredential(@Nullable MongoCredential[] credential) {
        this.credential = Arrays.asList(credential);
    }

    public void setHost(@Nullable String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConnectionString(@Nullable ConnectionString connectionString) {
        this.connectionString = connectionString;
    }

    public void setReplicaSet(@Nullable String replicaSet) {
        this.replicaSet = replicaSet;
    }

    public void setExceptionTranslator(@Nullable PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? DEFAULT_EXCEPTION_TRANSLATOR : exceptionTranslator;
    }

    @Override
    public Class<? extends MongoClient> getObjectType() {
        return MongoClient.class;
    }

    @Override
    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    @Override
    protected MongoClient createInstance() throws Exception {
        return this.createMongoClient(this.computeClientSetting());
    }

    protected MongoClientSettings computeClientSetting() {
        if (this.connectionString != null && (StringUtils.hasText(this.host) || this.port != null)) {
            throw new IllegalStateException("ConnectionString and host/port configuration exclude one another!");
        }
        ConnectionString connectionString = this.connectionString != null ? this.connectionString : new ConnectionString(String.format("mongodb://%s:%s", this.getOrDefault(this.host, ServerAddress.defaultHost()), this.getOrDefault(this.port, "" + ServerAddress.defaultPort())));
        MongoClientSettings.Builder builder = MongoClientSettings.builder().applyConnectionString(connectionString);
        builder.uuidRepresentation(UuidRepresentation.JAVA_LEGACY);
        if (this.mongoClientSettings != null) {
            MongoClientSettings defaultSettings = MongoClientSettings.builder().build();
            SslSettings sslSettings = this.mongoClientSettings.getSslSettings();
            ClusterSettings clusterSettings = this.mongoClientSettings.getClusterSettings();
            ConnectionPoolSettings connectionPoolSettings = this.mongoClientSettings.getConnectionPoolSettings();
            SocketSettings socketSettings = this.mongoClientSettings.getSocketSettings();
            ServerSettings serverSettings = this.mongoClientSettings.getServerSettings();
            builder = builder.applicationName(this.computeSettingsValue(defaultSettings.getApplicationName(), this.mongoClientSettings.getApplicationName(), connectionString.getApplicationName())).applyToSslSettings(settings -> {
                this.applySettings(settings::enabled, this.computeSettingsValue(SslSettings::isEnabled, defaultSettings.getSslSettings(), sslSettings, connectionString.getSslEnabled()));
                this.applySettings(settings::invalidHostNameAllowed, this.computeSettingsValue(SslSettings::isInvalidHostNameAllowed, defaultSettings.getSslSettings(), sslSettings, connectionString.getSslInvalidHostnameAllowed()));
                settings.context(sslSettings.getContext());
            }).applyToClusterSettings(settings -> {
                this.applySettings(settings::hosts, this.computeSettingsValue(ClusterSettings::getHosts, defaultSettings.getClusterSettings(), clusterSettings, connectionString.getHosts().stream().map(ServerAddress::new).collect(Collectors.toList())));
                this.applySettings(settings::requiredReplicaSetName, this.computeSettingsValue(ClusterSettings::getRequiredReplicaSetName, defaultSettings.getClusterSettings(), clusterSettings, connectionString.getRequiredReplicaSetName()));
                this.applySettings(settings::srvHost, this.computeSettingsValue(ClusterSettings::getSrvHost, defaultSettings.getClusterSettings(), clusterSettings, null));
                this.applySettings(settings::mode, this.computeSettingsValue(ClusterSettings::getMode, defaultSettings.getClusterSettings(), clusterSettings, null));
                this.applySettings(it -> settings.localThreshold(it.longValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getLocalThreshold(TimeUnit.MILLISECONDS), defaultSettings.getClusterSettings(), clusterSettings, connectionString.getLocalThreshold()));
                this.applySettings(settings::requiredClusterType, this.computeSettingsValue(ClusterSettings::getRequiredClusterType, defaultSettings.getClusterSettings(), clusterSettings, null));
                this.applySettings(it -> settings.serverSelectionTimeout(it.longValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getServerSelectionTimeout(TimeUnit.MILLISECONDS), defaultSettings.getClusterSettings(), clusterSettings, connectionString.getServerSelectionTimeout()));
                this.applySettings(settings::serverSelector, this.computeSettingsValue(ClusterSettings::getServerSelector, defaultSettings.getClusterSettings(), clusterSettings, null));
                List clusterListeners = this.computeSettingsValue(ClusterSettings::getClusterListeners, defaultSettings.getClusterSettings(), clusterSettings, null);
                if (clusterListeners != null) {
                    clusterListeners.forEach(settings::addClusterListener);
                }
            }).applyToConnectionPoolSettings(settings -> {
                this.applySettings(it -> settings.maintenanceFrequency((long)it, TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getMaintenanceFrequency(TimeUnit.MILLISECONDS), defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, null));
                this.applySettings(it -> settings.maxConnectionIdleTime(it.longValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getMaxConnectionIdleTime(TimeUnit.MILLISECONDS), defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, connectionString.getMaxConnectionIdleTime()));
                this.applySettings(it -> settings.maxConnectionLifeTime(it.longValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getMaxConnectionLifeTime(TimeUnit.MILLISECONDS), defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, connectionString.getMaxConnectionLifeTime()));
                this.applySettings(it -> settings.maxWaitTime(it.longValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getMaxWaitTime(TimeUnit.MILLISECONDS), defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, connectionString.getMaxWaitTime()));
                this.applySettings(it -> settings.maintenanceInitialDelay((long)it, TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getMaintenanceInitialDelay(TimeUnit.MILLISECONDS), defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, null));
                this.applySettings(settings::minSize, this.computeSettingsValue(ConnectionPoolSettings::getMinSize, defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, connectionString.getMinConnectionPoolSize()));
                this.applySettings(settings::maxSize, this.computeSettingsValue(ConnectionPoolSettings::getMaxSize, defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, connectionString.getMaxConnectionPoolSize()));
            }).applyToSocketSettings(settings -> {
                this.applySettings(it -> settings.connectTimeout((int)it, TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getConnectTimeout(TimeUnit.MILLISECONDS), defaultSettings.getSocketSettings(), socketSettings, connectionString.getConnectTimeout()));
                this.applySettings(it -> settings.readTimeout((int)it, TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getReadTimeout(TimeUnit.MILLISECONDS), defaultSettings.getSocketSettings(), socketSettings, connectionString.getSocketTimeout()));
                this.applySettings(settings::receiveBufferSize, this.computeSettingsValue(SocketSettings::getReceiveBufferSize, defaultSettings.getSocketSettings(), socketSettings, null));
                this.applySettings(settings::sendBufferSize, this.computeSettingsValue(SocketSettings::getSendBufferSize, defaultSettings.getSocketSettings(), socketSettings, null));
            }).applyToServerSettings(settings -> {
                this.applySettings(it -> settings.minHeartbeatFrequency(it.intValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getMinHeartbeatFrequency(TimeUnit.MILLISECONDS), defaultSettings.getServerSettings(), serverSettings, null));
                this.applySettings(it -> settings.heartbeatFrequency(it.intValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getHeartbeatFrequency(TimeUnit.MILLISECONDS), defaultSettings.getServerSettings(), serverSettings, connectionString.getHeartbeatFrequency()));
                settings.applySettings(serverSettings);
            }).autoEncryptionSettings(this.mongoClientSettings.getAutoEncryptionSettings()).codecRegistry(this.mongoClientSettings.getCodecRegistry());
            this.applySettings(builder::readConcern, this.computeSettingsValue(defaultSettings.getReadConcern(), this.mongoClientSettings.getReadConcern(), connectionString.getReadConcern()));
            this.applySettings(builder::writeConcern, this.computeSettingsValue(defaultSettings.getWriteConcern(), this.mongoClientSettings.getWriteConcern(), connectionString.getWriteConcern()));
            this.applySettings(builder::readPreference, this.computeSettingsValue(defaultSettings.getReadPreference(), this.mongoClientSettings.getReadPreference(), connectionString.getReadPreference()));
            this.applySettings(builder::retryReads, this.computeSettingsValue(defaultSettings.getRetryReads(), this.mongoClientSettings.getRetryReads(), connectionString.getRetryReads()));
            this.applySettings(builder::retryWrites, this.computeSettingsValue(defaultSettings.getRetryWrites(), this.mongoClientSettings.getRetryWrites(), connectionString.getRetryWritesValue()));
            this.applySettings(builder::uuidRepresentation, this.computeSettingsValue(null, this.mongoClientSettings.getUuidRepresentation(), UuidRepresentation.JAVA_LEGACY));
        }
        if (!CollectionUtils.isEmpty(this.credential)) {
            builder = builder.credential(this.credential.iterator().next());
        }
        if (StringUtils.hasText(this.replicaSet)) {
            builder.applyToClusterSettings(settings -> settings.requiredReplicaSetName(this.replicaSet));
        }
        return builder.build();
    }

    private <T> void applySettings(Consumer<T> settingsBuilder, @Nullable T value) {
        if (ObjectUtils.isEmpty(value)) {
            return;
        }
        settingsBuilder.accept(value);
    }

    private <S, T> T computeSettingsValue(Function<S, T> function, S defaultValueHolder, S settingsValueHolder, @Nullable T connectionStringValue) {
        return this.computeSettingsValue(function.apply(defaultValueHolder), function.apply(settingsValueHolder), connectionStringValue);
    }

    private <T> T computeSettingsValue(T defaultValue, T fromSettings, T fromConnectionString) {
        boolean fromSettingsIsDefault = ObjectUtils.nullSafeEquals(defaultValue, fromSettings);
        boolean fromConnectionStringIsDefault = ObjectUtils.nullSafeEquals(defaultValue, fromConnectionString);
        if (!fromSettingsIsDefault) {
            return fromSettings;
        }
        return !fromConnectionStringIsDefault ? fromConnectionString : defaultValue;
    }

    @Override
    protected void destroyInstance(@Nullable MongoClient instance) throws Exception {
        if (instance != null) {
            instance.close();
        }
    }

    private MongoClient createMongoClient(MongoClientSettings settings) throws UnknownHostException {
        return MongoClients.create(settings, SpringDataMongoDB.driverInformation());
    }

    private String getOrDefault(Object value, String defaultValue) {
        return !StringUtils.isEmpty(value) ? value.toString() : defaultValue;
    }
}

