/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.StreamUtils;

public class MappedDocument {
    private static final String ID_FIELD = "_id";
    private static final Document ID_ONLY_PROJECTION = new Document("_id", 1);
    private final Document document;

    private MappedDocument(Document document) {
        this.document = document;
    }

    public static MappedDocument of(Document document) {
        return new MappedDocument(document);
    }

    public static Document getIdOnlyProjection() {
        return ID_ONLY_PROJECTION;
    }

    public static Document getIdIn(Collection<?> ids) {
        return new Document(ID_FIELD, new Document("$in", ids));
    }

    public static List<Object> toIds(Collection<Document> documents) {
        return documents.stream().map(it -> it.get(ID_FIELD)).collect(StreamUtils.toUnmodifiableList());
    }

    public boolean hasId() {
        return this.document.containsKey(ID_FIELD);
    }

    public boolean hasNonNullId() {
        return this.hasId() && this.document.get(ID_FIELD) != null;
    }

    public Object getId() {
        return this.document.get(ID_FIELD);
    }

    public <T> T getId(Class<T> type) {
        return (T)this.document.get((Object)ID_FIELD, type);
    }

    public boolean isIdPresent(Class<?> type) {
        return type.isInstance(this.getId());
    }

    public Bson getIdFilter() {
        return new Document(ID_FIELD, this.document.get(ID_FIELD));
    }

    public Object get(String key) {
        return this.document.get(key);
    }

    public UpdateDefinition updateWithoutId() {
        return new MappedUpdate(Update.fromDocument(this.document, ID_FIELD));
    }

    public Document getDocument() {
        return this.document;
    }

    class MappedUpdate
    implements UpdateDefinition {
        private final Update delegate;

        MappedUpdate(Update delegate) {
            this.delegate = delegate;
        }

        @Override
        public Document getUpdateObject() {
            return this.delegate.getUpdateObject();
        }

        @Override
        public boolean modifies(String key) {
            return this.delegate.modifies(key);
        }

        @Override
        public void inc(String version) {
            this.delegate.inc(version);
        }

        @Override
        public Boolean isIsolated() {
            return this.delegate.isIsolated();
        }

        @Override
        public List<UpdateDefinition.ArrayFilter> getArrayFilters() {
            return this.delegate.getArrayFilters();
        }

        @Override
        public boolean hasArrayFilters() {
            return this.delegate.hasArrayFilters();
        }
    }
}

