/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ReadPreference;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.function.Function;
import org.bson.Document;
import org.springframework.data.mongodb.core.ReadPreferenceAware;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface FindPublisherPreparer
extends ReadPreferenceAware {
    public static final FindPublisherPreparer NO_OP_PREPARER = findPublisher -> findPublisher;

    public FindPublisher<Document> prepare(FindPublisher<Document> var1);

    default public FindPublisher<Document> initiateFind(MongoCollection<Document> collection, Function<MongoCollection<Document>, FindPublisher<Document>> find) {
        Assert.notNull(collection, "Collection must not be null!");
        Assert.notNull(find, "Find function must not be null!");
        if (this.hasReadPreference()) {
            collection = collection.withReadPreference(this.getReadPreference());
        }
        return this.prepare(find.apply(collection));
    }

    @Override
    @Nullable
    default public ReadPreference getReadPreference() {
        return null;
    }
}

